/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.context;

import io.camunda.zeebe.broker.exporter.context.ExporterContext;
import io.camunda.zeebe.exporter.api.context.Configuration;
import io.camunda.zeebe.exporter.test.ExporterTestConfiguration;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tags;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExporterContextTest {
    private static final Logger LOG = LoggerFactory.getLogger(ExporterContextTest.class);

    public ExporterContext makeExporterContext(int partitionId, String exporterId, MeterRegistry underlying) {
        return new ExporterContext(LOG, (Configuration)new ExporterTestConfiguration(exporterId, Collections.emptyMap()), partitionId, underlying);
    }

    @Test
    void shouldAddTagsAndCleanupWhenClosed() {
        boolean partitionId = true;
        String exporterId = "MetricTestExporter";
        SimpleMeterRegistry underlyingMeterRegistry = new SimpleMeterRegistry();
        ExporterContext context = this.makeExporterContext(1, "MetricTestExporter", (MeterRegistry)underlyingMeterRegistry);
        MeterRegistry meterRegistry = context.getMeterRegistry();
        List<SimpleMeterRegistry> allRegistries = List.of(meterRegistry, underlyingMeterRegistry);
        Assertions.assertThat((int)meterRegistry.getMeters().size()).isZero().describedAs("Expected no metrics to be measured at start", new Object[0]);
        Timer timer = meterRegistry.timer("test", new String[0]);
        timer.record(11L, TimeUnit.MILLISECONDS);
        Tags expectedTags = Tags.of((String[])new String[]{"partition", "1", "exporterId", "MetricTestExporter"});
        allRegistries.forEach(mr -> Assertions.assertThat((long)mr.timer("test", (Iterable)expectedTags).count()).isOne().describedAs("Expected exactly 1 observed test sample counted", new Object[0]));
        context.close();
        allRegistries.forEach(mr -> Assertions.assertThat((long)mr.timer("test", (Iterable)expectedTags).count()).isZero().describedAs("Metrics should be removed from the registry when exporter is closed", new Object[0]));
    }
}

