/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.metrics;

import io.camunda.zeebe.broker.exporter.metrics.MetricsExporter;
import io.camunda.zeebe.broker.exporter.metrics.TtlKeyCache;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.exporter.api.context.Controller;
import io.camunda.zeebe.exporter.test.ExporterTestContext;
import io.camunda.zeebe.exporter.test.ExporterTestController;
import io.camunda.zeebe.msgpack.value.LongValue;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceRecord;
import io.camunda.zeebe.protocol.record.ImmutableRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.RecordValue;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobBatchIntent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.protocol.record.intent.ProcessInstanceIntent;
import io.camunda.zeebe.protocol.record.value.BpmnElementType;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Nested;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

class MetricsExporterTest {
    private final ExporterTestContext context = new ExporterTestContext();

    MetricsExporterTest() {
    }

    @Test
    void shouldObserveJobLifetime() throws Exception {
        MetricsExporter exporter = new MetricsExporter();
        exporter.configure((Context)this.context);
        exporter.open((Controller)new ExporterTestController());
        ((ListAssert)Assertions.assertThat((List)this.context.getMeterRegistry().getMeters()).describedAs("Expected no metrics to be measured at start", new Object[0])).allSatisfy(meter -> meter.match(g -> Assertions.assertThat((double)g.value()).isZero(), ignored -> null, t -> Assertions.assertThat((long)t.count()).isZero(), ignored -> null, ignored -> null, ignored -> null, ignored -> null, ignored -> null, ignored -> null));
        exporter.export((Record)ImmutableRecord.builder().withRecordType(RecordType.EVENT).withValueType(ValueType.JOB).withIntent((Intent)JobIntent.CREATED).withTimestamp(1651505728460L).withKey(Protocol.encodePartitionId((int)1, (long)1L)).build());
        JobBatchRecord jobBatch = new JobBatchRecord();
        ((LongValue)jobBatch.jobKeys().add()).setValue(Protocol.encodePartitionId((int)1, (long)1L));
        exporter.export((Record)ImmutableRecord.builder().withRecordType(RecordType.EVENT).withValueType(ValueType.JOB_BATCH).withIntent((Intent)JobBatchIntent.ACTIVATED).withTimestamp(1651505728465L).withKey(-1L).withValue((RecordValue)jobBatch).build());
        exporter.export((Record)ImmutableRecord.builder().withRecordType(RecordType.EVENT).withValueType(ValueType.JOB).withIntent((Intent)JobIntent.COMPLETED).withTimestamp(1651505729571L).withKey(Protocol.encodePartitionId((int)1, (long)1L)).build());
        Timer jobLifeTime = this.context.getMeterRegistry().timer("zeebe.job.life.time", new String[0]);
        Assertions.assertThat((long)jobLifeTime.count()).isOne().describedAs("Expected exactly 1 observed job_life_time sample counted", new Object[0]);
        Assertions.assertThat((boolean)Arrays.stream(jobLifeTime.takeSnapshot().histogramCounts()).anyMatch(bucket -> bucket.bucket(TimeUnit.SECONDS) == 2.5 && bucket.count() == 1.0)).isTrue().describedAs("Expected the correct job_life_time bucket to have counted the event", new Object[0]);
    }

    @Test
    void shouldCleanupProcessInstancesWithSameStartTime() throws Exception {
        TtlKeyCache processCache = new TtlKeyCache();
        MetricsExporter exporter = new MetricsExporter(processCache, new TtlKeyCache());
        ExporterTestController controller = new ExporterTestController();
        exporter.configure((Context)this.context);
        exporter.open((Controller)controller);
        exporter.export((Record)ImmutableRecord.builder().withRecordType(RecordType.EVENT).withValueType(ValueType.PROCESS_INSTANCE).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withTimestamp(1651505728460L).withKey(Protocol.encodePartitionId((int)1, (long)1L)).withValue((RecordValue)new ProcessInstanceRecord().setBpmnElementType(BpmnElementType.PROCESS)).build());
        exporter.export((Record)ImmutableRecord.builder().withRecordType(RecordType.EVENT).withValueType(ValueType.PROCESS_INSTANCE).withIntent((Intent)ProcessInstanceIntent.ELEMENT_ACTIVATING).withTimestamp(1651505728460L).withKey(Protocol.encodePartitionId((int)1, (long)2L)).withValue((RecordValue)new ProcessInstanceRecord().setBpmnElementType(BpmnElementType.PROCESS)).build());
        controller.runScheduledTasks(Duration.ofHours(1L));
        Assertions.assertThat((boolean)processCache.isEmpty()).isTrue();
    }

    @Test
    void shouldCleanupJobWithSameStartTime() throws Exception {
        TtlKeyCache jobCache = new TtlKeyCache();
        MetricsExporter exporter = new MetricsExporter();
        ExporterTestController controller = new ExporterTestController();
        exporter.configure((Context)this.context);
        exporter.open((Controller)controller);
        exporter.export((Record)ImmutableRecord.builder().withRecordType(RecordType.EVENT).withValueType(ValueType.JOB).withIntent((Intent)JobIntent.CREATED).withTimestamp(1651505729571L).withKey(Protocol.encodePartitionId((int)1, (long)1L)).build());
        exporter.export((Record)ImmutableRecord.builder().withRecordType(RecordType.EVENT).withValueType(ValueType.JOB).withIntent((Intent)JobIntent.CREATED).withTimestamp(1651505729571L).withKey(Protocol.encodePartitionId((int)1, (long)2L)).build());
        controller.runScheduledTasks(Duration.ofHours(1L));
        Assertions.assertThat((boolean)jobCache.isEmpty()).isTrue();
    }

    @Nested
    @DisplayName(value="MetricsExporter should configure a Filter")
    class FilterTest {
        FilterTest(MetricsExporterTest this$0) {
        }

        static Stream<TypeCombination> acceptedCombinations() {
            return Stream.of(new TypeCombination(RecordType.EVENT, ValueType.JOB), new TypeCombination(RecordType.EVENT, ValueType.JOB_BATCH), new TypeCombination(RecordType.EVENT, ValueType.PROCESS_INSTANCE));
        }

        static Stream<TypeCombination> rejectedCombinations() {
            return FilterTest.allCombinations().filter(any -> FilterTest.acceptedCombinations().noneMatch(any::equals));
        }

        static Stream<TypeCombination> allCombinations() {
            return Arrays.stream(RecordType.values()).flatMap(recordType -> Arrays.stream(ValueType.values()).map(valueType -> new TypeCombination((RecordType)recordType, (ValueType)valueType)));
        }

        @ParameterizedTest
        @DisplayName(value="accepting records of specific RecordType and ValueType")
        @MethodSource(value={"acceptedCombinations"})
        void shouldConfigureFilterAccepting(TypeCombination combination) throws Exception {
            RecordType recordType = combination.recordType();
            ValueType valueType = combination.valueType();
            ExporterTestContext context = new ExporterTestContext();
            new MetricsExporter().configure((Context)context);
            Context.RecordFilter recordFilter = context.getRecordFilter();
            ((AbstractBooleanAssert)Assertions.assertThat((recordFilter.acceptType(recordType) && recordFilter.acceptValue(valueType) ? 1 : 0) != 0).describedAs("Expect RecordFilter to accept record of RecordType %s and ValueType %s", new Object[]{recordType, valueType})).isTrue();
        }

        @ParameterizedTest
        @DisplayName(value="rejecting records of specific RecordType and ValueType")
        @MethodSource(value={"rejectedCombinations"})
        void shouldConfigureFilterRejecting(TypeCombination combination) throws Exception {
            RecordType recordType = combination.recordType();
            ValueType valueType = combination.valueType();
            ExporterTestContext context = new ExporterTestContext();
            new MetricsExporter().configure((Context)context);
            Context.RecordFilter recordFilter = context.getRecordFilter();
            ((AbstractBooleanAssert)Assertions.assertThat((recordFilter.acceptType(recordType) && recordFilter.acceptValue(valueType) ? 1 : 0) != 0).describedAs("Expect RecordFilter to reject record of RecordType %s and ValueType %s", new Object[]{recordType, valueType})).isFalse();
        }

        record TypeCombination(RecordType recordType, ValueType valueType) {
        }
    }
}

