/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.metrics;

import io.camunda.zeebe.broker.exporter.metrics.TtlKeyCache;
import io.camunda.zeebe.test.util.junit.RegressionTest;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class TtlKeyCacheTest {
    TtlKeyCacheTest() {
    }

    @Test
    void shouldStorePair() {
        TtlKeyCache cache = new TtlKeyCache();
        cache.store(1L, 10L);
        long timestamp = cache.remove(1L);
        Assertions.assertThat((long)timestamp).isEqualTo(10L);
    }

    @Test
    void shouldStoreMultipleKeysWithSameTimestamp() {
        TtlKeyCache cache = new TtlKeyCache();
        cache.store(1L, 10L);
        cache.store(2L, 10L);
        Assertions.assertThat((long)cache.remove(1L)).isEqualTo(10L);
        Assertions.assertThat((long)cache.remove(2L)).isEqualTo(10L);
    }

    @RegressionTest(value="https://github.com/camunda/zeebe/issues/16405")
    void shouldCleanupKeysEvenWithSameTimestamps() {
        TtlKeyCache cache = new TtlKeyCache();
        cache.store(1L, 10L);
        cache.store(2L, 10L);
        cache.cleanup(11L);
        Assertions.assertThat((boolean)cache.isEmpty()).isTrue();
    }

    @Test
    void shouldRemovePair() {
        TtlKeyCache cache = new TtlKeyCache();
        cache.store(1L, 10L);
        cache.remove(1L);
        Assertions.assertThat((boolean)cache.isEmpty()).isTrue();
    }

    @Test
    void shouldCleanupExpiredEntries() {
        TtlKeyCache cache = new TtlKeyCache();
        cache.store(1L, 10L);
        cache.store(2L, 20L);
        cache.store(3L, 30L);
        cache.cleanup(21L);
        Assertions.assertThat((long)cache.remove(3L)).isEqualTo(30L);
        Assertions.assertThat((boolean)cache.isEmpty()).isTrue();
    }

    @Test
    void shouldClearCache() {
        TtlKeyCache cache = new TtlKeyCache();
        cache.store(1L, 10L);
        cache.store(2L, 20L);
        cache.store(3L, 30L);
        cache.clear();
        Assertions.assertThat((boolean)cache.isEmpty()).isTrue();
    }

    @Test
    void shouldEvictOldestKeyOnCapacityReached() {
        TtlKeyCache cache = new TtlKeyCache(3);
        cache.store(1L, 10L);
        cache.store(2L, 20L);
        cache.store(3L, 30L);
        cache.store(4L, 40L);
        Assertions.assertThat((int)cache.size()).isEqualTo(3);
        Assertions.assertThat((long)cache.remove(1L)).isEqualTo(-1L);
        Assertions.assertThat((long)cache.remove(2L)).isEqualTo(20L);
        Assertions.assertThat((long)cache.remove(3L)).isEqualTo(30L);
        Assertions.assertThat((long)cache.remove(4L)).isEqualTo(40L);
    }

    @Test
    void shouldReturnNullValue() {
        TtlKeyCache cache = new TtlKeyCache(3L);
        cache.store(1L, 10L);
        long timestamp = cache.remove(2L);
        Assertions.assertThat((long)timestamp).isEqualTo(3L);
    }

    @Test
    void shouldGetTimestampByKey() {
        TtlKeyCache cache = new TtlKeyCache();
        cache.store(1L, 10L);
        long timestamp = cache.get(1L);
        Assertions.assertThat((long)timestamp).isEqualTo(10L);
        Assertions.assertThat((long)cache.get(1L)).isEqualTo(10L);
        Assertions.assertThat((int)cache.size()).isOne();
    }
}

