/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.repo;

import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.repo.ExporterLoadException;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.exporter.util.ControlledTestExporter;
import io.camunda.zeebe.broker.exporter.util.ExternalExporter;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.exporter.api.Exporter;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.util.jar.ExternalJarLoadException;
import java.io.File;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.HashMap;
import java.util.Map;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.CONCURRENT)
final class ExporterRepositoryTest {
    private final ExporterRepository repository = new ExporterRepository();

    ExporterRepositoryTest() {
    }

    @Test
    void shouldCacheDescriptorOnceLoaded() throws ExporterLoadException {
        String id = "myExporter";
        Class<MinimalExporter> exporterClass = MinimalExporter.class;
        ExporterDescriptor descriptor = this.repository.load("myExporter", exporterClass, null);
        Assertions.assertThat((Object)descriptor).isNotNull();
        Assertions.assertThat((Object)this.repository.load("myExporter", exporterClass)).isSameAs((Object)descriptor);
    }

    @Test
    void shouldFailToLoadIfExporterInvalid() {
        String id = "exporter";
        Class<InvalidExporter> exporterClass = InvalidExporter.class;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repository.load("exporter", exporterClass)).isInstanceOf(ExporterLoadException.class)).hasCauseInstanceOf(IllegalStateException.class);
    }

    @Test
    void shouldLoadInternalExporter() throws ExporterLoadException, ExternalJarLoadException {
        ExporterCfg config = new ExporterCfg();
        config.setClassName(ControlledTestExporter.class.getCanonicalName());
        config.setJarPath(null);
        ExporterDescriptor descriptor = this.repository.load("controlled", config);
        Assertions.assertThat((boolean)config.isExternal()).isFalse();
        Assertions.assertThat((Object)descriptor.newInstance()).isInstanceOf(ControlledTestExporter.class);
    }

    @Test
    void shouldLoadExternalExporter(@TempDir File tempDir) throws Exception {
        DynamicType.Unloaded<Exporter> exporterClass = ExternalExporter.createUnloadedExporterClass();
        File jarFile = exporterClass.toJar(new File(tempDir, "exporter.jar"));
        ExporterCfg config = new ExporterCfg();
        HashMap<String, Constable> args = new HashMap<String, Constable>();
        config.setClassName("com.acme.ExternalExporter");
        config.setJarPath(jarFile.getAbsolutePath());
        config.setArgs(args);
        args.put("foo", Integer.valueOf(1));
        args.put("bar", Boolean.valueOf(false));
        ExporterDescriptor descriptor = this.repository.load("exported", config);
        Assertions.assertThat((boolean)config.isExternal()).isTrue();
        Assertions.assertThat((Map)descriptor.getConfiguration().arguments()).isEqualTo((Object)config.getArgs());
        Assertions.assertThat((String)descriptor.getConfiguration().id()).isEqualTo("exported");
        Assertions.assertThat((String)descriptor.newInstance().getClass().getCanonicalName()).isEqualTo("com.acme.ExternalExporter");
    }

    @Test
    void shouldFailToLoadNonExporterClasses(@TempDir File tempDir) throws IOException {
        DynamicType.Unloaded externalClass = new ByteBuddy().subclass(Object.class).name("com.acme.MyObject").make();
        File jarFile = externalClass.toJar(new File(tempDir, "library.jar"));
        ExporterCfg config = new ExporterCfg();
        HashMap args = new HashMap();
        config.setClassName("com.acme.MyObject");
        config.setJarPath(jarFile.getAbsolutePath());
        config.setArgs(args);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repository.load("exported", config)).isInstanceOf(ExporterLoadException.class)).hasCauseInstanceOf(ClassCastException.class);
    }

    @Test
    void shouldFailToLoadNonExistingClass(@TempDir File tempDir) throws IOException {
        DynamicType.Unloaded<Exporter> exporterClass = ExternalExporter.createUnloadedExporterClass();
        File jarFile = exporterClass.toJar(new File(tempDir, "exporter.jar"));
        ExporterCfg config = new ExporterCfg();
        HashMap args = new HashMap();
        config.setClassName("xyz.i.dont.Exist");
        config.setJarPath(jarFile.getAbsolutePath());
        config.setArgs(args);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.repository.load("exported", config)).isInstanceOf(ExporterLoadException.class)).hasCauseInstanceOf(ClassNotFoundException.class);
    }

    @Test
    void shouldSetTclOnValidation(@TempDir File tempDir) throws IOException {
        ExporterCfg config = new ExporterCfg();
        HashMap args = new HashMap();
        ByteBuddy classGenerator = new ByteBuddy();
        DynamicType.Unloaded exporterClass = classGenerator.subclass(TclValidationExporter.class).name("com.acme.ExternalExporter").make();
        File jarFile = exporterClass.toJar(new File(tempDir, "exporter.jar"));
        DynamicType.Unloaded configClass = classGenerator.subclass(Object.class).name("com.acme.Config").make();
        configClass.inject(jarFile);
        config.setClassName("com.acme.ExternalExporter");
        config.setJarPath(jarFile.getAbsolutePath());
        config.setArgs(args);
        Assertions.assertThatCode(() -> this.repository.load("external", config)).doesNotThrowAnyException();
    }

    public static class MinimalExporter
    implements Exporter {
        public void export(Record<?> record) {
        }
    }

    public static class InvalidExporter
    implements Exporter {
        public void configure(Context context) {
            throw new IllegalStateException("what");
        }

        public void export(Record<?> record) {
        }
    }

    public static class TclValidationExporter
    implements Exporter {
        public void configure(Context context) throws Exception {
            Thread.currentThread().getContextClassLoader().loadClass("com.acme.Config");
        }

        public void export(Record<?> record) {
        }
    }
}

