/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.repo.ExporterLoadException;
import io.camunda.zeebe.broker.exporter.repo.ExporterRepository;
import io.camunda.zeebe.broker.exporter.stream.ExporterContainer;
import io.camunda.zeebe.broker.exporter.stream.ExporterMetrics;
import io.camunda.zeebe.broker.exporter.stream.ExportersState;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.DefaultZeebeDbFactory;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorControl;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.util.CloseableSilently;
import io.camunda.zeebe.util.jar.ExternalJarLoadException;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.nio.file.Path;
import org.agrona.CloseHelper;

public final class ExporterContainerRuntime
implements CloseableSilently {
    private final ActorScheduler scheduler = ActorScheduler.newActorScheduler().build();
    private final ExporterRepository repository;
    private final ZeebeDb<ZbColumnFamilies> zeebeDb;
    private final RuntimeActor actor;
    private final ExportersState state;
    private final ExporterMetrics metrics;
    private final MeterRegistry meterRegistry;

    public ExporterContainerRuntime(Path storagePath) {
        this.scheduler.start();
        this.repository = new ExporterRepository();
        this.zeebeDb = this.createZeebeDb(storagePath.resolve("db"));
        this.actor = new RuntimeActor();
        this.scheduler.submitActor((Actor)this.actor).join();
        this.state = new ExportersState(this.zeebeDb, this.zeebeDb.createContext());
        this.meterRegistry = new SimpleMeterRegistry();
        this.metrics = new ExporterMetrics(this.meterRegistry);
    }

    public void close() {
        CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{this.actor, this.scheduler, this.zeebeDb});
    }

    public ExporterDescriptor loadExternalExporter(File jarFile, String className) throws ExporterLoadException, ExternalJarLoadException {
        ExporterCfg exporterCfg = new ExporterCfg();
        exporterCfg.setJarPath(jarFile.getAbsolutePath());
        exporterCfg.setClassName(className);
        return this.repository.load("external", exporterCfg);
    }

    public ExporterContainer newContainer(ExporterDescriptor descriptor, int partitionId) {
        ExporterContainer container = new ExporterContainer(descriptor, partitionId, this.meterRegistry);
        container.initContainer(this.actor.getActorControl(), this.metrics, this.state);
        return container;
    }

    public ExporterContainer newContainer(ExporterDescriptor descriptor, int partitionId, MeterRegistry meterRegistry) {
        ExporterContainer container = new ExporterContainer(descriptor, partitionId, meterRegistry);
        container.initContainer(this.actor.getActorControl(), this.metrics, this.state);
        return container;
    }

    public ExporterRepository getRepository() {
        return this.repository;
    }

    public ExportersState getState() {
        return this.state;
    }

    public RuntimeActor getActor() {
        return this.actor;
    }

    private ZeebeDb<ZbColumnFamilies> createZeebeDb(Path path) {
        return DefaultZeebeDbFactory.defaultFactory().createDb(path.toFile());
    }

    static final class RuntimeActor
    extends Actor {
        RuntimeActor() {
        }

        ActorControl getActorControl() {
            return this.actor;
        }
    }
}

