/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.repo.ExporterLoadException;
import io.camunda.zeebe.broker.exporter.stream.ExporterContainer;
import io.camunda.zeebe.broker.exporter.stream.ExporterContainerRuntime;
import io.camunda.zeebe.exporter.api.Exporter;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.exporter.api.context.Controller;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.buffer.BufferUtil;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import org.agrona.DirectBuffer;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.mockito.Mockito;

@Execution(value=ExecutionMode.CONCURRENT)
final class ExporterContainerTest {
    private static final String EXPORTER_ID = "fakeExporter";
    private static final int PARTITION_ID = 123;
    private static final String REGISTERED_COUNTER_NAME = "zeebe_exporter_counter";
    private ExporterContainerRuntime runtime;
    private FakeExporter exporter;
    private ExporterContainer exporterContainer;

    ExporterContainerTest() {
    }

    @BeforeEach
    void beforeEach(@TempDir Path storagePath) throws ExporterLoadException {
        this.runtime = new ExporterContainerRuntime(storagePath);
        ExporterDescriptor descriptor = this.runtime.getRepository().load(EXPORTER_ID, FakeExporter.class, Map.of("key", "value"));
        this.exporterContainer = this.runtime.newContainer(descriptor, 123);
        this.exporter = (FakeExporter)this.exporterContainer.getExporter();
    }

    @Test
    void shouldConfigureExporter() throws Exception {
        this.exporterContainer.configureExporter();
        Assertions.assertThat((Object)this.exporter.getContext()).isNotNull();
        Assertions.assertThat((Object)this.exporter.getContext().getLogger()).isNotNull();
        Assertions.assertThat((Object)this.exporter.getContext().getConfiguration()).isNotNull();
        Assertions.assertThat((String)this.exporter.getContext().getConfiguration().getId()).isEqualTo(EXPORTER_ID);
        Assertions.assertThat((int)this.exporter.getContext().getPartitionId()).isEqualTo(123);
        Assertions.assertThat((Map)this.exporter.getContext().getConfiguration().getArguments()).isEqualTo(Map.of("key", "value"));
    }

    @Test
    void shouldOpenExporter() throws Exception {
        this.exporterContainer.configureExporter();
        this.exporterContainer.openExporter();
        Assertions.assertThat((Object)this.exporter.getController()).isNotNull();
        Assertions.assertThat((Object)this.exporter.getController()).isEqualTo((Object)this.exporterContainer);
    }

    @Test
    void shouldInitPositionToDefaultIfNotExistInState() throws Exception {
        this.exporterContainer.configureExporter();
        this.exporterContainer.initPosition();
        Assertions.assertThat((long)this.exporterContainer.getPosition()).isEqualTo(-1L);
        Assertions.assertThat((long)this.exporterContainer.getLastUnacknowledgedPosition()).isEqualTo(-1L);
    }

    @Test
    void shouldInitPositionWithStateValues() throws Exception {
        this.exporterContainer.configureExporter();
        this.runtime.getState().setPosition(EXPORTER_ID, 51966L);
        this.exporterContainer.initPosition();
        Assertions.assertThat((long)this.exporterContainer.getPosition()).isEqualTo(51966L);
        Assertions.assertThat((long)this.exporterContainer.getLastUnacknowledgedPosition()).isEqualTo(51966L);
    }

    @Test
    void shouldNotExportWhenRecordPositionIsSmaller() throws Exception {
        this.exporterContainer.configureExporter();
        this.runtime.getState().setPosition(EXPORTER_ID, 51966L);
        this.exporterContainer.initPosition();
        TypedRecord mockedRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)mockedRecord.getPosition()).thenReturn((Object)1L);
        RecordMetadata recordMetadata = new RecordMetadata();
        this.exporterContainer.exportRecord(recordMetadata, mockedRecord);
        Assertions.assertThat(this.exporter.getRecord()).isNull();
    }

    @Test
    void shouldUpdateUnacknowledgedPositionOnExport() throws Exception {
        this.exporterContainer.configureExporter();
        this.runtime.getState().setPosition(EXPORTER_ID, 0L);
        this.exporterContainer.initPosition();
        TypedRecord mockedRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)mockedRecord.getPosition()).thenReturn((Object)1L);
        RecordMetadata recordMetadata = new RecordMetadata();
        this.exporterContainer.exportRecord(recordMetadata, mockedRecord);
        Assertions.assertThat(this.exporter.getRecord()).isNotNull();
        Assertions.assertThat(this.exporter.getRecord()).isEqualTo((Object)mockedRecord);
        Assertions.assertThat((long)this.exporterContainer.getLastUnacknowledgedPosition()).isEqualTo(1L);
        Assertions.assertThat((long)this.exporterContainer.getPosition()).isZero();
    }

    @Test
    void shouldUpdateUnacknowledgedPositionMultipleTimes() throws Exception {
        this.exporterContainer.configureExporter();
        this.runtime.getState().setPosition(EXPORTER_ID, 0L);
        this.exporterContainer.initPosition();
        TypedRecord mockedRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)mockedRecord.getPosition()).thenReturn((Object)1L);
        RecordMetadata recordMetadata = new RecordMetadata();
        this.exporterContainer.exportRecord(recordMetadata, mockedRecord);
        TypedRecord secondRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)secondRecord.getPosition()).thenReturn((Object)2L);
        this.exporterContainer.exportRecord(recordMetadata, secondRecord);
        Assertions.assertThat(this.exporter.getRecord()).isNotNull();
        Assertions.assertThat(this.exporter.getRecord()).isEqualTo((Object)secondRecord);
        Assertions.assertThat((long)this.exporterContainer.getLastUnacknowledgedPosition()).isEqualTo(2L);
        Assertions.assertThat((long)this.exporterContainer.getPosition()).isZero();
    }

    @Test
    void shouldUpdateExporterPosition() throws Exception {
        this.exporterContainer.configureExporter();
        this.runtime.getState().setPosition(EXPORTER_ID, 0L);
        this.exporterContainer.initPosition();
        this.exporterContainer.openExporter();
        TypedRecord mockedRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)mockedRecord.getPosition()).thenReturn((Object)1L);
        RecordMetadata recordMetadata = new RecordMetadata();
        this.exporterContainer.exportRecord(recordMetadata, mockedRecord);
        this.exporterContainer.updateLastExportedRecordPosition(mockedRecord.getPosition());
        this.awaitPreviousCall();
        Assertions.assertThat((long)this.exporterContainer.getLastUnacknowledgedPosition()).isEqualTo(1L);
        Assertions.assertThat((long)this.exporterContainer.getPosition()).isEqualTo(1L);
        Assertions.assertThat((long)this.runtime.getState().getPosition(EXPORTER_ID)).isEqualTo(1L);
    }

    @Test
    void shouldNotUpdateExporterPositionToSmallerValue() throws Exception {
        this.exporterContainer.configureExporter();
        this.runtime.getState().setPosition(EXPORTER_ID, 0L);
        this.exporterContainer.initPosition();
        this.exporterContainer.openExporter();
        TypedRecord mockedRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)mockedRecord.getPosition()).thenReturn((Object)1L);
        RecordMetadata recordMetadata = new RecordMetadata();
        this.exporterContainer.exportRecord(recordMetadata, mockedRecord);
        this.exporterContainer.updateLastExportedRecordPosition(-1L);
        this.awaitPreviousCall();
        Assertions.assertThat((long)this.exporterContainer.getLastUnacknowledgedPosition()).isEqualTo(1L);
        Assertions.assertThat((long)this.exporterContainer.getPosition()).isZero();
        Assertions.assertThat((long)this.runtime.getState().getPosition(EXPORTER_ID)).isZero();
    }

    @Test
    void shouldNotUpdateExporterPositionInDifferentOrder() throws Exception {
        this.exporterContainer.configureExporter();
        this.runtime.getState().setPosition(EXPORTER_ID, 0L);
        this.exporterContainer.initPosition();
        this.exporterContainer.openExporter();
        TypedRecord mockedRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)mockedRecord.getPosition()).thenReturn((Object)1L);
        RecordMetadata recordMetadata = new RecordMetadata();
        this.exporterContainer.exportRecord(recordMetadata, mockedRecord);
        Mockito.when((Object)mockedRecord.getPosition()).thenReturn((Object)2L);
        this.exporterContainer.exportRecord(recordMetadata, mockedRecord);
        this.exporterContainer.updateLastExportedRecordPosition(2L);
        this.exporterContainer.updateLastExportedRecordPosition(1L);
        this.awaitPreviousCall();
        Assertions.assertThat((long)this.exporterContainer.getLastUnacknowledgedPosition()).isEqualTo(2L);
        Assertions.assertThat((long)this.exporterContainer.getPosition()).isEqualTo(2L);
        Assertions.assertThat((long)this.runtime.getState().getPosition(EXPORTER_ID)).isEqualTo(2L);
    }

    @Test
    void shouldNotUpdateExporterPositionIfSoftPaused() throws Exception {
        this.exporterContainer.configureExporter();
        this.runtime.getState().setPosition(EXPORTER_ID, 0L);
        this.exporterContainer.initPosition();
        this.exporterContainer.openExporter();
        this.exporterContainer.softPauseExporter();
        TypedRecord mockedRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)mockedRecord.getPosition()).thenReturn((Object)1L);
        RecordMetadata recordMetadata = new RecordMetadata();
        this.exporterContainer.exportRecord(recordMetadata, mockedRecord);
        this.exporterContainer.updateLastExportedRecordPosition(mockedRecord.getPosition());
        this.awaitPreviousCall();
        Assertions.assertThat((long)this.exporterContainer.getLastUnacknowledgedPosition()).isEqualTo(1L);
        Assertions.assertThat((long)this.exporterContainer.getPosition()).isZero();
    }

    @Test
    void shouldUpdatePositionWhenResumedAfterSoftPaused() throws Exception {
        this.exporterContainer.configureExporter();
        this.runtime.getState().setPosition(EXPORTER_ID, 0L);
        this.exporterContainer.initPosition();
        this.exporterContainer.openExporter();
        this.exporterContainer.softPauseExporter();
        TypedRecord mockedRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)mockedRecord.getPosition()).thenReturn((Object)1L);
        byte[] metadata = "metadata".getBytes();
        RecordMetadata recordMetadata = new RecordMetadata().requestId(1L);
        this.exporterContainer.exportRecord(recordMetadata, mockedRecord);
        this.exporterContainer.updateLastExportedRecordPosition(mockedRecord.getPosition(), metadata);
        this.awaitPreviousCall();
        Assertions.assertThat((long)this.exporterContainer.getLastUnacknowledgedPosition()).isEqualTo(1L);
        Assertions.assertThat((long)this.exporterContainer.getPosition()).isZero();
        Assertions.assertThat((Optional)this.exporterContainer.readMetadata()).isNotPresent();
        this.exporterContainer.undoSoftPauseExporter();
        this.awaitPreviousCall();
        Assertions.assertThat((long)this.exporterContainer.getLastUnacknowledgedPosition()).isEqualTo(1L);
        Assertions.assertThat((long)this.exporterContainer.getPosition()).isEqualTo(1L);
        ((OptionalAssert)Assertions.assertThat((Optional)this.exporterContainer.readMetadata()).isPresent()).hasValue((Object)metadata);
    }

    @Test
    void shouldUpdatePositionsWhenRecordIsFiltered() throws Exception {
        this.exporterContainer.configureExporter();
        this.exporter.getContext().setFilter((Context.RecordFilter)new AlwaysRejectingFilter());
        this.runtime.getState().setPosition(EXPORTER_ID, 0L);
        this.exporterContainer.initPosition();
        TypedRecord mockedRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)mockedRecord.getPosition()).thenReturn((Object)1L);
        RecordMetadata recordMetadata = new RecordMetadata();
        this.exporterContainer.exportRecord(recordMetadata, mockedRecord);
        Assertions.assertThat(this.exporter.getRecord()).isNull();
        Assertions.assertThat((long)this.exporterContainer.getLastUnacknowledgedPosition()).isZero();
        Assertions.assertThat((long)this.exporterContainer.getPosition()).isEqualTo(1L);
    }

    @Test
    void shouldUpdatePositionsWhenRecordIsFilteredAndPositionsAreEqual() throws Exception {
        this.exporterContainer.configureExporter();
        this.runtime.getState().setPosition(EXPORTER_ID, 0L);
        this.exporterContainer.initPosition();
        TypedRecord mockedRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)mockedRecord.getPosition()).thenReturn((Object)1L);
        RecordMetadata recordMetadata = new RecordMetadata();
        this.exporterContainer.exportRecord(recordMetadata, mockedRecord);
        this.exporterContainer.updateLastExportedRecordPosition(mockedRecord.getPosition());
        this.awaitPreviousCall();
        this.exporter.getContext().setFilter((Context.RecordFilter)new AlwaysRejectingFilter());
        Mockito.when((Object)mockedRecord.getPosition()).thenReturn((Object)2L);
        this.exporterContainer.exportRecord(recordMetadata, mockedRecord);
        Assertions.assertThat(this.exporter.getRecord()).isNotNull();
        Assertions.assertThat((long)this.exporterContainer.getLastUnacknowledgedPosition()).isEqualTo(1L);
        Assertions.assertThat((long)this.exporterContainer.getPosition()).isEqualTo(2L);
    }

    @Test
    void shouldNotUpdatePositionsWhenRecordIsFilteredAndLastEventWasUnacknowledged() throws Exception {
        this.exporterContainer.configureExporter();
        this.runtime.getState().setPosition(EXPORTER_ID, 0L);
        this.exporterContainer.initPosition();
        TypedRecord firstRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)firstRecord.getPosition()).thenReturn((Object)1L);
        RecordMetadata recordMetadata = new RecordMetadata();
        this.exporterContainer.exportRecord(recordMetadata, firstRecord);
        TypedRecord secondRecord = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)secondRecord.getPosition()).thenReturn((Object)2L);
        this.exporter.getContext().setFilter((Context.RecordFilter)new AlwaysRejectingFilter());
        this.exporterContainer.exportRecord(recordMetadata, secondRecord);
        Assertions.assertThat(this.exporter.getRecord()).isNotNull();
        Assertions.assertThat(this.exporter.getRecord()).isEqualTo((Object)firstRecord);
        Assertions.assertThat((long)this.exporterContainer.getLastUnacknowledgedPosition()).isEqualTo(1L);
        Assertions.assertThat((long)this.exporterContainer.getPosition()).isZero();
    }

    @Test
    void shouldCloseExporter() throws Exception {
        this.exporterContainer.configureExporter();
        this.runtime.getState().setPosition(EXPORTER_ID, 0L);
        this.exporterContainer.initPosition();
        this.exporterContainer.close();
        Assertions.assertThat((boolean)this.exporter.isClosed()).isTrue();
    }

    @Test
    void shouldReturnEmptyMetadataIfNotExistInState() throws Exception {
        this.exporterContainer.configureExporter();
        Optional metadata = this.exporterContainer.readMetadata();
        Assertions.assertThat((Optional)metadata).isNotPresent();
    }

    @Test
    void shouldReadMetadataFromState() throws Exception {
        this.exporterContainer.configureExporter();
        byte[] metadata = "metadata".getBytes();
        this.runtime.getState().setExporterState(EXPORTER_ID, 10L, (DirectBuffer)BufferUtil.wrapArray((byte[])metadata));
        Optional readMetadata = this.exporterContainer.readMetadata();
        ((OptionalAssert)Assertions.assertThat((Optional)readMetadata).isPresent()).hasValue((Object)metadata);
    }

    @Test
    void shouldStoreMetadataInState() throws Exception {
        this.exporterContainer.configureExporter();
        byte[] metadata = "metadata".getBytes();
        this.exporterContainer.updateLastExportedRecordPosition(10L, metadata);
        this.awaitPreviousCall();
        DirectBuffer metadataInState = this.runtime.getState().getExporterMetadata(EXPORTER_ID);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)metadataInState).isNotNull()).isEqualTo((Object)BufferUtil.wrapArray((byte[])metadata));
    }

    @Test
    void shouldNotUpdateMetadataInStateIfPositionIsSmaller() throws Exception {
        this.exporterContainer.configureExporter();
        byte[] metadataBefore = "m1".getBytes();
        this.exporterContainer.updateLastExportedRecordPosition(20L, metadataBefore);
        this.awaitPreviousCall();
        byte[] metadataUpdated = "m2".getBytes();
        this.exporterContainer.updateLastExportedRecordPosition(10L, metadataUpdated);
        this.awaitPreviousCall();
        DirectBuffer metadataInState = this.runtime.getState().getExporterMetadata(EXPORTER_ID);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)metadataInState).isNotNull()).isEqualTo((Object)BufferUtil.wrapArray((byte[])metadataBefore));
    }

    @Test
    void shouldStoreAndReadMetadata() throws Exception {
        this.exporterContainer.configureExporter();
        byte[] metadata = "metadata".getBytes();
        this.exporterContainer.updateLastExportedRecordPosition(10L, metadata);
        this.awaitPreviousCall();
        Optional readMetadata = this.exporterContainer.readMetadata();
        ((OptionalAssert)Assertions.assertThat((Optional)readMetadata).isPresent()).hasValue((Object)metadata);
    }

    @Test
    void shouldAddMeterToMeterRegistryGivenInContext() throws Exception {
        ExporterDescriptor descriptor = this.runtime.getRepository().load("fakeExporterWithMetrics", FakeExporterWithMetrics.class, Map.of("key", "value"));
        SimpleMeterRegistry meterRegistry = new SimpleMeterRegistry();
        this.exporterContainer = this.runtime.newContainer(descriptor, 123, (MeterRegistry)meterRegistry);
        this.exporterContainer.configureExporter();
        Assertions.assertThat((String)((Meter)meterRegistry.getMeters().get(0)).getId().getName()).isEqualTo(REGISTERED_COUNTER_NAME);
    }

    private void awaitPreviousCall() {
        this.runtime.getActor().getActorControl().call(() -> null).join();
    }

    public static class FakeExporter
    implements Exporter {
        private Context context;
        private Controller controller;
        private Record<?> record;
        private boolean closed;

        public Context getContext() {
            return this.context;
        }

        public Controller getController() {
            return this.controller;
        }

        public Record<?> getRecord() {
            return this.record;
        }

        public boolean isClosed() {
            return this.closed;
        }

        public void configure(Context context) throws Exception {
            this.context = context;
        }

        public void open(Controller controller) {
            this.controller = controller;
        }

        public void close() {
            this.closed = true;
        }

        public void export(Record<?> record) {
            this.record = record;
        }
    }

    private static final class AlwaysRejectingFilter
    implements Context.RecordFilter {
        private AlwaysRejectingFilter() {
        }

        public boolean acceptType(RecordType recordType) {
            return false;
        }

        public boolean acceptValue(ValueType valueType) {
            return false;
        }
    }

    public static final class FakeExporterWithMetrics
    extends FakeExporter
    implements Exporter {
        @Override
        public void configure(Context context) throws Exception {
            this.context = context;
            Counter.builder((String)ExporterContainerTest.REGISTERED_COUNTER_NAME).register(context.getMeterRegistry());
        }
    }
}

