/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.stream.ExporterPhase;
import io.camunda.zeebe.broker.exporter.stream.ExporterRule;
import io.camunda.zeebe.broker.exporter.util.ControlledTestExporter;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public final class ExporterDirectorPauseTest {
    private static final long TIMEOUT = 2000L;
    @Rule
    public final ExporterRule passiveExporter = ExporterRule.passiveExporter();
    @Rule
    public final ExporterRule activeExporter = ExporterRule.activeExporter();
    private ControlledTestExporter exporter;
    private ExporterDescriptor descriptor;

    @Before
    public void init() {
        this.exporter = (ControlledTestExporter)Mockito.spy((Object)new ControlledTestExporter());
        this.descriptor = (ExporterDescriptor)Mockito.spy((Object)new ExporterDescriptor("exporter-1", this.exporter.getClass(), Map.of()));
        ((ExporterDescriptor)Mockito.doAnswer(c -> this.exporter).when((Object)this.descriptor)).newInstance();
    }

    @Test
    public void shouldPauseActiveExporter() {
        this.activeExporter.startExporterDirector(List.of(this.descriptor));
        this.activeExporter.getDirector().pauseExporting().join();
        this.activeExporter.writeEvent((Intent)DeploymentIntent.CREATED, (UnifiedRecordValue)new DeploymentRecord());
        Assertions.assertThat((Comparable)((ExporterPhase)this.activeExporter.getDirector().getPhase().join())).isEqualTo((Object)ExporterPhase.PAUSED);
        ((ControlledTestExporter)Mockito.verify((Object)this.exporter, (VerificationMode)Mockito.after((long)2000L).times(0))).export((Record)Mockito.any());
    }

    @Test
    public void shouldSoftPauseActiveExporter() {
        this.activeExporter.startExporterDirector(List.of(this.descriptor));
        this.activeExporter.getDirector().softPauseExporting().join();
        this.activeExporter.writeEvent((Intent)DeploymentIntent.CREATED, (UnifiedRecordValue)new DeploymentRecord());
        Assertions.assertThat((Comparable)((ExporterPhase)this.activeExporter.getDirector().getPhase().join())).isEqualTo((Object)ExporterPhase.SOFT_PAUSED);
        ((ControlledTestExporter)Mockito.verify((Object)this.exporter, (VerificationMode)Mockito.timeout((long)2000L).times(1))).export((Record)Mockito.any());
        Assertions.assertThat((long)this.exporter.getController().getLastExportedRecordPosition()).isEqualTo(-1L);
    }

    @Test
    public void shouldResumeSoftPausedExporter() {
        this.activeExporter.startExporterDirector(List.of(this.descriptor));
        this.activeExporter.getDirector().softPauseExporting().join();
        this.activeExporter.writeEvent((Intent)DeploymentIntent.CREATED, (UnifiedRecordValue)new DeploymentRecord());
        Assertions.assertThat((Comparable)((ExporterPhase)this.activeExporter.getDirector().getPhase().join())).isEqualTo((Object)ExporterPhase.SOFT_PAUSED);
        this.activeExporter.getDirector().resumeExporting().join();
        Assertions.assertThat((Comparable)((ExporterPhase)this.activeExporter.getDirector().getPhase().join())).isEqualTo((Object)ExporterPhase.EXPORTING);
        ((ControlledTestExporter)Mockito.verify((Object)this.exporter, (VerificationMode)Mockito.timeout((long)2000L).times(1))).export((Record)Mockito.any());
        Assertions.assertThat((long)this.exporter.getController().getLastExportedRecordPosition()).isZero();
    }

    @Test
    public void shouldPauseAfterSoftPausedExporter() {
        this.activeExporter.startExporterDirector(List.of(this.descriptor));
        this.activeExporter.getDirector().softPauseExporting().join();
        Assertions.assertThat((Comparable)((ExporterPhase)this.activeExporter.getDirector().getPhase().join())).isEqualTo((Object)ExporterPhase.SOFT_PAUSED);
        this.activeExporter.getDirector().pauseExporting().join();
        this.activeExporter.writeEvent((Intent)DeploymentIntent.CREATED, (UnifiedRecordValue)new DeploymentRecord());
        Assertions.assertThat((Comparable)((ExporterPhase)this.activeExporter.getDirector().getPhase().join())).isEqualTo((Object)ExporterPhase.PAUSED);
        ((ControlledTestExporter)Mockito.verify((Object)this.exporter, (VerificationMode)Mockito.timeout((long)2000L).times(0))).export((Record)Mockito.any());
    }

    @Test
    public void shouldSoftPauseAfterPausedExporter() {
        this.activeExporter.startExporterDirector(List.of(this.descriptor));
        this.activeExporter.getDirector().pauseExporting().join();
        Assertions.assertThat((Comparable)((ExporterPhase)this.activeExporter.getDirector().getPhase().join())).isEqualTo((Object)ExporterPhase.PAUSED);
        this.activeExporter.getDirector().softPauseExporting().join();
        this.activeExporter.writeEvent((Intent)DeploymentIntent.CREATED, (UnifiedRecordValue)new DeploymentRecord());
        Assertions.assertThat((Comparable)((ExporterPhase)this.activeExporter.getDirector().getPhase().join())).isEqualTo((Object)ExporterPhase.SOFT_PAUSED);
        ((ControlledTestExporter)Mockito.verify((Object)this.exporter, (VerificationMode)Mockito.timeout((long)2000L).times(1))).export((Record)Mockito.any());
    }

    @Test
    public void shouldResumeActiveExporter() {
        this.activeExporter.startExporterDirector(List.of(this.descriptor));
        this.activeExporter.getDirector().pauseExporting().join();
        this.activeExporter.writeEvent((Intent)DeploymentIntent.CREATED, (UnifiedRecordValue)new DeploymentRecord());
        Assertions.assertThat((Comparable)((ExporterPhase)this.activeExporter.getDirector().getPhase().join())).isEqualTo((Object)ExporterPhase.PAUSED);
        this.activeExporter.getDirector().resumeExporting().join();
        Assertions.assertThat((Comparable)((ExporterPhase)this.activeExporter.getDirector().getPhase().join())).isEqualTo((Object)ExporterPhase.EXPORTING);
        ((ControlledTestExporter)Mockito.verify((Object)this.exporter, (VerificationMode)Mockito.timeout((long)2000L).times(1))).export((Record)Mockito.any());
    }

    @Test
    public void shouldNotExportPassiveExporterAfterResume() {
        this.passiveExporter.startExporterDirector(List.of(this.descriptor));
        this.passiveExporter.getDirector().pauseExporting().join();
        this.passiveExporter.writeEvent((Intent)DeploymentIntent.CREATED, (UnifiedRecordValue)new DeploymentRecord());
        Assertions.assertThat((Comparable)((ExporterPhase)this.passiveExporter.getDirector().getPhase().join())).isEqualTo((Object)ExporterPhase.PAUSED);
        this.passiveExporter.getDirector().resumeExporting().join();
        Assertions.assertThat((Comparable)((ExporterPhase)this.passiveExporter.getDirector().getPhase().join())).isEqualTo((Object)ExporterPhase.EXPORTING);
        this.passiveExporter.writeEvent((Intent)DeploymentIntent.CREATED, (UnifiedRecordValue)new DeploymentRecord());
        ((ControlledTestExporter)Mockito.verify((Object)this.exporter, (VerificationMode)Mockito.after((long)2000L).times(0))).export((Record)Mockito.any());
    }

    @Test
    public void canPauseAndResumeWithoutAnyExporter() {
        this.activeExporter.startExporterDirector(List.of());
        Awaitility.await().alias("Exporter is closed").ignoreExceptions().until(() -> this.activeExporter.getDirector().getPhase().join() == ExporterPhase.CLOSED);
        Assertions.assertThatCode(() -> this.activeExporter.getDirector().pauseExporting().join()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.activeExporter.getDirector().softPauseExporting().join()).doesNotThrowAnyException();
        Assertions.assertThatCode(() -> this.activeExporter.getDirector().resumeExporting().join()).doesNotThrowAnyException();
    }
}

