/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.stream.ExporterRule;
import io.camunda.zeebe.broker.exporter.stream.ExportersState;
import io.camunda.zeebe.broker.exporter.util.ControlledTestExporter;
import io.camunda.zeebe.broker.exporter.util.PojoConfigurationExporter;
import io.camunda.zeebe.engine.Loggers;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.exporter.api.context.Controller;
import io.camunda.zeebe.exporter.api.context.ScheduledTask;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.camunda.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.ValueType;
import io.camunda.zeebe.protocol.record.intent.DeploymentIntent;
import io.camunda.zeebe.protocol.record.intent.IncidentIntent;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.EventFilter;
import io.camunda.zeebe.stream.impl.SkipPositionsFilter;
import io.camunda.zeebe.test.util.TestUtil;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractListAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.mockito.verification.VerificationWithTimeout;

public final class ExporterDirectorTest {
    private static final String EXPORTER_ID_1 = "exporter-1";
    private static final String EXPORTER_ID_2 = "exporter-2";
    private static final int TIMEOUT_MILLIS = 5000;
    private static final VerificationWithTimeout TIMEOUT = Mockito.timeout((long)5000L);
    @Rule
    public final ExporterRule rule = ExporterRule.activeExporter();
    @Rule
    public final ExporterRule passiveExporterRule = ExporterRule.passiveExporter();
    private final List<ControlledTestExporter> exporters = new ArrayList<ControlledTestExporter>();
    private final List<ExporterDescriptor> exporterDescriptors = new ArrayList<ExporterDescriptor>();

    @Before
    public void init() {
        this.exporters.clear();
        this.exporterDescriptors.clear();
        this.createExporter(EXPORTER_ID_1, Collections.singletonMap("x", 1));
        this.createExporter(EXPORTER_ID_2, Collections.singletonMap("y", 2));
    }

    private void createExporter(String exporterId, Map<String, Object> arguments) {
        ControlledTestExporter exporter = (ControlledTestExporter)Mockito.spy((Object)new ControlledTestExporter());
        ExporterDescriptor descriptor = (ExporterDescriptor)Mockito.spy((Object)new ExporterDescriptor(exporterId, exporter.getClass(), arguments));
        ((ExporterDescriptor)Mockito.doAnswer(c -> exporter).when((Object)descriptor)).newInstance();
        this.exporters.add(exporter);
        this.exporterDescriptors.add(descriptor);
    }

    private void startExporterDirector(List<ExporterDescriptor> exporterDescriptors) {
        this.rule.startExporterDirector(exporterDescriptors);
    }

    @Test
    public void shouldUpdatePositionWhenInitialRecordsAreSkipped() {
        ControlledTestExporter tailingExporter = this.exporters.get(1);
        this.exporters.forEach(e -> e.onConfigure(this.withFilter(List.of(RecordType.COMMAND), List.of(ValueType.DEPLOYMENT))).shouldAutoUpdatePosition(false));
        this.startExporterDirector(this.exporterDescriptors);
        ExportersState state = this.rule.getExportersState();
        long skippedRecordPosition = this.rule.writeEvent((Intent)DeploymentIntent.CREATED, (UnifiedRecordValue)new DeploymentRecord());
        this.rule.writeCommand((Intent)DeploymentIntent.CREATE, (UnifiedRecordValue)new DeploymentRecord());
        Awaitility.await((String)"director has read all records until now").atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat(tailingExporter.getExportedRecords()).hasSize(1));
        Assertions.assertThat((long)state.getPosition(EXPORTER_ID_1)).isEqualTo(skippedRecordPosition);
        Assertions.assertThat((long)state.getPosition(EXPORTER_ID_2)).isEqualTo(skippedRecordPosition);
    }

    @Test
    public void shouldUpdatePositionOfUpToDateExportersOnSkipRecord() {
        ControlledTestExporter filteringExporter = this.exporters.get(0);
        ControlledTestExporter tailingExporter = this.exporters.get(1);
        tailingExporter.onConfigure(this.withFilter(List.of(RecordType.COMMAND), List.of(ValueType.DEPLOYMENT))).shouldAutoUpdatePosition(false);
        filteringExporter.onConfigure(this.withFilter(List.of(RecordType.COMMAND), List.of(ValueType.DEPLOYMENT))).shouldAutoUpdatePosition(false);
        this.startExporterDirector(this.exporterDescriptors);
        ExportersState state = this.rule.getExportersState();
        long firstRecordPosition = this.rule.writeCommand((Intent)DeploymentIntent.CREATE, (UnifiedRecordValue)new DeploymentRecord());
        Awaitility.await((String)"filteringExporter has exported the first record").atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat(filteringExporter.getExportedRecords()).hasSize(1));
        filteringExporter.getController().updateLastExportedRecordPosition(firstRecordPosition);
        long skippedRecordPosition = this.rule.writeCommand((Intent)IncidentIntent.CREATED, (UnifiedRecordValue)new IncidentRecord());
        this.rule.writeCommand((Intent)DeploymentIntent.CREATE, (UnifiedRecordValue)new DeploymentRecord());
        Awaitility.await((String)"director has read all records until now").atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat(tailingExporter.getExportedRecords()).hasSize(2));
        Assertions.assertThat((long)state.getPosition(EXPORTER_ID_1)).isEqualTo(skippedRecordPosition);
        Assertions.assertThat((long)state.getPosition(EXPORTER_ID_2)).isEqualTo(-1L);
    }

    @Test
    public void shouldUpdateIfSkippingInitialRecordForSingleExporter() {
        ControlledTestExporter filteringExporter = this.exporters.get(0);
        ControlledTestExporter tailingExporter = this.exporters.get(1);
        tailingExporter.onConfigure(this.withFilter(List.of(RecordType.COMMAND, RecordType.EVENT), List.of(ValueType.DEPLOYMENT))).shouldAutoUpdatePosition(false);
        filteringExporter.onConfigure(this.withFilter(List.of(RecordType.COMMAND), List.of(ValueType.DEPLOYMENT))).shouldAutoUpdatePosition(false);
        this.startExporterDirector(this.exporterDescriptors);
        ExportersState state = this.rule.getExportersState();
        long skippedRecordPosition = this.rule.writeEvent((Intent)DeploymentIntent.CREATED, (UnifiedRecordValue)new DeploymentRecord());
        this.rule.writeCommand((Intent)DeploymentIntent.CREATE, (UnifiedRecordValue)new DeploymentRecord());
        Awaitility.await((String)"director has read all records until now").atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat(tailingExporter.getExportedRecords()).hasSize(2));
        Assertions.assertThat((long)state.getPosition(EXPORTER_ID_1)).isEqualTo(skippedRecordPosition);
        Assertions.assertThat((long)state.getPosition(EXPORTER_ID_2)).isEqualTo(-1L);
    }

    @Test
    public void shouldUpdateIfRecordSkipsSingleUpToDateExporter() {
        ControlledTestExporter filteringExporter = this.exporters.get(0);
        ControlledTestExporter tailingExporter = this.exporters.get(1);
        tailingExporter.onConfigure(this.withFilter(List.of(RecordType.COMMAND, RecordType.EVENT), List.of(ValueType.DEPLOYMENT))).shouldAutoUpdatePosition(false);
        filteringExporter.onConfigure(this.withFilter(List.of(RecordType.COMMAND), List.of(ValueType.DEPLOYMENT))).shouldAutoUpdatePosition(false);
        this.startExporterDirector(this.exporterDescriptors);
        ExportersState state = this.rule.getExportersState();
        long firstRecordPosition = this.rule.writeCommand((Intent)DeploymentIntent.CREATE, (UnifiedRecordValue)new DeploymentRecord());
        Awaitility.await((String)"filteringExporter has exported the first record").atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat(filteringExporter.getExportedRecords()).hasSize(1));
        filteringExporter.getController().updateLastExportedRecordPosition(firstRecordPosition);
        long skippedRecordPosition = this.rule.writeEvent((Intent)DeploymentIntent.CREATED, (UnifiedRecordValue)new DeploymentRecord());
        Awaitility.await((String)"director has read all records until now").atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat(tailingExporter.getExportedRecords()).hasSize(2));
        Assertions.assertThat((long)state.getPosition(EXPORTER_ID_1)).isEqualTo(skippedRecordPosition);
        Assertions.assertThat((long)state.getPosition(EXPORTER_ID_2)).isEqualTo(-1L);
    }

    @Test
    public void shouldConfigureAllExportersProperlyOnStart() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(this.exporters.size());
        this.exporters.forEach(exporter -> exporter.onOpen(c -> latch.countDown()));
        this.startExporterDirector(this.exporterDescriptors);
        Assertions.assertThat((boolean)latch.await(5000L, TimeUnit.MILLISECONDS)).isTrue();
        ((ControlledTestExporter)Mockito.verify((Object)this.exporters.get(0), (VerificationMode)TIMEOUT)).open((Controller)Mockito.any());
        ((ControlledTestExporter)Mockito.verify((Object)this.exporters.get(1), (VerificationMode)TIMEOUT)).open((Controller)Mockito.any());
        this.exporters.forEach(exporter -> {
            Assertions.assertThat((Object)exporter.getController()).isNotNull();
            Assertions.assertThat((Object)exporter.getContext().getLogger()).isNotNull();
            Assertions.assertThat((Object)exporter.getContext().getConfiguration()).isNotNull();
        });
        Context exporterContext1 = this.exporters.get(0).getContext();
        Assertions.assertThat((String)exporterContext1.getConfiguration().getId()).isEqualTo(EXPORTER_ID_1);
        Assertions.assertThat((Map)exporterContext1.getConfiguration().getArguments()).isEqualTo(Collections.singletonMap("x", 1));
        Assertions.assertThat((String)exporterContext1.getLogger().getName()).isEqualTo(Loggers.getExporterLogger((String)EXPORTER_ID_1).getName());
        Context exporterContext2 = this.exporters.get(1).getContext();
        Assertions.assertThat((String)exporterContext2.getConfiguration().getId()).isEqualTo(EXPORTER_ID_2);
        Assertions.assertThat((Map)exporterContext2.getConfiguration().getArguments()).isEqualTo(Collections.singletonMap("y", 2));
        Assertions.assertThat((String)exporterContext2.getLogger().getName()).isEqualTo(Loggers.getExporterLogger((String)EXPORTER_ID_2).getName());
    }

    @Test
    public void shouldIgnoreErrorsOnClose() throws Exception {
        this.startExporterDirector(this.exporterDescriptors);
        ((ControlledTestExporter)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException()}).when((Object)this.exporters.get(0))).close();
        this.rule.closeExporterDirector();
        ((ControlledTestExporter)Mockito.verify((Object)this.exporters.get(0), (VerificationMode)TIMEOUT)).close();
        ((ControlledTestExporter)Mockito.verify((Object)this.exporters.get(1), (VerificationMode)TIMEOUT)).close();
    }

    @Test
    public void shouldCloseAllExportersOnClose() throws Exception {
        this.startExporterDirector(this.exporterDescriptors);
        this.rule.closeExporterDirector();
        ((ControlledTestExporter)Mockito.verify((Object)this.exporters.get(0), (VerificationMode)TIMEOUT)).close();
        ((ControlledTestExporter)Mockito.verify((Object)this.exporters.get(1), (VerificationMode)TIMEOUT)).close();
    }

    @Test
    public void shouldCloseAllExportersOnCloseInPassiveMode() throws Exception {
        this.passiveExporterRule.startExporterDirector(this.exporterDescriptors);
        this.passiveExporterRule.closeExporterDirector();
        ((ControlledTestExporter)Mockito.verify((Object)this.exporters.get(0), (VerificationMode)TIMEOUT)).close();
        ((ControlledTestExporter)Mockito.verify((Object)this.exporters.get(1), (VerificationMode)TIMEOUT)).close();
    }

    @Test
    public void shouldInstantiateConfigurationClass() {
        String foo = "bar";
        int x = 123;
        String bar = "baz";
        double y = 32.12;
        HashMap<String, Object> nested = new HashMap<String, Object>();
        nested.put("bar", "baz");
        nested.put("y", 32.12);
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        arguments.put("foo", "bar");
        arguments.put("x", 123);
        arguments.put("nested", nested);
        ExporterDescriptor descriptor = new ExporterDescriptor("instantiateConfiguration", PojoConfigurationExporter.class, arguments);
        this.startExporterDirector(Collections.singletonList(descriptor));
        TestUtil.waitUntil(() -> PojoConfigurationExporter.configuration != null);
        PojoConfigurationExporter.PojoExporterConfiguration configuration = PojoConfigurationExporter.configuration;
        Assertions.assertThat((String)configuration.getFoo()).isEqualTo("bar");
        Assertions.assertThat((int)configuration.getX()).isEqualTo(123);
        Assertions.assertThat((String)configuration.getNested().getBar()).isEqualTo("baz");
        Assertions.assertThat((double)configuration.getNested().getY()).isEqualTo(32.12);
    }

    @Test
    public void shouldApplyRecordFilter() {
        this.exporters.get(0).onConfigure(this.withFilter(Arrays.asList(RecordType.COMMAND, RecordType.EVENT), Collections.singletonList(ValueType.DEPLOYMENT)));
        this.exporters.get(1).onConfigure(this.withFilter(Collections.singletonList(RecordType.EVENT), Arrays.asList(ValueType.DEPLOYMENT, ValueType.JOB)));
        this.startExporterDirector(this.exporterDescriptors);
        long deploymentCommand = this.rule.writeCommand((Intent)DeploymentIntent.CREATE, (UnifiedRecordValue)new DeploymentRecord());
        long deploymentEvent = this.rule.writeEvent((Intent)DeploymentIntent.CREATED, (UnifiedRecordValue)new DeploymentRecord());
        this.rule.writeEvent((Intent)IncidentIntent.CREATED, (UnifiedRecordValue)new IncidentRecord());
        long jobEvent = this.rule.writeEvent((Intent)JobIntent.CREATED, (UnifiedRecordValue)new JobRecord());
        TestUtil.waitUntil(() -> this.exporters.get(1).getExportedRecords().size() == 2);
        ((AbstractListAssert)Assertions.assertThat(this.exporters.get(0).getExportedRecords()).extracting(Record::getPosition).hasSize(2)).contains((Object[])new Long[]{deploymentCommand, deploymentEvent});
        ((AbstractListAssert)Assertions.assertThat(this.exporters.get(1).getExportedRecords()).extracting(Record::getPosition).hasSize(2)).contains((Object[])new Long[]{deploymentEvent, jobEvent});
    }

    @Test
    public void shouldNotExportSkipRecordsFilter() {
        this.exporters.get(1).onConfigure(this.withFilter(List.of(RecordType.COMMAND), List.of(ValueType.DEPLOYMENT)));
        this.rule.withPositionsToSkipFilter((EventFilter)SkipPositionsFilter.of(Set.of(Long.valueOf(1L))));
        this.startExporterDirector(this.exporterDescriptors);
        this.rule.writeCommand((Intent)DeploymentIntent.CREATE, (UnifiedRecordValue)new DeploymentRecord());
        this.rule.writeCommand((Intent)DeploymentIntent.CREATE, (UnifiedRecordValue)new DeploymentRecord());
        Awaitility.await((String)"filteringExporter has exported only the second record").atMost(Duration.ofSeconds(5L)).untilAsserted(() -> Assertions.assertThat(this.exporters.get(1).getExportedRecords()).extracting(Record::getPosition).containsExactly((Object[])new Long[]{2L}));
    }

    @Test
    public void shouldRetryExportingOnException() {
        AtomicLong failCount = new AtomicLong(3L);
        this.exporters.get(0).onExport(e -> {
            if (failCount.getAndDecrement() > 0L) {
                throw new RuntimeException("Export failed (expected)");
            }
        });
        this.startExporterDirector(this.exporterDescriptors);
        long eventPosition1 = this.writeEvent();
        long eventPosition2 = this.writeEvent();
        TestUtil.doRepeatedly(() -> this.rule.getClock().addTime(Duration.ofSeconds(1L))).until(r -> failCount.get() <= -2L);
        Awaitility.await((String)"Exporter %s has exported all records".formatted(EXPORTER_ID_1)).untilAsserted(() -> Assertions.assertThat(this.exporters.get(0).getExportedRecords()).extracting(Record::getPosition).containsExactly((Object[])new Long[]{eventPosition1, eventPosition2}));
        Awaitility.await((String)"Exporter %s has exported all records".formatted(EXPORTER_ID_2)).untilAsserted(() -> Assertions.assertThat(this.exporters.get(1).getExportedRecords()).extracting(Record::getPosition).containsExactly((Object[])new Long[]{eventPosition1, eventPosition2}));
    }

    @Test
    public void shouldExecuteScheduledTask() throws Exception {
        CountDownLatch timerTriggerLatch = new CountDownLatch(1);
        CountDownLatch timerScheduledLatch = new CountDownLatch(1);
        Duration delay = Duration.ofSeconds(10L);
        this.exporters.get(0).onExport(r -> {
            this.exporters.get(0).getController().scheduleCancellableTask(delay, timerTriggerLatch::countDown);
            timerScheduledLatch.countDown();
        });
        this.startExporterDirector(this.exporterDescriptors);
        this.writeEvent();
        Assertions.assertThat((boolean)timerScheduledLatch.await(5L, TimeUnit.SECONDS)).isTrue();
        this.rule.getClock().addTime(delay);
        Assertions.assertThat((boolean)timerTriggerLatch.await(5L, TimeUnit.SECONDS)).isTrue();
    }

    @Test
    public void shouldExecuteScheduledCancellableTask() throws InterruptedException {
        CountDownLatch timerTriggerLatch = new CountDownLatch(1);
        CountDownLatch timerScheduledLatch = new CountDownLatch(1);
        Duration delay = Duration.ofSeconds(10L);
        ControlledTestExporter exporter = this.exporters.get(0);
        exporter.onExport(r -> {
            exporter.getController().scheduleCancellableTask(delay, timerTriggerLatch::countDown);
            timerScheduledLatch.countDown();
        });
        this.startExporterDirector(this.exporterDescriptors);
        this.writeEvent();
        Assertions.assertThat((boolean)timerScheduledLatch.await(5L, TimeUnit.SECONDS)).isTrue();
        this.rule.getClock().addTime(delay);
        Assertions.assertThat((boolean)timerTriggerLatch.await(5L, TimeUnit.SECONDS)).isTrue();
    }

    @Test
    public void shouldCancelScheduledCancellableTask() throws InterruptedException {
        CountDownLatch timerScheduledLatch = new CountDownLatch(1);
        CountDownLatch timerTriggerLatch = new CountDownLatch(1);
        Duration delay = Duration.ofSeconds(10L);
        ControlledTestExporter exporter = this.exporters.get(0);
        AtomicLong shouldBeNotModifiedVariable = new AtomicLong(0L);
        exporter.onExport(r -> {
            ScheduledTask taskToCancel = exporter.getController().scheduleCancellableTask(delay, () -> shouldBeNotModifiedVariable.set(1L));
            exporter.getController().scheduleCancellableTask(delay, timerTriggerLatch::countDown);
            taskToCancel.cancel();
            timerScheduledLatch.countDown();
        });
        this.startExporterDirector(this.exporterDescriptors);
        this.writeEvent();
        Assertions.assertThat((boolean)timerScheduledLatch.await(5L, TimeUnit.SECONDS)).isTrue();
        this.rule.getClock().addTime(delay);
        Assertions.assertThat((boolean)timerTriggerLatch.await(5L, TimeUnit.SECONDS)).isTrue();
        Assertions.assertThat((long)shouldBeNotModifiedVariable.get()).isZero();
    }

    @Test
    public void shouldRecoverPositionsFromState() throws Exception {
        this.startExporterDirector(this.exporterDescriptors);
        long eventPosition1 = this.writeEvent();
        long eventPosition2 = this.writeEvent();
        TestUtil.waitUntil(() -> this.exporters.get(0).getExportedRecords().size() == 2);
        TestUtil.waitUntil(() -> this.exporters.get(1).getExportedRecords().size() == 2);
        this.exporters.get(0).getController().updateLastExportedRecordPosition(eventPosition2);
        this.exporters.get(1).getController().updateLastExportedRecordPosition(eventPosition1);
        this.rule.closeExporterDirector();
        this.exporters.get(0).getExportedRecords().clear();
        this.exporters.get(1).getExportedRecords().clear();
        this.startExporterDirector(this.exporterDescriptors);
        TestUtil.waitUntil(() -> this.exporters.get(1).getExportedRecords().size() >= 1);
        Assertions.assertThat(this.exporters.get(0).getExportedRecords()).isEmpty();
        ((AbstractListAssert)Assertions.assertThat(this.exporters.get(1).getExportedRecords()).extracting(Record::getPosition).hasSize(1)).contains((Object[])new Long[]{eventPosition2});
    }

    @Test
    public void shouldRecoverMetadataFromState() throws Exception {
        this.startExporterDirector(this.exporterDescriptors);
        long eventPosition1 = this.writeEvent();
        long eventPosition2 = this.writeEvent();
        byte[] exporterMetadata1 = "e1".getBytes();
        byte[] exporterMetadata2 = "e2".getBytes();
        Awaitility.await((String)"wait until the exporters read the records").until(() -> this.exporters.get(0).getExportedRecords().size() == 2 && this.exporters.get(1).getExportedRecords().size() == 2);
        this.exporters.get(0).getController().updateLastExportedRecordPosition(eventPosition2, exporterMetadata1);
        this.exporters.get(1).getController().updateLastExportedRecordPosition(eventPosition1, exporterMetadata2);
        this.rule.closeExporterDirector();
        this.exporters.get(0).getExportedRecords().clear();
        this.exporters.get(1).getExportedRecords().clear();
        this.startExporterDirector(this.exporterDescriptors);
        Awaitility.await((String)"wait until the exporters are opened").until(() -> this.exporters.get(1).getExportedRecords().size() >= 1);
        Assertions.assertThat((Optional)this.exporters.get(0).getController().readMetadata()).hasValue((Object)exporterMetadata1);
        Assertions.assertThat((Optional)this.exporters.get(1).getController().readMetadata()).hasValue((Object)exporterMetadata2);
    }

    @Test
    public void shouldNotUpdatePositionToSmallerValue() throws Exception {
        CountDownLatch latch = new CountDownLatch(1);
        ControlledTestExporter controlledTestExporter = this.exporters.get(0);
        controlledTestExporter.onOpen(c -> latch.countDown());
        this.startExporterDirector(this.exporterDescriptors);
        latch.await();
        this.exporters.get(0).getController().updateLastExportedRecordPosition(1L);
        Long firstPosition = (Long)Awaitility.await().until(() -> this.rule.getExportersState().getPosition(EXPORTER_ID_1), pos -> pos > -1L);
        this.exporters.get(0).getController().updateLastExportedRecordPosition(-1L);
        long secondPosition = this.rule.getExportersState().getPosition(EXPORTER_ID_1);
        Assertions.assertThat((long)secondPosition).isEqualTo((Object)firstPosition);
    }

    @Test
    public void shouldUpdateLastExportedPositionOnClose() throws Exception {
        this.startExporterDirector(this.exporterDescriptors);
        long eventPosition1 = this.writeEvent();
        long eventPosition2 = this.writeEvent();
        TestUtil.waitUntil(() -> this.exporters.get(0).getExportedRecords().size() == 2);
        TestUtil.waitUntil(() -> this.exporters.get(1).getExportedRecords().size() == 2);
        this.exporters.get(0).onClose(() -> this.exporters.get(0).getController().updateLastExportedRecordPosition(eventPosition1));
        this.rule.closeExporterDirector();
        this.exporters.get(0).getExportedRecords().clear();
        this.exporters.get(1).getExportedRecords().clear();
        this.startExporterDirector(this.exporterDescriptors);
        TestUtil.waitUntil(() -> this.exporters.get(1).getExportedRecords().size() >= 2);
        ((AbstractListAssert)Assertions.assertThat(this.exporters.get(0).getExportedRecords()).extracting(Record::getPosition).hasSize(1)).contains((Object[])new Long[]{eventPosition2});
        ((AbstractListAssert)Assertions.assertThat(this.exporters.get(1).getExportedRecords()).extracting(Record::getPosition).hasSize(2)).contains((Object[])new Long[]{eventPosition1, eventPosition2});
    }

    @Test
    public void shouldRemoveExporterFromState() throws Exception {
        this.startExporterDirector(this.exporterDescriptors);
        long eventPosition = this.writeEvent();
        TestUtil.waitUntil(() -> this.exporters.get(0).getExportedRecords().size() == 1);
        TestUtil.waitUntil(() -> this.exporters.get(1).getExportedRecords().size() == 1);
        this.exporters.get(0).getController().updateLastExportedRecordPosition(eventPosition);
        this.exporters.get(1).getController().updateLastExportedRecordPosition(eventPosition);
        this.rule.closeExporterDirector();
        this.startExporterDirector(Collections.singletonList(this.exporterDescriptors.get(0)));
        ((ControlledTestExporter)Mockito.verify((Object)this.exporters.get(0), (VerificationMode)TIMEOUT.times(2))).open((Controller)Mockito.any());
        ExportersState exportersState = this.rule.getExportersState();
        Assertions.assertThat((long)exportersState.getPosition(EXPORTER_ID_1)).isEqualTo(eventPosition);
        TestUtil.waitUntil(() -> exportersState.getPosition(EXPORTER_ID_2) == -1L);
    }

    @Test
    public void shouldRecoverFromStartWithNonUpdatingExporter() throws Exception {
        this.startExporterDirector(this.exporterDescriptors);
        long eventPosition = this.writeEvent();
        TestUtil.waitUntil(() -> this.exporters.get(0).getExportedRecords().size() == 1);
        TestUtil.waitUntil(() -> this.exporters.get(1).getExportedRecords().size() == 1);
        this.exporters.get(1).getController().updateLastExportedRecordPosition(eventPosition);
        this.rule.closeExporterDirector();
        this.exporters.get(0).getExportedRecords().clear();
        this.exporters.get(1).getExportedRecords().clear();
        this.startExporterDirector(this.exporterDescriptors);
        TestUtil.waitUntil(() -> this.exporters.get(0).getExportedRecords().size() >= 1);
        Assertions.assertThat(this.exporters.get(0).getExportedRecords()).extracting(Record::getPosition).containsExactly((Object[])new Long[]{eventPosition});
        Assertions.assertThat(this.exporters.get(1).getExportedRecords()).isEmpty();
    }

    private long writeEvent() {
        DeploymentRecord event = new DeploymentRecord();
        return this.rule.writeEvent((Intent)DeploymentIntent.CREATED, (UnifiedRecordValue)event);
    }

    private Consumer<Context> withFilter(final List<RecordType> acceptedTypes, final List<ValueType> valueTypes) {
        return context -> context.setFilter(new Context.RecordFilter(){

            public boolean acceptType(RecordType recordType) {
                return acceptedTypes.contains(recordType);
            }

            public boolean acceptValue(ValueType valueType) {
                return valueTypes.contains(valueType);
            }
        });
    }
}

