/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.stream.ExporterDirector;
import io.camunda.zeebe.broker.exporter.stream.ExporterDirectorContext;
import io.camunda.zeebe.broker.exporter.stream.ExportersState;
import io.camunda.zeebe.broker.exporter.stream.SimplePartitionMessageService;
import io.camunda.zeebe.broker.system.partitions.PartitionMessagingService;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.ZeebeDbFactory;
import io.camunda.zeebe.engine.state.DefaultZeebeDbFactory;
import io.camunda.zeebe.engine.util.TestStreams;
import io.camunda.zeebe.logstreams.util.SynchronousLogStream;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.record.RecordType;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.scheduler.ActorSchedulingService;
import io.camunda.zeebe.scheduler.clock.ActorClock;
import io.camunda.zeebe.scheduler.clock.ControlledActorClock;
import io.camunda.zeebe.scheduler.testing.ActorSchedulerRule;
import io.camunda.zeebe.stream.api.EventFilter;
import io.camunda.zeebe.stream.impl.SkipPositionsFilter;
import io.camunda.zeebe.test.util.AutoCloseableRule;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Set;
import org.junit.rules.ExternalResource;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;
import org.mockito.Mockito;

public final class ExporterRule
implements TestRule {
    private static final int PARTITION_ID = 1;
    private static final int EXPORTER_PROCESSOR_ID = 101;
    private static final String PROCESSOR_NAME = "exporter";
    private static final String STREAM_NAME = "stream";
    private final TemporaryFolder tempFolder = new TemporaryFolder();
    private final AutoCloseableRule closeables = new AutoCloseableRule();
    private final ControlledActorClock clock = new ControlledActorClock();
    private final ActorSchedulerRule actorSchedulerRule = new ActorSchedulerRule((ActorClock)this.clock);
    private final RuleChain chain;
    private final ZeebeDbFactory zeebeDbFactory;
    private final ExporterDirectorContext.ExporterMode exporterMode;
    private ZeebeDb<ZbColumnFamilies> capturedZeebeDb;
    private TestStreams streams;
    private PartitionMessagingService partitionMessagingService = new SimplePartitionMessageService();
    private ExporterDirector director;
    private Duration distributionInterval = Duration.ofSeconds(15L);
    private EventFilter positionsToSkipFilter = SkipPositionsFilter.of(Set.of());

    private ExporterRule(ExporterDirectorContext.ExporterMode exporterMode) {
        this.exporterMode = exporterMode;
        SetupRule rule = new SetupRule(1);
        this.zeebeDbFactory = DefaultZeebeDbFactory.defaultFactory();
        this.chain = RuleChain.outerRule((TestRule)this.tempFolder).around((TestRule)this.actorSchedulerRule).around((TestRule)this.closeables).around((TestRule)rule);
    }

    public static ExporterRule activeExporter() {
        return new ExporterRule(ExporterDirectorContext.ExporterMode.ACTIVE);
    }

    public static ExporterRule passiveExporter() {
        return new ExporterRule(ExporterDirectorContext.ExporterMode.PASSIVE);
    }

    public ExporterRule withPartitionMessageService(PartitionMessagingService partitionMessagingService) {
        this.partitionMessagingService = partitionMessagingService;
        return this;
    }

    public ExporterRule withDistributionInterval(Duration distributionInterval) {
        this.distributionInterval = distributionInterval;
        return this;
    }

    public ExporterRule withPositionsToSkipFilter(EventFilter positionsToSkipFilter) {
        this.positionsToSkipFilter = positionsToSkipFilter;
        return this;
    }

    public Statement apply(Statement base, Description description) {
        return this.chain.apply(base, description);
    }

    public void startExporterDirector(List<ExporterDescriptor> exporterDescriptors) {
        SynchronousLogStream stream = this.streams.getLogStream(STREAM_NAME);
        Path runtimeFolder = this.streams.createRuntimeFolder(stream);
        this.capturedZeebeDb = (ZeebeDb)Mockito.spy((Object)this.zeebeDbFactory.createDb(runtimeFolder.toFile()));
        ExporterDirectorContext context = new ExporterDirectorContext().id(101).name(PROCESSOR_NAME).logStream(stream.getAsyncLogStream()).zeebeDb(this.capturedZeebeDb).exporterMode(this.exporterMode).distributionInterval(this.distributionInterval).partitionMessagingService(this.partitionMessagingService).descriptors(exporterDescriptors).meterRegistry((MeterRegistry)new SimpleMeterRegistry()).positionsToSkipFilter(this.positionsToSkipFilter);
        this.director = new ExporterDirector(context, false);
        this.director.startAsync((ActorSchedulingService)this.actorSchedulerRule.get()).join();
    }

    public ExporterDirector getDirector() {
        return this.director;
    }

    public ControlledActorClock getClock() {
        return this.clock;
    }

    public ExportersState getExportersState() {
        if (this.capturedZeebeDb == null) {
            throw new IllegalStateException("Exporter director has to be started before accessing the database.");
        }
        return new ExportersState(this.capturedZeebeDb, this.capturedZeebeDb.createContext());
    }

    public long writeEvent(Intent intent, UnifiedRecordValue value) {
        return this.writeRecord(RecordType.EVENT, intent, value);
    }

    public long writeCommand(Intent intent, UnifiedRecordValue value) {
        return this.writeRecord(RecordType.COMMAND, intent, value);
    }

    public long writeRecord(RecordType recordType, Intent intent, UnifiedRecordValue value) {
        return this.streams.newRecord(STREAM_NAME).recordType(recordType).intent(intent).event(value).write();
    }

    public void closeExporterDirector() throws Exception {
        this.director.stopAsync().join();
        this.capturedZeebeDb.close();
        this.capturedZeebeDb = null;
    }

    private class SetupRule
    extends ExternalResource {
        private final int partitionId;

        SetupRule(int partitionId) {
            this.partitionId = partitionId;
        }

        protected void before() {
            ExporterRule.this.streams = new TestStreams(ExporterRule.this.tempFolder, ExporterRule.this.closeables, ExporterRule.this.actorSchedulerRule.get());
            ExporterRule.this.streams.createLogStream(ExporterRule.STREAM_NAME, this.partitionId);
        }
    }
}

