/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.exporter.stream.ExporterStateDistributeMessage;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ExporterStateDistributeMessageTest {
    @Test
    public void shouldEncodeExporterState() {
        DirectBuffer metadata1 = BufferUtil.wrapString((String)"e1");
        DirectBuffer metadata2 = BufferUtil.wrapString((String)"e2");
        ExporterStateDistributeMessage distributeMessage = new ExporterStateDistributeMessage();
        distributeMessage.putExporter("elasticsearch", 1001L, metadata1);
        distributeMessage.putExporter("metrics", 95L, metadata2);
        int length = distributeMessage.getLength();
        byte[] bytes = new byte[length];
        UnsafeBuffer buffer = new UnsafeBuffer(bytes);
        distributeMessage.write((MutableDirectBuffer)buffer, 0);
        Assertions.assertThat((int)buffer.capacity()).isEqualTo(distributeMessage.getLength());
        Assertions.assertThat((byte[])bytes).containsSubsequence("elasticsearch".getBytes()).containsSubsequence(metadata1.byteArray()).containsSubsequence("metrics".getBytes()).containsSubsequence(metadata2.byteArray());
    }

    @Test
    public void shouldDecodeExporterState() {
        DirectBuffer metadata1 = BufferUtil.wrapString((String)"e1");
        DirectBuffer metadata2 = BufferUtil.wrapString((String)"e2");
        ExporterStateDistributeMessage distributeMessage = new ExporterStateDistributeMessage();
        distributeMessage.putExporter("elasticsearch", 1001L, metadata1);
        distributeMessage.putExporter("metrics", 95L, metadata2);
        int length = distributeMessage.getLength();
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[length]);
        distributeMessage.write((MutableDirectBuffer)buffer, 0);
        ExporterStateDistributeMessage otherMessage = new ExporterStateDistributeMessage();
        otherMessage.wrap((DirectBuffer)buffer, 0, length);
        Assertions.assertThat((Map)otherMessage.getExporterState()).isEqualTo((Object)distributeMessage.getExporterState());
    }
}

