/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.exporter.stream.ExportersState;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.engine.state.DefaultZeebeDbFactory;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.test.util.AutoCloseableRule;
import io.camunda.zeebe.util.buffer.BufferUtil;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.groups.Tuple;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TemporaryFolder;
import org.junit.rules.TestRule;

public final class ExportersStateTest {
    private static final UnsafeBuffer EMPTY_METADATA = new UnsafeBuffer();
    private final AutoCloseableRule autoCloseableRule = new AutoCloseableRule();
    private final TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public final RuleChain chain = RuleChain.outerRule((TestRule)this.temporaryFolder).around((TestRule)this.autoCloseableRule);
    private ExportersState state;
    private ZeebeDb<ZbColumnFamilies> db;

    @Before
    public void setup() throws Exception {
        File dbDirectory = this.temporaryFolder.newFolder();
        this.db = DefaultZeebeDbFactory.defaultFactory().createDb(dbDirectory);
        this.state = new ExportersState(this.db, this.db.createContext());
    }

    @After
    public void tearDown() throws Exception {
        this.db.close();
    }

    @Test
    public void shouldSetExporterPosition() {
        String exporterId = "exporter-1";
        long exporterPosition = 10L;
        this.state.setPosition("exporter-1", 10L);
        Assertions.assertThat((long)this.state.getPosition("exporter-1")).isEqualTo(10L);
        Assertions.assertThat((Comparable)this.state.getExporterMetadata("exporter-1")).isEqualTo((Object)EMPTY_METADATA);
    }

    @Test
    public void shouldSetExporterState() {
        String exporterId = "exporter-1";
        long exporterPosition = 10L;
        DirectBuffer exporterMetadata = BufferUtil.wrapString((String)"metadata-1");
        this.state.setExporterState("exporter-1", 10L, exporterMetadata);
        Assertions.assertThat((long)this.state.getPosition("exporter-1")).isEqualTo(10L);
        Assertions.assertThat((Comparable)this.state.getExporterMetadata("exporter-1")).isEqualTo((Object)exporterMetadata);
    }

    @Test
    public void shouldSetExporterStateWithoutMetadata() {
        String exporterId = "exporter-1";
        long exporterPosition = 10L;
        this.state.setExporterState("exporter-1", 10L, null);
        Assertions.assertThat((long)this.state.getPosition("exporter-1")).isEqualTo(10L);
        Assertions.assertThat((Comparable)this.state.getExporterMetadata("exporter-1")).isEqualTo((Object)EMPTY_METADATA);
    }

    @Test
    public void shouldOverrideExporterState() {
        String exporterId = "exporter-1";
        long exporterPosition1 = 10L;
        long exporterPosition2 = 20L;
        DirectBuffer exporterMetadata1 = BufferUtil.wrapString((String)"metadata-1");
        DirectBuffer exporterMetadata2 = BufferUtil.wrapString((String)"metadata-2");
        this.state.setExporterState("exporter-1", 10L, exporterMetadata1);
        this.state.setExporterState("exporter-1", 20L, exporterMetadata2);
        Assertions.assertThat((long)this.state.getPosition("exporter-1")).isEqualTo(20L);
        Assertions.assertThat((Comparable)this.state.getExporterMetadata("exporter-1")).isEqualTo((Object)exporterMetadata2);
    }

    @Test
    public void shouldNotClearMetadataIfEmpty() {
        String exporterId = "e1";
        DirectBuffer exporterMetadata1 = BufferUtil.wrapString((String)"metadata-1");
        long exporterPosition1 = 10L;
        this.state.setExporterState("e1", 10L, exporterMetadata1);
        this.state.setExporterState("e1", 10L, null);
        Assertions.assertThat((long)this.state.getPosition("e1")).isEqualTo(10L);
        Assertions.assertThat((Comparable)this.state.getExporterMetadata("e1")).isEqualTo((Object)exporterMetadata1);
    }

    @Test
    public void shouldSetExporterStateWithAndWithoutMetadata() {
        String exporterId1 = "e1";
        DirectBuffer exporterMetadata1 = BufferUtil.wrapString((String)"metadata-1");
        long exporterPosition1 = 10L;
        String exporterId2 = "e2";
        long exporterPosition2 = 20L;
        this.state.setExporterState("e1", 10L, exporterMetadata1);
        this.state.setExporterState("e2", 20L, null);
        Assertions.assertThat((long)this.state.getPosition("e1")).isEqualTo(10L);
        Assertions.assertThat((Comparable)this.state.getExporterMetadata("e1")).isEqualTo((Object)exporterMetadata1);
        Assertions.assertThat((long)this.state.getPosition("e2")).isEqualTo(20L);
        Assertions.assertThat((Comparable)this.state.getExporterMetadata("e2")).isEqualTo((Object)EMPTY_METADATA);
    }

    @Test
    public void shouldReturnUnknownPositionForUnknownExporter() {
        String id = "exporter";
        long position = this.state.getPosition("exporter");
        Assertions.assertThat((long)position).isEqualTo(-1L);
    }

    @Test
    public void shouldReturnEmptyMetadataForUnknownExporter() {
        DirectBuffer exporterMetadata = this.state.getExporterMetadata("unknown-exporter");
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)exporterMetadata).describedAs("Expect that the metadata is empty if the exporter is unknown", new Object[0])).isEqualTo((Object)EMPTY_METADATA);
    }

    @Test
    public void shouldRemoveExporterState() {
        String exporterId1 = "e1";
        DirectBuffer exporterMetadata1 = BufferUtil.wrapString((String)"metadata-1");
        long exporterPosition1 = 10L;
        String exporterId2 = "e2";
        long exporterPosition2 = 20L;
        DirectBuffer exporterMetadata2 = BufferUtil.wrapString((String)"metadata-2");
        this.state.setExporterState("e1", 10L, exporterMetadata1);
        this.state.setExporterState("e2", 20L, exporterMetadata2);
        this.state.removeExporterState("e2");
        Assertions.assertThat((long)this.state.getPosition("e2")).isEqualTo(-1L);
        Assertions.assertThat((Comparable)this.state.getExporterMetadata("e2")).isEqualTo((Object)EMPTY_METADATA);
        Assertions.assertThat((long)this.state.getPosition("e1")).isEqualTo(10L);
        Assertions.assertThat((Comparable)this.state.getExporterMetadata("e1")).isEqualTo((Object)exporterMetadata1);
    }

    @Test
    public void shouldVisitExporterState() {
        String exporterId1 = "e1";
        DirectBuffer exporterMetadata1 = BufferUtil.wrapString((String)"metadata-1");
        long exporterPosition1 = 10L;
        String exporterId2 = "e2";
        long exporterPosition2 = 20L;
        DirectBuffer exporterMetadata2 = BufferUtil.wrapString((String)"metadata-2");
        this.state.setExporterState("e1", 10L, exporterMetadata1);
        this.state.setExporterState("e2", 20L, exporterMetadata2);
        HashMap exporterState = new HashMap();
        this.state.visitExporterState((exporterId, exporterStateEntry) -> exporterState.put(exporterId, Tuple.tuple((Object[])new Object[]{exporterStateEntry.getPosition(), BufferUtil.cloneBuffer((DirectBuffer)exporterStateEntry.getMetadata())})));
        ((MapAssert)Assertions.assertThat(exporterState).hasSize(2)).contains(new Map.Entry[]{Assertions.entry((Object)"e1", (Object)Tuple.tuple((Object[])new Object[]{10L, exporterMetadata1})), Assertions.entry((Object)"e2", (Object)Tuple.tuple((Object[])new Object[]{20L, exporterMetadata2}))});
    }

    @Test
    public void shouldGetLowestPosition() {
        this.state.setPosition("e2", -1L);
        this.state.setPosition("e1", 1L);
        Assertions.assertThat((long)this.state.getLowestPosition()).isEqualTo(-1L);
    }

    @Test
    public void shouldClearState() {
        String exporterId = "e2";
        this.state.setExporterState("e2", 1L, BufferUtil.wrapString((String)"metadata"));
        this.state.removeExporterState("e2");
        Assertions.assertThat((boolean)this.state.hasExporters()).isFalse();
        Assertions.assertThat((long)this.state.getLowestPosition()).isEqualTo(-1L);
    }
}

