/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.exporter.repo.ExporterDescriptor;
import io.camunda.zeebe.broker.exporter.repo.ExporterLoadException;
import io.camunda.zeebe.broker.exporter.stream.ExporterContainer;
import io.camunda.zeebe.broker.exporter.stream.ExporterContainerRuntime;
import io.camunda.zeebe.exporter.api.Exporter;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.exporter.api.context.Controller;
import io.camunda.zeebe.protocol.impl.record.RecordMetadata;
import io.camunda.zeebe.protocol.record.Record;
import io.camunda.zeebe.stream.api.records.TypedRecord;
import io.camunda.zeebe.util.jar.ExternalJarClassLoader;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.dynamic.DynamicType;
import org.agrona.CloseHelper;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;
import org.mockito.Mockito;

@Execution(value=ExecutionMode.CONCURRENT)
final class ExternalExporterContainerTest {
    private static final String EXPORTER_CLASS_NAME = "com.acme.TestExporter";
    private ExporterContainerRuntime runtime;

    ExternalExporterContainerTest() {
    }

    @BeforeEach
    void beforeEach(@TempDir Path storagePath) {
        this.runtime = new ExporterContainerRuntime(storagePath);
    }

    @AfterEach
    void afterEach() {
        CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{this.runtime});
    }

    @Test
    void shouldSetTclOnConfigure(@TempDir File jarDirectory) throws Exception {
        DynamicType.Unloaded<TclExporter> exporterClass = this.createUnloadedExporter();
        File jarFile = exporterClass.toJar(new File(jarDirectory, "exporter.jar"));
        ExporterDescriptor descriptor = this.runtime.loadExternalExporter(jarFile, EXPORTER_CLASS_NAME);
        ExporterContainer container = this.runtime.newContainer(descriptor, 0);
        container.configureExporter();
        TclExporter exporterInstance = (TclExporter)container.getExporter();
        ClassLoader expectedClassLoader = exporterInstance.getClass().getClassLoader();
        ClassLoader actualClassLoader = exporterInstance.onConfigureTCL;
        ((ObjectAssert)Assertions.assertThat((Object)actualClassLoader).isSameAs((Object)expectedClassLoader)).isInstanceOf(ExternalJarClassLoader.class);
    }

    @Test
    void shouldSetTclOnOpen(@TempDir File jarDirectory) throws ExporterLoadException, IOException {
        DynamicType.Unloaded<TclExporter> exporterClass = this.createUnloadedExporter();
        File jarFile = exporterClass.toJar(new File(jarDirectory, "exporter.jar"));
        ExporterDescriptor descriptor = this.runtime.loadExternalExporter(jarFile, EXPORTER_CLASS_NAME);
        ClassLoader expectedClassLoader = descriptor.newInstance().getClass().getClassLoader();
        ExporterContainer container = this.runtime.newContainer(descriptor, 0);
        container.openExporter();
        TclExporter exporterInstance = (TclExporter)container.getExporter();
        ((ObjectAssert)Assertions.assertThat((Object)exporterInstance.onOpenTCL).isSameAs((Object)expectedClassLoader)).isInstanceOf(ExternalJarClassLoader.class);
    }

    @Test
    void shouldSetTclOnExport(@TempDir File jarDirectory) throws ExporterLoadException, IOException {
        DynamicType.Unloaded<TclExporter> exporterClass = this.createUnloadedExporter();
        File jarFile = exporterClass.toJar(new File(jarDirectory, "exporter.jar"));
        ExporterDescriptor descriptor = this.runtime.loadExternalExporter(jarFile, EXPORTER_CLASS_NAME);
        ClassLoader expectedClassLoader = descriptor.newInstance().getClass().getClassLoader();
        ExporterContainer container = this.runtime.newContainer(descriptor, 0);
        TypedRecord record = (TypedRecord)Mockito.mock(TypedRecord.class);
        Mockito.when((Object)record.getPosition()).thenReturn((Object)Long.MAX_VALUE);
        container.exportRecord((RecordMetadata)Mockito.mock(RecordMetadata.class), record);
        TclExporter exporterInstance = (TclExporter)container.getExporter();
        ((ObjectAssert)Assertions.assertThat((Object)exporterInstance.onExportTCL).isSameAs((Object)expectedClassLoader)).isInstanceOf(ExternalJarClassLoader.class);
    }

    @Test
    void shouldSetTclOnClose(@TempDir File jarDirectory) throws ExporterLoadException, IOException {
        DynamicType.Unloaded<TclExporter> exporterClass = this.createUnloadedExporter();
        File jarFile = exporterClass.toJar(new File(jarDirectory, "exporter.jar"));
        ExporterDescriptor descriptor = this.runtime.loadExternalExporter(jarFile, EXPORTER_CLASS_NAME);
        ClassLoader expectedClassLoader = descriptor.newInstance().getClass().getClassLoader();
        ExporterContainer container = new ExporterContainer(descriptor, 0, (MeterRegistry)new SimpleMeterRegistry());
        container.close();
        TclExporter exporterInstance = (TclExporter)container.getExporter();
        ((ObjectAssert)Assertions.assertThat((Object)exporterInstance.onCloseTCL).isSameAs((Object)expectedClassLoader)).isInstanceOf(ExternalJarClassLoader.class);
    }

    @Test
    void shouldRegisterNewMeterInRegistry(@TempDir File jarDirectory) throws Exception {
        DynamicType.Unloaded<ExporterWithMetrics> exporterClass = this.createUnloadedExporter(ExporterWithMetrics.class);
        File jarFile = exporterClass.toJar(new File(jarDirectory, "exporter.jar"));
        ExporterDescriptor descriptor = this.runtime.loadExternalExporter(jarFile, EXPORTER_CLASS_NAME);
        SimpleMeterRegistry registry = new SimpleMeterRegistry();
        ExporterContainer container = new ExporterContainer(descriptor, 0, (MeterRegistry)registry);
        container.configureExporter();
        ((ListAssert)Assertions.assertThat(registry.getMeters().stream()).filteredOn(meter -> meter.getId().getName().contains("new.counter"))).hasSize(1);
    }

    private DynamicType.Unloaded<TclExporter> createUnloadedExporter() {
        return this.createUnloadedExporter(TclExporter.class);
    }

    private <T extends Exporter> DynamicType.Unloaded<T> createUnloadedExporter(Class<T> exporterClass) {
        return new ByteBuddy().subclass(exporterClass).name(EXPORTER_CLASS_NAME).make();
    }

    public static abstract class TclExporter
    implements Exporter {
        public ClassLoader onConfigureTCL;
        public ClassLoader onOpenTCL;
        public ClassLoader onCloseTCL;
        public ClassLoader onExportTCL;

        public void configure(Context context) throws Exception {
            this.onConfigureTCL = Thread.currentThread().getContextClassLoader();
        }

        public void open(Controller controller) {
            this.onOpenTCL = Thread.currentThread().getContextClassLoader();
        }

        public void close() {
            this.onCloseTCL = Thread.currentThread().getContextClassLoader();
        }

        public void export(Record<?> record) {
            this.onExportTCL = Thread.currentThread().getContextClassLoader();
        }
    }

    public static abstract class ExporterWithMetrics
    implements Exporter {
        public void configure(Context context) throws Exception {
            super.configure(context);
            context.getMeterRegistry().counter("new.counter", new String[0]);
        }

        public void export(Record<?> record) {
        }
    }
}

