/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.stream;

import io.camunda.zeebe.broker.system.partitions.PartitionMessagingService;
import io.camunda.zeebe.util.collection.Tuple;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

final class SimplePartitionMessageService
implements PartitionMessagingService {
    public final Map<String, Tuple<Executor, Consumer<ByteBuffer>>> consumers = new HashMap<String, Tuple<Executor, Consumer<ByteBuffer>>>();

    SimplePartitionMessageService() {
    }

    public void subscribe(String subject, Consumer<ByteBuffer> consumer, Executor executor) {
        this.consumers.put(subject, (Tuple<Executor, Consumer<ByteBuffer>>)new Tuple((Object)executor, consumer));
    }

    public void broadcast(String subject, ByteBuffer payload) {
        Tuple<Executor, Consumer<ByteBuffer>> executorConsumerTuple = this.consumers.get(subject);
        if (executorConsumerTuple != null) {
            Executor executor = (Executor)executorConsumerTuple.getLeft();
            executor.execute(() -> ((Consumer)executorConsumerTuple.getRight()).accept(payload));
        }
    }

    public void unsubscribe(String subject) {
        this.consumers.remove(subject);
    }
}

