/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.exporter.util;

import io.camunda.zeebe.exporter.api.Exporter;
import io.camunda.zeebe.exporter.api.context.Context;
import io.camunda.zeebe.exporter.api.context.Controller;
import io.camunda.zeebe.protocol.record.Record;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;

public class ControlledTestExporter
implements Exporter {
    private final List<Record<?>> exportedRecords = new CopyOnWriteArrayList();
    private boolean shouldAutoUpdatePosition;
    private Consumer<Context> onConfigure;
    private Consumer<Controller> onOpen;
    private Runnable onClose;
    private Consumer<Record<?>> onExport;
    private Context context;
    private Controller controller;

    public ControlledTestExporter shouldAutoUpdatePosition(boolean shouldAutoUpdate) {
        this.shouldAutoUpdatePosition = shouldAutoUpdate;
        return this;
    }

    public ControlledTestExporter onConfigure(Consumer<Context> callback) {
        this.onConfigure = callback;
        return this;
    }

    public ControlledTestExporter onOpen(Consumer<Controller> callback) {
        this.onOpen = callback;
        return this;
    }

    public ControlledTestExporter onClose(Runnable callback) {
        this.onClose = callback;
        return this;
    }

    public ControlledTestExporter onExport(Consumer<Record<?>> callback) {
        this.onExport = callback;
        return this;
    }

    public Context getContext() {
        return this.context;
    }

    public void setContext(Context context) {
        this.context = context;
    }

    public Controller getController() {
        return this.controller;
    }

    public void setController(Controller controller) {
        this.controller = controller;
    }

    public List<Record<?>> getExportedRecords() {
        return this.exportedRecords;
    }

    public void configure(Context context) {
        this.context = context;
        if (this.onConfigure != null) {
            this.onConfigure.accept(context);
        }
    }

    public void open(Controller controller) {
        this.controller = controller;
        if (this.onOpen != null) {
            this.onOpen.accept(controller);
        }
    }

    public void close() {
        if (this.onClose != null) {
            this.onClose.run();
        }
    }

    public void export(Record<?> record) {
        Record copiedRecord = record.copyOf();
        if (this.onExport != null) {
            this.onExport.accept(copiedRecord);
        }
        this.exportedRecords.add(copiedRecord);
        if (this.shouldAutoUpdatePosition) {
            this.getController().updateLastExportedRecordPosition(copiedRecord.getPosition());
        }
    }
}

