/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.jobstream;

import io.camunda.zeebe.broker.jobstream.JobStreamErrorHandler;
import io.camunda.zeebe.broker.jobstream.RemoteJobStreamErrorHandler;
import io.camunda.zeebe.logstreams.log.LogAppendEntry;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.stream.job.ActivatedJob;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import io.camunda.zeebe.stream.api.scheduling.TaskResultBuilder;
import io.camunda.zeebe.util.Either;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.agrona.MutableDirectBuffer;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;

final class RemoteJobStreamErrorHandlerTest {
    private final TestConcurrencyControl executor = new TestConcurrencyControl();
    private final TestErrorHandler jobErrorHandler = new TestErrorHandler();

    RemoteJobStreamErrorHandlerTest() {
    }

    @Test
    void shouldNotCallDelegateHandlerIfNoWriter() {
        RemoteJobStreamErrorHandler handler = new RemoteJobStreamErrorHandler((JobStreamErrorHandler)this.jobErrorHandler);
        TestActivatedJob job = new TestActivatedJob(1L, new JobRecord());
        handler.handleError((Throwable)new RuntimeException("Failure"), (ActivatedJob)job);
        Assertions.assertThat(this.jobErrorHandler.errors()).isEmpty();
    }

    @Test
    void shouldDelegateToJobHandler() {
        RemoteJobStreamErrorHandler handler = new RemoteJobStreamErrorHandler((JobStreamErrorHandler)this.jobErrorHandler);
        TestActivatedJob job = new TestActivatedJob(Protocol.encodePartitionId((int)1, (long)1L), new JobRecord());
        RuntimeException error = new RuntimeException("Failure");
        handler.addWriter(1, (entries, ignored) -> Either.right((Object)1L));
        handler.handleError((Throwable)error, (ActivatedJob)job);
        ((ObjectAssert)((ListAssert)Assertions.assertThat(this.jobErrorHandler.errors()).hasSize(1)).first()).extracting(new Function[]{TestErrorHandler.Error::error, TestErrorHandler.Error::job}).containsExactly(new Object[]{error, job});
    }

    @Test
    void shouldRemoveWriter() {
        RemoteJobStreamErrorHandler handler = new RemoteJobStreamErrorHandler((JobStreamErrorHandler)this.jobErrorHandler);
        TestActivatedJob job = new TestActivatedJob(1L, new JobRecord());
        handler.addWriter(1, (entries, ignored) -> Either.right((Object)1L));
        handler.removeWriter(1);
        handler.handleError((Throwable)new RuntimeException("Failure"), (ActivatedJob)job);
        Assertions.assertThat(this.jobErrorHandler.errors()).isEmpty();
    }

    @Test
    void shouldWriteResultingEntries() {
        RemoteJobStreamErrorHandler handler = new RemoteJobStreamErrorHandler((JobStreamErrorHandler)this.jobErrorHandler);
        TestActivatedJob job = new TestActivatedJob(Protocol.encodePartitionId((int)1, (long)1L), new JobRecord());
        ArrayList writtenEntries = new ArrayList();
        handler.addWriter(1, (entries, ignored) -> {
            writtenEntries.addAll(entries);
            return Either.right((Object)1L);
        });
        handler.handleError((Throwable)new RuntimeException("failure"), (ActivatedJob)job);
        Assertions.assertThat(this.jobErrorHandler.errors()).hasSize(1);
        ((ObjectAssert)((ListAssert)Assertions.assertThat(writtenEntries).hasSize(1)).first()).extracting(new Function[]{LogAppendEntry::key, LogAppendEntry::recordValue}).containsExactly(new Object[]{1L, job.jobRecord()});
    }

    private record TestErrorHandler(List<Error> errors) implements JobStreamErrorHandler
    {
        private TestErrorHandler() {
            this(new ArrayList<Error>());
        }

        public void handleError(ActivatedJob job, Throwable error, TaskResultBuilder resultBuilder) {
            resultBuilder.appendCommandRecord(1L, (Intent)JobIntent.FAIL, (UnifiedRecordValue)job.jobRecord());
            this.errors.add(new Error(job, error));
        }

        private record Error(ActivatedJob job, Throwable error) {
        }
    }

    private record TestActivatedJob(long jobKey, JobRecord jobRecord) implements ActivatedJob
    {
        public int getLength() {
            return 0;
        }

        public void write(MutableDirectBuffer buffer, int offset) {
        }
    }
}

