/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.jobstream;

import io.camunda.zeebe.broker.jobstream.YieldingJobStreamErrorHandler;
import io.camunda.zeebe.protocol.impl.record.UnifiedRecordValue;
import io.camunda.zeebe.protocol.impl.record.value.job.JobRecord;
import io.camunda.zeebe.protocol.impl.stream.job.ActivatedJob;
import io.camunda.zeebe.protocol.impl.stream.job.ActivatedJobImpl;
import io.camunda.zeebe.protocol.record.intent.Intent;
import io.camunda.zeebe.protocol.record.intent.JobIntent;
import io.camunda.zeebe.stream.api.scheduling.TaskResultBuilder;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class YieldingJobStreamErrorHandlerTest {
    private final YieldingJobStreamErrorHandler errorHandler = new YieldingJobStreamErrorHandler();
    private final TaskResultBuilder mockTaskResultBuilder = (TaskResultBuilder)Mockito.mock(TaskResultBuilder.class);

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.mockTaskResultBuilder.appendCommandRecord(ArgumentMatchers.anyLong(), (Intent)ArgumentMatchers.any(), (UnifiedRecordValue)ArgumentMatchers.any())).thenReturn((Object)true);
    }

    @Test
    public void shouldYieldJob() {
        ActivatedJobImpl activatedJob = new ActivatedJobImpl().setJobKey(1L).setRecord(new JobRecord());
        this.errorHandler.handleError((ActivatedJob)activatedJob, (Throwable)new RuntimeException("job push failed"), this.mockTaskResultBuilder);
        ((TaskResultBuilder)Mockito.verify((Object)this.mockTaskResultBuilder)).appendCommandRecord(ArgumentMatchers.eq((long)1L), (Intent)ArgumentMatchers.eq((Object)JobIntent.YIELD), (UnifiedRecordValue)ArgumentMatchers.eq((Object)activatedJob.jobRecord()));
    }
}

