/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.logstreams;

import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.storage.log.entry.RaftEntry;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.atomix.raft.zeebe.ZeebeLogAppender;
import io.camunda.zeebe.broker.logstreams.AtomixLogStorage;
import io.camunda.zeebe.broker.logstreams.AtomixLogStorageReader;
import io.camunda.zeebe.journal.JournalMetaStore;
import io.camunda.zeebe.logstreams.storage.LogStorage;
import io.camunda.zeebe.test.util.junit.AutoCloseResources;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Iterator;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;

@AutoCloseResources
final class AtomixLogStorageReaderTest {
    private RaftLog log;
    private AtomixLogStorage logStorage;
    private AtomixLogStorageReader reader;
    @AutoCloseResources.AutoCloseResource
    private final MeterRegistry meterRegistry = new SimpleMeterRegistry();

    AtomixLogStorageReaderTest() {
    }

    @BeforeEach
    void beforeEach(@TempDir File tempDir) {
        this.log = RaftLog.builder((MeterRegistry)this.meterRegistry).withDirectory(tempDir).withMetaStore((JournalMetaStore)Mockito.mock(JournalMetaStore.class)).build();
        Appender appender = new Appender();
        this.logStorage = new AtomixLogStorage(() -> ((RaftLog)this.log).openUncommittedReader(), (ZeebeLogAppender)appender);
        this.reader = this.logStorage.newReader();
    }

    @AfterEach
    void afterEach() {
        CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{this.log, this.reader});
    }

    @Test
    void shouldBeInitializedAtFirstBlock() {
        this.appendIntegerBlock(1);
        this.appendIntegerBlock(2);
        Assertions.assertThat((Iterator)this.reader).hasNext();
        Assertions.assertThat((Comparable)this.reader.next()).isEqualTo((Object)this.mapIntegerToBuffer(1));
    }

    @Test
    void shouldSeekToFirstBlock() {
        this.appendIntegerBlock(1);
        this.appendIntegerBlock(2);
        this.reader.seek(Long.MIN_VALUE);
        Assertions.assertThat((Iterator)this.reader).hasNext();
        Assertions.assertThat((Comparable)this.reader.next()).isEqualTo((Object)this.mapIntegerToBuffer(1));
    }

    @Test
    void shouldSeekToLastBlock() {
        this.appendIntegerBlock(1);
        this.appendIntegerBlock(2);
        this.reader.seek(Long.MAX_VALUE);
        Assertions.assertThat((Iterator)this.reader).hasNext();
        Assertions.assertThat((Comparable)this.reader.next()).isEqualTo((Object)this.mapIntegerToBuffer(2));
    }

    @Test
    void shouldSeekToHighestPositionThatIsLessThanTheGivenOne() {
        this.appendIntegerBlock(1);
        this.appendIntegerBlock(3);
        this.reader.seek(2L);
        Assertions.assertThat((Iterator)this.reader).hasNext();
        Assertions.assertThat((Comparable)this.reader.next()).isEqualTo((Object)this.mapIntegerToBuffer(1));
    }

    @Test
    void shouldSeekToBlockContainingPosition() {
        this.appendIntegerBlock(1);
        this.appendIntegerBlock(2L, 4L, 2);
        this.appendIntegerBlock(5);
        this.reader.seek(3L);
        Assertions.assertThat((Iterator)this.reader).hasNext();
        Assertions.assertThat((Comparable)this.reader.next()).isEqualTo((Object)this.mapIntegerToBuffer(2));
    }

    @Test
    void shouldNotHaveNextIfEndIsReached() {
        this.appendIntegerBlock(1);
        this.appendIntegerBlock(2);
        this.reader.seek(2L);
        this.reader.next();
        Assertions.assertThat((boolean)this.reader.hasNext()).isFalse();
    }

    @Test
    void shouldNotHaveNextIfEmpty() {
        Assertions.assertThat((boolean)this.reader.hasNext()).isFalse();
    }

    @Test
    void shouldHaveNextAfterNewBlockAppended() {
        this.appendIntegerBlock(1);
        Assertions.assertThat((Iterator)this.reader).hasNext();
        Assertions.assertThat((Comparable)this.reader.next()).isEqualTo((Object)this.mapIntegerToBuffer(1));
    }

    private void appendIntegerBlock(int positionAndValue) {
        this.appendIntegerBlock(positionAndValue, positionAndValue, positionAndValue);
    }

    private void appendIntegerBlock(long lowestPosition, long highestPosition, int value) {
        this.logStorage.append(lowestPosition, highestPosition, this.mapIntegerToBuffer(value).byteBuffer(), new LogStorage.AppendListener(this){});
    }

    private DirectBuffer mapIntegerToBuffer(int value) {
        return new UnsafeBuffer(ByteBuffer.allocateDirect(4).putInt(0, value));
    }

    private final class Appender
    implements ZeebeLogAppender {
        private Appender() {
        }

        public void appendEntry(ApplicationEntry entry, ZeebeLogAppender.AppendListener appendListener) {
            IndexedRaftLogEntry indexed = AtomixLogStorageReaderTest.this.log.append(new RaftLogEntry(1L, (RaftEntry)entry));
            appendListener.onWrite(indexed);
            AtomixLogStorageReaderTest.this.log.setCommitIndex(indexed.index());
            appendListener.onCommit(indexed.index());
        }
    }
}

