/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.MemberId;
import io.camunda.zeebe.broker.Broker;
import io.camunda.zeebe.broker.SpringBrokerBridge;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.partitioning.PartitionManagerImpl;
import io.camunda.zeebe.broker.system.SystemContext;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.test.EmbeddedBrokerRule;
import io.camunda.zeebe.broker.test.TestActorSchedulerFactory;
import io.camunda.zeebe.broker.test.TestBrokerClientFactory;
import io.camunda.zeebe.broker.test.TestClusterFactory;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.net.InetSocketAddress;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

final class PartitionJoinTest {
    private final MeterRegistry meterRegistry = new SimpleMeterRegistry();

    PartitionJoinTest() {
    }

    @Test
    void canJoinPartition(@TempDir Path tmp) {
        Broker existingBroker = this.buildBroker(tmp.resolve("broker-0"), brokerCfg -> {
            ClusterCfg clusterCfg = brokerCfg.getCluster();
            clusterCfg.setClusterSize(1);
            clusterCfg.setNodeId(0);
            clusterCfg.setPartitionsCount(1);
            clusterCfg.setReplicationFactor(1);
        });
        InetSocketAddress initialContactPoint = existingBroker.getConfig().getNetwork().getInternalApi().getAdvertisedAddress();
        Broker joiningBroker = this.buildBroker(tmp.resolve("broker-1"), brokerCfg -> {
            ClusterCfg clusterCfg = brokerCfg.getCluster();
            clusterCfg.setInitialContactPoints(List.of(initialContactPoint.getHostName() + ":" + initialContactPoint.getPort()));
            clusterCfg.setClusterSize(1);
            clusterCfg.setNodeId(1);
            clusterCfg.setPartitionsCount(0);
            clusterCfg.setReplicationFactor(0);
        });
        try (Broker existing = (Broker)existingBroker.start().join();
             Broker joining = (Broker)joiningBroker.start().join();){
            Awaitility.await((String)"Joining broker knows about existing broker").pollDelay(Duration.ofSeconds(1L)).pollInterval(Duration.ofMillis(500L)).until(() -> joining.getBrokerContext().getClusterServices().getMembershipService().getMembers(), members -> members.size() == 2);
            PartitionManagerImpl partitionManager = (PartitionManagerImpl)joining.getBrokerContext().getPartitionManager();
            Assertions.assertThat((Future)partitionManager.join(1, Map.of(MemberId.from((String)"0"), 2, MemberId.from((String)"1"), 1))).succeedsWithin(Duration.ofSeconds(10L));
        }
    }

    Broker buildBroker(Path tmp, Consumer<BrokerCfg> configure) {
        BrokerCfg brokerCfg = new BrokerCfg();
        EmbeddedBrokerRule.assignSocketAddresses(brokerCfg);
        brokerCfg.init(tmp.toAbsolutePath().toString());
        configure.accept(brokerCfg);
        AtomixCluster atomixCluster = TestClusterFactory.createAtomixCluster(brokerCfg, this.meterRegistry);
        ActorScheduler actorScheduler = TestActorSchedulerFactory.ofBrokerConfig(brokerCfg);
        BrokerClient brokerClient = TestBrokerClientFactory.createBrokerClient(atomixCluster, actorScheduler);
        SystemContext systemContext = new SystemContext(brokerCfg, actorScheduler, atomixCluster, brokerClient);
        return new Broker(systemContext, new SpringBrokerBridge(), List.of());
    }
}

