/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.partitioning.startup.RaftPartitionFactory;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.test.util.junit.AutoCloseResources;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.springframework.util.unit.DataSize;

public final class RaftPartitionFactoryTest {
    @AutoCloseResources.AutoCloseResource
    MeterRegistry meterRegistry = new SimpleMeterRegistry();

    @Test
    void shouldSetElectionTimeout() {
        Duration expected = Duration.ofSeconds(15L);
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getCluster().setElectionTimeout(expected);
        RaftPartition partition = this.buildRaftPartition(brokerCfg);
        Assertions.assertThat((Duration)partition.getPartitionConfig().getElectionTimeout()).isEqualTo((Object)expected);
    }

    @Test
    void shouldSetHeartbeatInterval() {
        Duration expected = Duration.ofSeconds(10L);
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getCluster().setHeartbeatInterval(expected);
        RaftPartition partition = this.buildRaftPartition(brokerCfg);
        Assertions.assertThat((Duration)partition.getPartitionConfig().getHeartbeatInterval()).isEqualTo((Object)expected);
    }

    @Test
    void shouldSetRaftRequestTimeout() {
        Duration expected = Duration.ofSeconds(17L);
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getExperimental().getRaft().setRequestTimeout(expected);
        RaftPartition partition = this.buildRaftPartition(brokerCfg);
        Assertions.assertThat((Duration)partition.getPartitionConfig().getRequestTimeout()).isEqualTo((Object)expected);
    }

    @Test
    void shouldSetRaftSnapshotRequestTimeout() {
        Duration expected = Duration.ofSeconds(15L);
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getExperimental().getRaft().setSnapshotRequestTimeout(expected);
        RaftPartition partition = this.buildRaftPartition(brokerCfg);
        Assertions.assertThat((Duration)partition.getPartitionConfig().getSnapshotRequestTimeout()).isEqualTo((Object)expected);
    }

    @Test
    void shouldSetRaftConfigurationChangeTimeout() {
        Duration expected = Duration.ofSeconds(15L);
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getExperimental().getRaft().setConfigurationChangeTimeout(expected);
        RaftPartition partition = this.buildRaftPartition(brokerCfg);
        Assertions.assertThat((Duration)partition.getPartitionConfig().getConfigurationChangeTimeout()).isEqualTo((Object)expected);
    }

    @Test
    void shouldSetRaftMaxQuorumResponseTimeout() {
        Duration expected = Duration.ofSeconds(13L);
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getExperimental().getRaft().setMaxQuorumResponseTimeout(expected);
        RaftPartition partition = this.buildRaftPartition(brokerCfg);
        Assertions.assertThat((Duration)partition.getPartitionConfig().getMaxQuorumResponseTimeout()).isEqualTo((Object)expected);
    }

    @Test
    void shouldSetRaftMinStepDownFailureCount() {
        int expected = 8;
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getExperimental().getRaft().setMinStepDownFailureCount(8);
        RaftPartition partition = this.buildRaftPartition(brokerCfg);
        Assertions.assertThat((int)partition.getPartitionConfig().getMinStepDownFailureCount()).isEqualTo(8);
    }

    @Test
    void shouldSetMaxAppendBatchSize() {
        DataSize expected = DataSize.ofMegabytes((long)123L);
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getExperimental().setMaxAppendBatchSize(expected);
        RaftPartition partition = this.buildRaftPartition(brokerCfg);
        Assertions.assertThat((int)partition.getPartitionConfig().getMaxAppendBatchSize()).isEqualTo(expected.toBytes());
    }

    @Test
    void shouldSetMaxAppendsPerFollower() {
        int expected = 11;
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getExperimental().setMaxAppendsPerFollower(11);
        RaftPartition partition = this.buildRaftPartition(brokerCfg);
        Assertions.assertThat((int)partition.getPartitionConfig().getMaxAppendsPerFollower()).isEqualTo(11);
    }

    @Test
    void shouldEnablePriorityElection() {
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getCluster().getRaft().setEnablePriorityElection(true);
        RaftPartition partition = this.buildRaftPartition(brokerCfg);
        Assertions.assertThat((boolean)partition.getPartitionConfig().isPriorityElectionEnabled()).isTrue();
    }

    @Test
    void shouldDisablePriorityElection() {
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getCluster().getRaft().setEnablePriorityElection(false);
        RaftPartition partition = this.buildRaftPartition(brokerCfg);
        Assertions.assertThat((boolean)partition.getPartitionConfig().isPriorityElectionEnabled()).isFalse();
    }

    @Test
    void shouldSetPreferSnapshotReplicationThreshold() {
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getExperimental().getRaft().setPreferSnapshotReplicationThreshold(1000);
        RaftPartition partition = this.buildRaftPartition(brokerCfg);
        Assertions.assertThat((int)partition.getPartitionConfig().getPreferSnapshotReplicationThreshold()).isEqualTo(1000);
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void shouldSetSegmentFilesPreallocation(boolean value) {
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getExperimental().getRaft().setPreallocateSegmentFiles(value);
        RaftPartition partition = this.buildRaftPartition(brokerCfg);
        Assertions.assertThat((boolean)partition.getPartitionConfig().getStorageConfig().isPreallocateSegmentFiles()).isEqualTo(value);
    }

    private RaftPartition buildRaftPartition(BrokerCfg brokerCfg) {
        return new RaftPartitionFactory(brokerCfg).createRaftPartition(new PartitionMetadata(PartitionId.from((String)"test", (int)1), Set.of(MemberId.from((String)"1")), Map.of(), 1, MemberId.from((String)"1")), this.meterRegistry);
    }
}

