/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.AtomixClusterBuilder;
import io.atomix.cluster.AtomixClusterRule;
import io.atomix.cluster.MemberId;
import io.atomix.cluster.NoopSnapshotStore;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.impl.DefaultPartitionManagementService;
import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.RaftPartitionConfig;
import io.atomix.raft.partition.RaftStorageConfig;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.test.util.junit.AutoCloseResources;
import io.camunda.zeebe.topology.util.RoundRobinPartitionDistributor;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.agrona.LangUtil;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;

public final class RaftRolesTest {
    @Rule
    public AtomixClusterRule atomixClusterRule = new AtomixClusterRule();
    @AutoCloseResources.AutoCloseResource
    MeterRegistry meterRegistry = new SimpleMeterRegistry();

    @Test
    public void testRoleChangedListener() throws Exception {
        CompletableFuture roleChanged = new CompletableFuture();
        CompletableFuture<Void> joinFuture = this.startSingleNodeSinglePartitionWithPartitionConsumer(partition -> {
            RaftPartition raftPartition = (RaftPartition)partition;
            raftPartition.addRoleChangeListener((role, term) -> roleChanged.complete(null));
        });
        joinFuture.join();
        roleChanged.get();
    }

    @Test
    public void testExceptionInRoleChangedListener() throws Exception {
        CompletableFuture roleChanged = new CompletableFuture();
        CompletableFuture<Void> joinFuture = this.startSingleNodeSinglePartitionWithPartitionConsumer(partition -> {
            RaftPartition raftPartition = (RaftPartition)partition;
            raftPartition.addRoleChangeListener((role, term) -> {
                roleChanged.complete(null);
                throw new RuntimeException("expected");
            });
        });
        joinFuture.join();
        roleChanged.get(60L, TimeUnit.SECONDS);
    }

    @Test
    public void testStepDownInRoleChangedListener() throws Exception {
        CompletableFuture roleChanged = new CompletableFuture();
        CountDownLatch followerLatch = new CountDownLatch(2);
        ArrayList roles = new ArrayList();
        this.startSingleNodeSinglePartitionWithPartitionConsumer(partition -> {
            RaftPartition raftPartition = (RaftPartition)partition;
            raftPartition.addRoleChangeListener((role, term) -> {
                roles.add(role);
                if (!roleChanged.isDone() && role == RaftServer.Role.LEADER) {
                    roleChanged.complete(null);
                    raftPartition.stepDown();
                } else if (role == RaftServer.Role.FOLLOWER) {
                    followerLatch.countDown();
                }
            });
        }).join();
        roleChanged.get(60L, TimeUnit.SECONDS);
        followerLatch.await(10L, TimeUnit.SECONDS);
        Assertions.assertThat(roles).containsSequence((Object[])new RaftServer.Role[]{RaftServer.Role.INACTIVE, RaftServer.Role.LEADER, RaftServer.Role.LEADER});
    }

    private CompletableFuture<Void> startSingleNodeSinglePartitionWithPartitionConsumer(Consumer<? super Partition> partitionConsumer) {
        return this.startPartitionManagerSinglePartitionWithPartitionConsumer(1, Collections.singletonList(1), partitionConsumer);
    }

    private CompletableFuture<Void> startPartitionManagerSinglePartitionWithPartitionConsumer(int nodeId, List<Integer> nodeIds, Consumer<? super Partition> partitionConsumer) {
        return this.startPartitionManagerWithPartitionConsumer(nodeId, 1, nodeIds, partitionConsumer);
    }

    private CompletableFuture<Void> startPartitionManagerWithPartitionConsumer(int nodeId, int partitionCount, List<Integer> nodeIds, Consumer<? super Partition> partitionConsumer) {
        Set memberIds = nodeIds.stream().map(id -> MemberId.from((String)Integer.toString(id))).collect(Collectors.toSet());
        List<PartitionId> partitionIds = IntStream.rangeClosed(1, partitionCount).mapToObj(id -> PartitionId.from((String)"test", (int)id)).sorted().toList();
        Set partitionDistribution = new RoundRobinPartitionDistributor().distributePartitions(memberIds, partitionIds, memberIds.size());
        List<RaftPartition> partitions = partitionDistribution.stream().map(metadata -> {
            RaftStorageConfig raftStorageConfig = new RaftStorageConfig();
            RaftPartitionConfig raftPartitionConfig = new RaftPartitionConfig();
            raftPartitionConfig.setStorageConfig(raftStorageConfig);
            raftPartitionConfig.setPriorityElectionEnabled(false);
            return new RaftPartition(metadata, raftPartitionConfig, new File(new File(this.atomixClusterRule.getDataDir(), "log"), "" + nodeId), this.meterRegistry);
        }).toList();
        CompletableFuture atomixFuture = this.atomixClusterRule.startAtomix(nodeId, nodeIds, AtomixClusterBuilder::build);
        try {
            AtomixCluster atomix = (AtomixCluster)atomixFuture.get();
            DefaultPartitionManagementService managementService = new DefaultPartitionManagementService(atomix.getMembershipService(), atomix.getCommunicationService());
            partitions.forEach(partitionConsumer);
            return CompletableFuture.allOf((CompletableFuture[])partitions.stream().map(partition -> partition.bootstrap((PartitionManagementService)managementService, (ReceivableSnapshotStore)new NoopSnapshotStore())).toArray(CompletableFuture[]::new));
        }
        catch (InterruptedException | ExecutionException e) {
            LangUtil.rethrowUnchecked((Throwable)e);
            return null;
        }
    }
}

