/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.distribution;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.camunda.zeebe.broker.partitioning.distribution.FixedPartitionDistributor;
import io.camunda.zeebe.broker.partitioning.distribution.FixedPartitionDistributorBuilder;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class FixedPartitionDistributorTest {
    private static final String PARTITION_GROUP_NAME = "group";

    FixedPartitionDistributorTest() {
    }

    @Test
    void shouldFailOnMissingPartition() {
        FixedPartitionDistributor distributor = new FixedPartitionDistributorBuilder(PARTITION_GROUP_NAME).assignMember(2, 0, 1).build();
        Set<MemberId> clusterMembers = Set.of(this.node(0));
        List<PartitionId> sortedPartitionIds = List.of(this.partition(1), this.partition(2));
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatCode(() -> distributor.distributePartitions(clusterMembers, sortedPartitionIds, 1)).as("should fail because partition 1 exists, but was not configured", new Object[0])).isInstanceOf(IllegalStateException.class)).hasMessage("Expected to distribute partition 1, but no members configured for it");
    }

    @Test
    void shouldFailOnUnknownMember() {
        FixedPartitionDistributor distributor = new FixedPartitionDistributorBuilder(PARTITION_GROUP_NAME).assignMember(1, 0, 1).build();
        Set<MemberId> clusterMembers = Set.of(this.node(1));
        List<PartitionId> sortedPartitionIds = List.of(this.partition(1), this.partition(2));
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatCode(() -> distributor.distributePartitions(clusterMembers, sortedPartitionIds, 1)).as("should fail because node 0 is not part of the cluster members, only node 1 is", new Object[0])).isInstanceOf(IllegalStateException.class)).hasMessage("Expected partition 1 to be replicated across a cluster made of members [1], but the following configured members [0] are not part of the cluster");
    }

    @Test
    void shouldFailOnMissingReplica() {
        FixedPartitionDistributor distributor = new FixedPartitionDistributorBuilder(PARTITION_GROUP_NAME).assignMember(1, 0, 1).build();
        Set<MemberId> clusterMembers = Set.of(this.node(0));
        List<PartitionId> sortedPartitionIds = List.of(this.partition(1), this.partition(2));
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatCode(() -> distributor.distributePartitions(clusterMembers, sortedPartitionIds, 2)).as("should fail because only one replica, 0, is specified, and 1 is missing", new Object[0])).isInstanceOf(IllegalStateException.class)).hasMessage("Expected each partition to be replicated across exactly 2 members, but partition 1 is replicated across members [0]");
    }

    @Test
    void shouldDistributeEvenly() {
        Set<PartitionMetadata> expectedDistribution = Set.of(new PartitionMetadata(this.partition(1), Set.of(this.node(0), this.node(1)), Map.of(this.node(0), 1, this.node(1), 2), 2, this.node(1)), new PartitionMetadata(this.partition(2), Set.of(this.node(0), this.node(1)), Map.of(this.node(0), 2, this.node(1), 1), 2, this.node(0)));
        FixedPartitionDistributor distributor = new FixedPartitionDistributorBuilder(PARTITION_GROUP_NAME).assignMember(1, 0, 1).assignMember(1, 1, 2).assignMember(2, 0, 2).assignMember(2, 1, 1).build();
        Set<MemberId> clusterMembers = Set.of(this.node(0), this.node(1));
        List<PartitionId> sortedPartitionIds = List.of(this.partition(1), this.partition(2));
        Set distribution = distributor.distributePartitions(clusterMembers, sortedPartitionIds, 2);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)distribution).as("should distribute the partitions as expected", new Object[0])).containsExactlyInAnyOrderElementsOf(expectedDistribution);
    }

    @Test
    void shouldDistributeUnevenly() {
        Set<PartitionMetadata> expectedDistribution = Set.of(new PartitionMetadata(this.partition(1), Set.of(this.node(0)), Map.of(this.node(0), 2), 2, this.node(0)), new PartitionMetadata(this.partition(2), Set.of(this.node(0)), Map.of(this.node(0), 2), 2, this.node(0)));
        FixedPartitionDistributor distributor = new FixedPartitionDistributorBuilder(PARTITION_GROUP_NAME).assignMember(1, 0, 2).assignMember(2, 0, 2).build();
        Set<MemberId> clusterMembers = Set.of(this.node(0), this.node(1));
        List<PartitionId> sortedPartitionIds = List.of(this.partition(1), this.partition(2));
        Set distribution = distributor.distributePartitions(clusterMembers, sortedPartitionIds, 1);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)distribution).as("should distribute the partitions as expected", new Object[0])).containsExactlyInAnyOrderElementsOf(expectedDistribution);
    }

    @Test
    void shouldNotAssignPrimaryIfMoreThanOnePotentialPrimary() {
        Set<PartitionMetadata> expectedDistribution = Set.of(new PartitionMetadata(this.partition(1), Set.of(this.node(0), this.node(1)), Map.of(this.node(0), 2, this.node(1), 2), 2, null));
        FixedPartitionDistributor distributor = new FixedPartitionDistributorBuilder(PARTITION_GROUP_NAME).assignMember(1, 0, 2).assignMember(1, 1, 2).build();
        Set<MemberId> clusterMembers = Set.of(this.node(0), this.node(1));
        List<PartitionId> sortedPartitionIds = List.of(this.partition(1));
        Set distribution = distributor.distributePartitions(clusterMembers, sortedPartitionIds, 2);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)distribution).as("should distribute the partitions as expected", new Object[0])).containsExactlyInAnyOrderElementsOf(expectedDistribution);
    }

    private PartitionId partition(int id) {
        return PartitionId.from((String)PARTITION_GROUP_NAME, (int)id);
    }

    private MemberId node(int id) {
        return MemberId.from((String)String.valueOf(id));
    }
}

