/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.partitioning.topology;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.camunda.zeebe.broker.partitioning.topology.PartitionDistributionResolver;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.PartitioningCfg;
import io.camunda.zeebe.broker.system.configuration.partitioning.Scheme;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class StaticPartitionDistributionResolverTest {
    StaticPartitionDistributionResolverTest() {
    }

    @Test
    void shouldGenerateRoundRobinDistribution() {
        Map<Integer, Set<Integer>> expectedDistribution = Map.of(1, Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)), 2, Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(3)), 3, Set.of(Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(4)), 4, Set.of(Integer.valueOf(3), Integer.valueOf(4), Integer.valueOf(5)), 5, Set.of(Integer.valueOf(4), Integer.valueOf(5), Integer.valueOf(0)), 6, Set.of(Integer.valueOf(5), Integer.valueOf(0), Integer.valueOf(1)));
        PartitioningCfg partitioningCfg = new PartitioningCfg();
        partitioningCfg.setScheme(Scheme.ROUND_ROBIN);
        ClusterCfg clusterCfg = new ClusterCfg();
        clusterCfg.setClusterSize(6);
        clusterCfg.setPartitionsCount(6);
        clusterCfg.setReplicationFactor(3);
        Set partitionDistribution = PartitionDistributionResolver.getStaticConfiguration((ClusterCfg)clusterCfg, (PartitioningCfg)partitioningCfg, (MemberId)MemberId.from((String)"1")).generatePartitionDistribution();
        Map<Integer, Set<Integer>> actualDistribution = this.getDistribution(partitionDistribution);
        Assertions.assertThat(actualDistribution).containsExactlyInAnyOrderEntriesOf(expectedDistribution);
    }

    private Map<Integer, Set<Integer>> getDistribution(Set<PartitionMetadata> partitionDistribution) {
        return partitionDistribution.stream().collect(Collectors.toMap(p -> (Integer)p.id().id(), p -> p.members().stream().map(m -> Integer.valueOf((String)((Object)m.id()))).collect(Collectors.toSet())));
    }

    @Test
    void shouldGenerateFixedDistribution() throws IOException {
        Map<Integer, Set<Integer>> expectedDistribution = Map.of(1, Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)), 2, Set.of(Integer.valueOf(1), Integer.valueOf(2), Integer.valueOf(0)), 3, Set.of(Integer.valueOf(0), Integer.valueOf(1), Integer.valueOf(2)));
        String config = "fixed:\n   - partitionId: 1\n     nodes:\n       - nodeId: 0\n         priority: 1\n       - nodeId: 1\n         priority: 2\n       - nodeId: 2\n         priority: 3\n   - partitionId: 2\n     nodes:\n       - nodeId: 0\n         priority: 3\n       - nodeId: 1\n         priority: 2\n       - nodeId: 2\n         priority: 1\n   - partitionId: 3\n     nodes:\n       - nodeId: 0\n         priority: 2\n       - nodeId: 1\n         priority: 3\n       - nodeId: 2\n         priority: 2\n";
        PartitioningCfg partitioningCfg = (PartitioningCfg)new ObjectMapper((JsonFactory)new YAMLFactory()).readValue("fixed:\n   - partitionId: 1\n     nodes:\n       - nodeId: 0\n         priority: 1\n       - nodeId: 1\n         priority: 2\n       - nodeId: 2\n         priority: 3\n   - partitionId: 2\n     nodes:\n       - nodeId: 0\n         priority: 3\n       - nodeId: 1\n         priority: 2\n       - nodeId: 2\n         priority: 1\n   - partitionId: 3\n     nodes:\n       - nodeId: 0\n         priority: 2\n       - nodeId: 1\n         priority: 3\n       - nodeId: 2\n         priority: 2\n", PartitioningCfg.class);
        ClusterCfg clusterCfg = new ClusterCfg();
        clusterCfg.setClusterSize(3);
        clusterCfg.setPartitionsCount(3);
        clusterCfg.setReplicationFactor(3);
        Set partitionDistribution = PartitionDistributionResolver.getStaticConfiguration((ClusterCfg)clusterCfg, (PartitioningCfg)partitioningCfg, (MemberId)MemberId.from((String)"1")).generatePartitionDistribution();
        Map<Integer, Set<Integer>> actualDistribution = this.getDistribution(partitionDistribution);
        Assertions.assertThat(actualDistribution).containsExactlyInAnyOrderEntriesOf(expectedDistribution);
    }

    private static MemberId member(int id) {
        return MemberId.from((String)String.valueOf(id));
    }
}

