/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.raft;

import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.storage.log.entry.SerializedApplicationEntry;
import io.atomix.raft.zeebe.EntryValidator;
import io.camunda.zeebe.broker.raft.ZeebeEntryValidator;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.CONCURRENT)
final class ZeebeEntryValidatorTest {
    private final ZeebeEntryValidator validator = new ZeebeEntryValidator();

    ZeebeEntryValidatorTest() {
    }

    @Test
    void shouldRejectEntryWithGapInPosition() {
        SerializedApplicationEntry lastEntry = new SerializedApplicationEntry(1L, 1L, (DirectBuffer)new UnsafeBuffer());
        SerializedApplicationEntry entry = new SerializedApplicationEntry(3L, 3L, (DirectBuffer)new UnsafeBuffer());
        EntryValidator.ValidationResult result = this.validator.validateEntry((ApplicationEntry)lastEntry, (ApplicationEntry)entry);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)result.failed()).as("validation has failed", new Object[0])).isTrue();
    }

    @Test
    void shouldAcceptEntryWithoutGapInPosition() {
        SerializedApplicationEntry lastEntry = new SerializedApplicationEntry(1L, 2L, (DirectBuffer)new UnsafeBuffer());
        SerializedApplicationEntry entry = new SerializedApplicationEntry(3L, 3L, (DirectBuffer)new UnsafeBuffer());
        EntryValidator.ValidationResult result = this.validator.validateEntry((ApplicationEntry)lastEntry, (ApplicationEntry)entry);
        ((ObjectAssert)Assertions.assertThat((Object)result).as("validation was successful", new Object[0])).isEqualTo((Object)EntryValidator.ValidationResult.ok());
    }

    @Test
    void shouldAcceptEntryWhenNoLastKnownEntry() {
        SerializedApplicationEntry entry = new SerializedApplicationEntry(3L, 3L, (DirectBuffer)new UnsafeBuffer());
        EntryValidator.ValidationResult result = this.validator.validateEntry(null, (ApplicationEntry)entry);
        ((ObjectAssert)Assertions.assertThat((Object)result).as("validation was successful", new Object[0])).isEqualTo((Object)EntryValidator.ValidationResult.ok());
    }
}

