/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system;

import io.camunda.zeebe.broker.test.EmbeddedBrokerRule;
import java.net.InetSocketAddress;
import java.net.Socket;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Rule;
import org.junit.Test;

public final class EmbeddedGatewayTest {
    @Rule
    public final EmbeddedBrokerRule brokerWithEnabledGateway = new EmbeddedBrokerRule(cfg -> cfg.getGateway().setEnable(true));
    @Rule
    public final EmbeddedBrokerRule brokerWithDisabledGateway = new EmbeddedBrokerRule(cfg -> cfg.getGateway().setEnable(false));

    @Test
    public void shouldConfigureGateway() {
        Socket socket;
        InetSocketAddress address = this.brokerWithEnabledGateway.getGatewayAddress();
        try {
            socket = new Socket(address.getHostName(), address.getPort());
            socket.close();
        }
        catch (Exception e) {
            AssertionsForClassTypes.fail((String)("Failed to connect to gateway with address: " + String.valueOf(address)), (Throwable)e);
        }
        address = this.brokerWithDisabledGateway.getGatewayAddress();
        try {
            socket = new Socket(address.getHostName(), address.getPort());
            try {
                AssertionsForClassTypes.fail((String)("Unexpected to be able to connect to gateway with address: " + String.valueOf(address)));
            }
            finally {
                socket.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

