/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system;

import io.atomix.cluster.AtomixCluster;
import io.camunda.zeebe.broker.client.api.BrokerClient;
import io.camunda.zeebe.broker.system.InvalidConfigurationException;
import io.camunda.zeebe.broker.system.SystemContext;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.PartitioningCfg;
import io.camunda.zeebe.broker.system.configuration.backup.BackupStoreCfg;
import io.camunda.zeebe.broker.system.configuration.partitioning.FixedPartitionCfg;
import io.camunda.zeebe.broker.system.configuration.partitioning.Scheme;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import java.io.File;
import java.security.cert.CertificateException;
import java.time.Duration;
import java.util.List;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.springframework.util.unit.DataSize;
import org.springframework.util.unit.DataUnit;

final class SystemContextTest {
    SystemContextTest() {
    }

    @Test
    void shouldThrowExceptionIfSnapshotPeriodIsNegative() {
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getData().setSnapshotPeriod(Duration.ofMinutes(-1L));
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Snapshot period PT-1M needs to be larger then or equals to one minute.");
    }

    @Test
    void shouldThrowExceptionIfSnapshotPeriodIsTooSmall() {
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getData().setSnapshotPeriod(Duration.ofSeconds(1L));
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Snapshot period PT1S needs to be larger then or equals to one minute.");
    }

    @Test
    void shouldThrowExceptionIfBatchSizeIsNegative() {
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getExperimental().setMaxAppendBatchSize(DataSize.of((long)-1L, (DataUnit)DataUnit.BYTES));
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected to have an append batch size maximum which is non negative and smaller then '2147483647', but was '-1B'.");
    }

    @Test
    void shouldThrowExceptionIfBatchSizeIsTooLarge() {
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getExperimental().setMaxAppendBatchSize(DataSize.of((long)3L, (DataUnit)DataUnit.GIGABYTES));
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected to have an append batch size maximum which is non negative and smaller then '2147483647', but was '3221225472B'.");
    }

    @Test
    void shouldNotThrowExceptionIfSnapshotPeriodIsEqualToOneMinute() {
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getData().setSnapshotPeriod(Duration.ofMinutes(1L));
        SystemContext systemContext = this.initSystemContext(brokerCfg);
        Assertions.assertThat((Duration)systemContext.getBrokerConfiguration().getData().getSnapshotPeriod()).isEqualTo((Object)Duration.ofMinutes(1L));
    }

    @Test
    void shouldThrowExceptionIfFixedPartitioningSchemeDoesNotSpecifyAnyPartitions() {
        BrokerCfg brokerCfg = new BrokerCfg();
        PartitioningCfg config = brokerCfg.getExperimental().getPartitioning();
        config.setScheme(Scheme.FIXED);
        config.setFixed(List.of());
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Expected fixed partition scheme to define configurations for all partitions such that they have 1 replicas, but partition 1 has 0 configured replicas: []");
    }

    @Test
    void shouldThrowExceptionIfFixedPartitioningSchemeIsNotExhaustive() {
        BrokerCfg brokerCfg = new BrokerCfg();
        PartitioningCfg config = brokerCfg.getExperimental().getPartitioning();
        FixedPartitionCfg fixedPartition = new FixedPartitionCfg();
        config.setScheme(Scheme.FIXED);
        config.setFixed(List.of(fixedPartition));
        fixedPartition.getNodes().add(new FixedPartitionCfg.NodeCfg());
        brokerCfg.getCluster().setPartitionsCount(2);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Expected fixed partition scheme to define configurations for all partitions such that they have 1 replicas, but partition 2 has 0 configured replicas: []");
    }

    @ParameterizedTest
    @ValueSource(ints={-1, 2})
    void shouldThrowExceptionIfFixedPartitioningSchemeUsesInvalidPartitionId(int invalidId) {
        BrokerCfg brokerCfg = new BrokerCfg();
        PartitioningCfg config = brokerCfg.getExperimental().getPartitioning();
        FixedPartitionCfg fixedPartition = new FixedPartitionCfg();
        config.setScheme(Scheme.FIXED);
        config.setFixed(List.of(fixedPartition));
        fixedPartition.setPartitionId(invalidId);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Expected fixed partition scheme to define entries with a valid partitionId between 1 and 1, but %d was given", new Object[]{invalidId});
    }

    @ParameterizedTest
    @ValueSource(ints={-1, 2})
    void shouldThrowExceptionIfFixedPartitioningSchemeUsesInvalidNodeId(int invalidId) {
        BrokerCfg brokerCfg = new BrokerCfg();
        PartitioningCfg config = brokerCfg.getExperimental().getPartitioning();
        FixedPartitionCfg fixedPartition = new FixedPartitionCfg();
        FixedPartitionCfg.NodeCfg node = new FixedPartitionCfg.NodeCfg();
        config.setScheme(Scheme.FIXED);
        config.setFixed(List.of(fixedPartition));
        fixedPartition.getNodes().add(node);
        node.setNodeId(invalidId);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Expected fixed partition scheme for partition 1 to define nodes with a nodeId between 0 and 0, but it was %d", new Object[]{invalidId});
    }

    @Test
    void shouldThrowExceptionIfFixedPartitioningSchemeHasSamePriorities() {
        BrokerCfg brokerCfg = new BrokerCfg();
        PartitioningCfg config = brokerCfg.getExperimental().getPartitioning();
        FixedPartitionCfg fixedPartition = new FixedPartitionCfg();
        List<FixedPartitionCfg.NodeCfg> nodes = List.of(new FixedPartitionCfg.NodeCfg(), new FixedPartitionCfg.NodeCfg());
        brokerCfg.getCluster().getRaft().setEnablePriorityElection(true);
        brokerCfg.getCluster().setClusterSize(2);
        config.setScheme(Scheme.FIXED);
        config.setFixed(List.of(fixedPartition));
        fixedPartition.setNodes(nodes);
        nodes.get(0).setNodeId(0);
        nodes.get(0).setPriority(1);
        nodes.get(1).setNodeId(1);
        nodes.get(1).setPriority(1);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("Expected each node for a partition 1 to have a different priority, but at least two of them have the same priorities: [NodeCfg{nodeId=0, priority=1}, NodeCfg{nodeId=1, priority=1}]");
    }

    @Test
    void shouldNotThrowExceptionIfFixedPartitioningSchemeHasWrongPrioritiesWhenPriorityDisabled() {
        BrokerCfg brokerCfg = new BrokerCfg();
        PartitioningCfg config = brokerCfg.getExperimental().getPartitioning();
        FixedPartitionCfg fixedPartition = new FixedPartitionCfg();
        List<FixedPartitionCfg.NodeCfg> nodes = List.of(new FixedPartitionCfg.NodeCfg(), new FixedPartitionCfg.NodeCfg());
        brokerCfg.getCluster().getRaft().setEnablePriorityElection(false);
        brokerCfg.getCluster().setClusterSize(2);
        config.setScheme(Scheme.FIXED);
        config.setFixed(List.of(fixedPartition));
        fixedPartition.setNodes(nodes);
        nodes.get(0).setNodeId(0);
        nodes.get(0).setPriority(1);
        nodes.get(1).setNodeId(1);
        nodes.get(1).setPriority(1);
        Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).doesNotThrowAnyException();
    }

    @Test
    void shouldThrowExceptionWithNetworkSecurityEnabledAndWrongCert() throws CertificateException {
        SelfSignedCertificate certificate = new SelfSignedCertificate();
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getNetwork().getSecurity().setEnabled(true).setPrivateKeyPath(certificate.privateKey()).setCertificateChainPath(new File("/tmp/i-dont-exist.crt"));
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected the configured network security certificate chain path '/tmp/i-dont-exist.crt' to point to a readable file, but it does not");
    }

    @Test
    void shouldThrowExceptionWithNetworkSecurityEnabledAndWrongKey() throws CertificateException {
        SelfSignedCertificate certificate = new SelfSignedCertificate();
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getNetwork().getSecurity().setEnabled(true).setPrivateKeyPath(new File("/tmp/i-dont-exist.key")).setCertificateChainPath(certificate.certificate());
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected the configured network security private key path '/tmp/i-dont-exist.key' to point to a readable file, but it does not");
    }

    @Test
    void shouldThrowExceptionWithNetworkSecurityEnabledAndNoPrivateKey() throws CertificateException {
        SelfSignedCertificate certificate = new SelfSignedCertificate();
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getNetwork().getSecurity().setEnabled(true).setPrivateKeyPath(null).setCertificateChainPath(certificate.certificate());
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected to have a valid private key path for network security, but none configured");
    }

    @Test
    void shouldThrowExceptionWithNetworkSecurityEnabledAndNoCert() throws CertificateException {
        SelfSignedCertificate certificate = new SelfSignedCertificate();
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getNetwork().getSecurity().setEnabled(true).setPrivateKeyPath(certificate.privateKey()).setCertificateChainPath(null);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Expected to have a valid certificate chain path for network security, but none configured");
    }

    @Test
    void shouldThrowExceptionWhenS3BucketIsNotProvided() {
        BrokerCfg brokerCfg = new BrokerCfg();
        brokerCfg.getData().getBackup().setStore(BackupStoreCfg.BackupStoreType.S3);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(InvalidConfigurationException.class)).hasCauseInstanceOf(IllegalArgumentException.class).cause().hasMessageContaining("Bucket name must not be empty");
    }

    @Test
    void shouldThrowExceptionWhenS3IsNotConfigured() {
        BrokerCfg brokerCfg = new BrokerCfg();
        BackupStoreCfg backupCfg = brokerCfg.getData().getBackup();
        backupCfg.setStore(BackupStoreCfg.BackupStoreType.S3);
        backupCfg.getS3().setBucketName("bucket");
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.initSystemContext(brokerCfg)).isInstanceOf(InvalidConfigurationException.class)).hasMessageContaining("Failed configuring backup store S3");
    }

    private SystemContext initSystemContext(BrokerCfg brokerCfg) {
        return new SystemContext(brokerCfg, (ActorScheduler)Mockito.mock(ActorScheduler.class), (AtomixCluster)Mockito.mock(AtomixCluster.class), (BrokerClient)Mockito.mock(BrokerClient.class));
    }
}

