/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system;

import io.camunda.zeebe.broker.test.EmbeddedBrokerConfigurator;
import io.camunda.zeebe.broker.test.EmbeddedBrokerRule;
import io.camunda.zeebe.model.bpmn.Bpmn;
import io.camunda.zeebe.protocol.Protocol;
import io.camunda.zeebe.protocol.impl.record.value.processinstance.ProcessInstanceCreationRecord;
import io.camunda.zeebe.test.broker.protocol.commandapi.CommandApiRule;
import io.camunda.zeebe.test.util.TestUtil;
import io.camunda.zeebe.test.util.record.DeploymentRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.RuleChain;
import org.junit.rules.TestRule;

public final class UniqueKeyFormatTest {
    public final EmbeddedBrokerRule brokerRule = new EmbeddedBrokerRule(EmbeddedBrokerConfigurator.setPartitionCount(3));
    public final CommandApiRule apiRule = new CommandApiRule(this.brokerRule::getAtomixCluster);
    @Rule
    public RuleChain ruleChain = RuleChain.outerRule((TestRule)this.brokerRule).around((TestRule)this.apiRule);

    @Test
    public void shouldStartProcessInstanceAtNoneStartEvent() {
        this.apiRule.partitionClient().deploy(Bpmn.createExecutableProcess((String)"process").startEvent("foo").endEvent().done());
        TestUtil.waitUntil(() -> ((DeploymentRecordStream)RecordingExporter.deploymentRecords().withPartitionId(2)).exists());
        ProcessInstanceCreationRecord processInstanceWithResponse = this.apiRule.partitionClient(2).createProcessInstance(r -> r.setBpmnProcessId("process"));
        long key = processInstanceWithResponse.getProcessInstanceKey();
        int partitionId = Protocol.decodePartitionId((long)key);
        Assertions.assertThat((int)partitionId).isEqualTo(2);
    }
}

