/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.TestConfigReader;
import io.camunda.zeebe.broker.system.configuration.backpressure.AIMDCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.BackpressureCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.FixedCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.Gradient2Cfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.GradientCfg;
import io.camunda.zeebe.broker.system.configuration.backpressure.VegasCfg;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public final class BackpressureCfgTest {
    public final Map<String, String> environment = new HashMap<String, String>();

    @Test
    public void shouldSetBackpressureConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("backpressure-cfg", this.environment);
        BackpressureCfg backpressure = cfg.getBackpressure();
        Assertions.assertThat((boolean)backpressure.isEnabled()).isTrue();
        Assertions.assertThat((boolean)backpressure.useWindowed()).isFalse();
        Assertions.assertThat((Comparable)backpressure.getAlgorithm()).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.GRADIENT);
    }

    @Test
    public void shouldSetAimdConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("backpressure-cfg", this.environment);
        BackpressureCfg backpressure = cfg.getBackpressure();
        AIMDCfg aimd = backpressure.getAimd();
        Assertions.assertThat((double)aimd.getBackoffRatio()).isEqualTo(0.75);
        Assertions.assertThat((Duration)aimd.getRequestTimeout()).isEqualTo((Object)Duration.ofSeconds(5L));
        Assertions.assertThat((int)aimd.getInitialLimit()).isEqualTo(15);
        Assertions.assertThat((int)aimd.getMinLimit()).isEqualTo(5);
        Assertions.assertThat((int)aimd.getMaxLimit()).isEqualTo(150);
    }

    @Test
    public void shouldSetFixedCfg() {
        BrokerCfg cfg = TestConfigReader.readConfig("backpressure-fixed-cfg", this.environment);
        BackpressureCfg.LimitAlgorithm algorithm = cfg.getBackpressure().getAlgorithm();
        FixedCfg fixedCfg = cfg.getBackpressure().getFixed();
        Assertions.assertThat((Comparable)algorithm).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.FIXED);
        Assertions.assertThat((int)fixedCfg.getLimit()).isEqualTo(13);
    }

    @Test
    public void shouldSetVegasCfg() {
        BrokerCfg cfg = TestConfigReader.readConfig("backpressure-cfg", this.environment);
        VegasCfg vegasCfg = cfg.getBackpressure().getVegas();
        Assertions.assertThat((int)vegasCfg.getAlpha()).isEqualTo(4);
        Assertions.assertThat((int)vegasCfg.getBeta()).isEqualTo(8);
        Assertions.assertThat((int)vegasCfg.getInitialLimit()).isEqualTo(14);
    }

    @Test
    public void shouldSetGradientCfg() {
        BrokerCfg cfg = TestConfigReader.readConfig("backpressure-cfg", this.environment);
        GradientCfg gradientCfg = cfg.getBackpressure().getGradient();
        Assertions.assertThat((int)gradientCfg.getMinLimit()).isEqualTo(7);
        Assertions.assertThat((int)gradientCfg.getInitialLimit()).isEqualTo(17);
        Assertions.assertThat((double)gradientCfg.getRttTolerance()).isEqualTo(1.7);
    }

    @Test
    public void shouldSetGradient2Cfg() {
        BrokerCfg cfg = TestConfigReader.readConfig("backpressure-cfg", this.environment);
        Gradient2Cfg gradient2Cfg = cfg.getBackpressure().getGradient2();
        Assertions.assertThat((int)gradient2Cfg.getMinLimit()).isEqualTo(3);
        Assertions.assertThat((int)gradient2Cfg.getInitialLimit()).isEqualTo(13);
        Assertions.assertThat((double)gradient2Cfg.getRttTolerance()).isEqualTo(1.3);
        Assertions.assertThat((int)gradient2Cfg.getLongWindow()).isEqualTo(300);
    }

    @Test
    public void shouldUseConfiguredBackpressureAlgorithms() {
        BackpressureCfg backpressure = new BackpressureCfg();
        backpressure.setAlgorithm("gradient");
        Assertions.assertThat((Comparable)backpressure.getAlgorithm()).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.GRADIENT);
        backpressure.setAlgorithm("gradient2");
        Assertions.assertThat((Comparable)backpressure.getAlgorithm()).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.GRADIENT2);
        backpressure.setAlgorithm("vegas");
        Assertions.assertThat((Comparable)backpressure.getAlgorithm()).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.VEGAS);
        backpressure.setAlgorithm("fixed");
        Assertions.assertThat((Comparable)backpressure.getAlgorithm()).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.FIXED);
        backpressure.setAlgorithm("aimd");
        Assertions.assertThat((Comparable)backpressure.getAlgorithm()).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.AIMD);
    }
}

