/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.TestConfigReader;
import io.camunda.zeebe.broker.system.configuration.backup.BackupStoreCfg;
import io.camunda.zeebe.broker.system.configuration.backup.GcsBackupStoreConfig;
import io.camunda.zeebe.broker.system.configuration.backup.S3BackupStoreConfig;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class BackupStoreCfgTest {
    BackupStoreCfgTest() {
    }

    @Test
    void canConfigureBackupStore() {
        Map<String, String> env = Map.of("zeebe.broker.data.backup.store", "gcs");
        BrokerCfg cfg = TestConfigReader.readConfig("empty", env);
        Assertions.assertThat((Comparable)cfg.getData().getBackup().getStore()).isEqualTo((Object)BackupStoreCfg.BackupStoreType.GCS);
    }

    @Test
    void shouldUseDefaultGcsAuth() {
        Map<String, String> env = Map.of();
        BrokerCfg cfg = TestConfigReader.readConfig("empty", env);
        Assertions.assertThat((Comparable)cfg.getData().getBackup().getGcs().getAuth()).isEqualTo((Object)GcsBackupStoreConfig.GcsBackupStoreAuth.AUTO);
    }

    @Test
    void canConfigureGcsAuth() {
        Map<String, String> env = Map.of("zeebe.broker.data.backup.store", "gcs", "zeebe.broker.data.backup.gcs.auth", "none");
        BrokerCfg cfg = TestConfigReader.readConfig("empty", env);
        Assertions.assertThat((Comparable)cfg.getData().getBackup().getGcs().getAuth()).isEqualTo((Object)GcsBackupStoreConfig.GcsBackupStoreAuth.NONE);
    }

    @Test
    void canConfigureGcsHost() {
        String configuredHost = "localhost";
        Map<String, String> env = Map.of("zeebe.broker.data.backup.store", "gcs", "zeebe.broker.data.backup.gcs.host", "localhost");
        BrokerCfg cfg = TestConfigReader.readConfig("empty", env);
        Assertions.assertThat((String)cfg.getData().getBackup().getGcs().getHost()).isEqualTo("localhost");
    }

    @Test
    void shouldSetPartialS3Config() {
        S3BackupStoreConfig expectedConfig = new S3BackupStoreConfig();
        expectedConfig.setBucketName("bucket");
        expectedConfig.setEndpoint("endpoint");
        expectedConfig.setRegion("region-1");
        expectedConfig.setAccessKey(null);
        expectedConfig.setSecretKey(null);
        BrokerCfg cfg = TestConfigReader.readConfig("backup-cfg", new HashMap<String, String>());
        BackupStoreCfg backup = cfg.getData().getBackup();
        Assertions.assertThat((Comparable)backup.getStore()).isEqualTo((Object)BackupStoreCfg.BackupStoreType.S3);
        Assertions.assertThat((Object)backup.getS3()).isEqualTo((Object)expectedConfig);
    }
}

