/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.exporter.debug.DebugLogExporter;
import io.camunda.zeebe.broker.exporter.metrics.MetricsExporter;
import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.EmbeddedGatewayCfg;
import io.camunda.zeebe.broker.system.configuration.ExperimentalCfg;
import io.camunda.zeebe.broker.system.configuration.ExporterCfg;
import io.camunda.zeebe.broker.system.configuration.MembershipCfg;
import io.camunda.zeebe.broker.system.configuration.NetworkCfg;
import io.camunda.zeebe.broker.system.configuration.TestConfigReader;
import io.camunda.zeebe.broker.system.configuration.backpressure.BackpressureCfg;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.springframework.boot.context.properties.bind.BindException;

public final class BrokerCfgTest {
    public static final String BROKER_BASE = "test";
    private static final String ZEEBE_BROKER_EXPERIMENTAL_MAX_APPENDS_PER_FOLLOWER = "zeebe.broker.experimental.maxAppendsPerFollower";
    private static final String ZEEBE_BROKER_EXPERIMENTAL_MAX_APPEND_BATCH_SIZE = "zeebe.broker.experimental.maxAppendBatchSize";
    private static final String ZEEBE_BROKER_EXPERIMENTAL_DISABLEEXPLICITRAFTFLUSH = "zeebe.broker.experimental.disableExplicitRaftFlush";
    private static final String ZEEBE_BROKER_CLUSTER_RAFT_ENABLEPRIORITYELECTION = "zeebe.broker.cluster.raft.enablePriorityElection";
    private static final String ZEEBE_BROKER_EXPERIMENTAL_QUERYAPI_ENABLED = "zeebe.broker.experimental.queryapi.enabled";
    private static final String ZEEBE_BROKER_DATA_DIRECTORY = "zeebe.broker.data.directory";
    private static final String ZEEBE_BROKER_NETWORK_HOST = "zeebe.broker.network.host";
    private static final String ZEEBE_BROKER_NETWORK_ADVERTISED_HOST = "zeebe.broker.network.advertisedHost";
    private static final String ZEEBE_BROKER_NETWORK_PORT_OFFSET = "zeebe.broker.network.portOffset";
    private static final String ZEEBE_BROKER_EXECUTION_METRICS_EXPORTER_ENABLED = "zeebe.broker.executionMetricsExporterEnabled";
    @Rule
    public final TemporaryFolder temporaryFolder = new TemporaryFolder();
    public final Map<String, String> environment = new HashMap<String, String>();

    @Test
    public void shouldUseDefaultPorts() {
        this.assertDefaultPorts(26501, 26502);
    }

    @Test
    public void shouldUseSpecifiedPorts() {
        this.assertPorts("specific-ports", 1, 5);
    }

    @Test
    public void shouldUsePortOffset() {
        int offset = 50;
        this.assertPorts("port-offset", 26551, 26552);
    }

    @Test
    public void shouldUsePortOffsetWithSpecifiedPorts() {
        int offset = 30;
        this.assertPorts("specific-ports-offset", 31, 35);
    }

    @Test
    public void shouldUsePortOffsetFromEnvironment() {
        this.environment.put(ZEEBE_BROKER_NETWORK_PORT_OFFSET, "5");
        int offset = 50;
        this.assertDefaultPorts(26551, 26552);
    }

    @Test
    public void shouldUsePortOffsetFromEnvironmentWithSpecifiedPorts() {
        this.environment.put(ZEEBE_BROKER_NETWORK_PORT_OFFSET, "3");
        int offset = 30;
        this.assertPorts("specific-ports", 31, 35);
    }

    @Test
    public void shouldRejectInvalidPortOffsetFromEnvironment() {
        this.environment.put(ZEEBE_BROKER_NETWORK_PORT_OFFSET, "a");
        Assertions.assertThatThrownBy(() -> this.assertDefaultPorts(26501, 26502)).isInstanceOf(BindException.class);
    }

    @Test
    public void shouldOverridePortOffsetFromEnvironment() {
        this.environment.put(ZEEBE_BROKER_NETWORK_PORT_OFFSET, "7");
        int offset = 70;
        this.assertPorts("port-offset", 26571, 26572);
    }

    @Test
    public void shouldExpandExporterJarPathRelativeToBrokerBaseIffPresent() {
        ExporterCfg exporterCfgExternal = new ExporterCfg();
        exporterCfgExternal.setJarPath("exporters/exporter.jar");
        ExporterCfg exporterCfgInternal1 = new ExporterCfg();
        exporterCfgInternal1.setJarPath("");
        ExporterCfg exporterCfgInternal2 = new ExporterCfg();
        BrokerCfg config = new BrokerCfg();
        config.getExporters().put("external", exporterCfgExternal);
        config.getExporters().put("internal-1", exporterCfgInternal1);
        config.getExporters().put("internal-2", exporterCfgInternal2);
        String base = this.temporaryFolder.getRoot().getAbsolutePath();
        String jarFile = Paths.get(base, "exporters", "exporter.jar").toAbsolutePath().toString();
        config.init(base);
        Assertions.assertThat((Map)config.getExporters()).hasSize(3);
        ((ObjectAssert)Assertions.assertThat((Object)((ExporterCfg)config.getExporters().get("external"))).hasFieldOrPropertyWithValue("jarPath", (Object)jarFile)).is(new Condition(ExporterCfg::isExternal, "is external", new Object[0]));
        Assertions.assertThat((boolean)((ExporterCfg)config.getExporters().get("internal-1")).isExternal()).isFalse();
        Assertions.assertThat((boolean)((ExporterCfg)config.getExporters().get("internal-2")).isExternal()).isFalse();
    }

    @Test
    public void shouldEnableDebugLogExporter() {
        String expectedId = DebugLogExporter.defaultExporterId();
        ExporterCfg expectedConfig = DebugLogExporter.defaultConfig();
        this.environment.put("ZEEBE_DEBUG", "true");
        this.assertWithDefaultConfigurations(cfg -> Assertions.assertThat((Map)cfg.getExporters()).containsEntry((Object)expectedId, (Object)expectedConfig));
    }

    @Test
    public void shouldNotRegisterDebugLogExporter() {
        this.environment.put("ZEEBE_DEBUG", "false");
        String exporterId = DebugLogExporter.defaultExporterId();
        BrokerCfg brokerCfg = TestConfigReader.readConfig("empty", this.environment);
        Assertions.assertThat((Map)brokerCfg.getExporters()).doesNotContainKey((Object)exporterId);
    }

    @Test
    public void shouldHaveNoExportersByDefault() {
        this.assertWithDefaultConfigurations(cfg -> Assertions.assertThat((Map)cfg.getExporters()).isEmpty());
    }

    @Test
    public void shouldEnableMetricsExporter() {
        this.environment.put(ZEEBE_BROKER_EXECUTION_METRICS_EXPORTER_ENABLED, "true");
        this.assertMetricsExporter();
    }

    @Test
    public void shouldUseDefaultHost() {
        this.assertDefaultHost("0.0.0.0");
    }

    @Test
    public void shouldUseSpecifiedHosts() {
        this.assertHost("specific-hosts", "0.0.0.0", "gatewayHost", "commandHost", "internalHost", "monitoringHost");
    }

    @Test
    public void shouldUseGlobalHost() {
        this.assertHost("host", "1.1.1.1");
    }

    @Test
    public void shouldUseHostFromEnvironment() {
        this.environment.put(ZEEBE_BROKER_NETWORK_HOST, "2.2.2.2");
        this.assertDefaultHost("2.2.2.2");
    }

    @Test
    public void shouldUseHostFromEnvironmentWithGlobalHost() {
        this.environment.put(ZEEBE_BROKER_NETWORK_HOST, "myHost");
        this.assertHost("host", "myHost");
    }

    @Test
    public void shouldNotOverrideSpecifiedHostsFromEnvironment() {
        this.environment.put(ZEEBE_BROKER_NETWORK_HOST, "myHost");
        this.assertHost("specific-hosts", "myHost", "gatewayHost", "commandHost", "internalHost", "monitoringHost");
    }

    @Test
    public void shouldUseDefaultDirectory() {
        String expectedDataDirectory = Paths.get(BROKER_BASE, "data").toString();
        this.assertWithDefaultConfigurations(config -> Assertions.assertThat((String)config.getData().getDirectory()).isEqualTo(expectedDataDirectory));
    }

    @Test
    public void shouldUseSpecifiedDirectory() {
        BrokerCfg config = TestConfigReader.readConfig("directory", this.environment);
        String expectedDataDirectory = Paths.get(BROKER_BASE, "foo").toString();
        Assertions.assertThat((String)config.getData().getDirectory()).isEqualTo(expectedDataDirectory);
    }

    @Test
    public void shouldUseDirectoryFromEnvironment() {
        String expectedDataDirectory = Paths.get(BROKER_BASE, "foo").toString();
        this.environment.put(ZEEBE_BROKER_DATA_DIRECTORY, "foo");
        this.assertWithDefaultConfigurations(config -> Assertions.assertThat((String)config.getData().getDirectory()).isEqualTo(expectedDataDirectory));
    }

    @Test
    public void shouldReadSpecificSystemClusterConfiguration() {
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", this.environment);
        ClusterCfg cfgCluster = cfg.getCluster();
        Assertions.assertThat((List)cfgCluster.getInitialContactPoints()).isEmpty();
        Assertions.assertThat((int)cfgCluster.getNodeId()).isEqualTo(2);
        Assertions.assertThat((int)cfgCluster.getPartitionsCount()).isEqualTo(3);
        Assertions.assertThat((int)cfgCluster.getReplicationFactor()).isEqualTo(4);
        Assertions.assertThat((int)cfgCluster.getClusterSize()).isEqualTo(5);
    }

    @Test
    public void shouldCreatePartitionIds() {
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", this.environment);
        ClusterCfg cfgCluster = cfg.getCluster();
        Assertions.assertThat((int)cfgCluster.getPartitionsCount()).isEqualTo(3);
        List partitionIds = cfgCluster.getPartitionIds();
        boolean startId = true;
        Assertions.assertThat((List)partitionIds).contains((Object[])new Integer[]{1, 2, 3});
    }

    @Test
    public void shouldOverrideMaxAppendsViaEnvironment() {
        this.environment.put(ZEEBE_BROKER_EXPERIMENTAL_MAX_APPENDS_PER_FOLLOWER, "8");
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", this.environment);
        ExperimentalCfg experimentalCfg = cfg.getExperimental();
        Assertions.assertThat((int)experimentalCfg.getMaxAppendsPerFollower()).isEqualTo(8);
    }

    @Test
    public void shouldOverrideMaxAppendBatchSizeViaEnvironment() {
        this.environment.put(ZEEBE_BROKER_EXPERIMENTAL_MAX_APPEND_BATCH_SIZE, "256KB");
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", this.environment);
        ExperimentalCfg experimentalCfg = cfg.getExperimental();
        Assertions.assertThat((long)experimentalCfg.getMaxAppendBatchSizeInBytes()).isEqualTo(262144L);
    }

    @Test
    public void shouldOverrideDisableExplicitRaftFlushViaEnvironment() {
        this.environment.put(ZEEBE_BROKER_EXPERIMENTAL_DISABLEEXPLICITRAFTFLUSH, "true");
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", this.environment);
        ExperimentalCfg experimentalCfg = cfg.getExperimental();
        Assertions.assertThat((boolean)experimentalCfg.isDisableExplicitRaftFlush()).isTrue();
    }

    @Test
    public void shouldOverrideEnablePriorityElectionViaEnvironment() {
        this.environment.put(ZEEBE_BROKER_CLUSTER_RAFT_ENABLEPRIORITYELECTION, "true");
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", this.environment);
        ClusterCfg clusterCfg = cfg.getCluster();
        Assertions.assertThat((boolean)clusterCfg.getRaft().isEnablePriorityElection()).isTrue();
    }

    @Test
    public void shouldEnablePriorityElectionByDefault() {
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", this.environment);
        ClusterCfg clusterCfg = cfg.getCluster();
        Assertions.assertThat((boolean)clusterCfg.getRaft().isEnablePriorityElection()).isTrue();
    }

    @Test
    public void shouldSetEnablePriorityElectionFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ClusterCfg clusterCfg = cfg.getCluster();
        Assertions.assertThat((boolean)clusterCfg.getRaft().isEnablePriorityElection()).isTrue();
    }

    @Test
    public void shouldDisableQueryApiByDefault() {
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", this.environment);
        ExperimentalCfg experimentalCfg = cfg.getExperimental();
        Assertions.assertThat((boolean)experimentalCfg.getQueryApi().isEnabled()).isFalse();
    }

    @Test
    public void shouldSetEnableQueryApiFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ExperimentalCfg experimentalCfg = cfg.getExperimental();
        Assertions.assertThat((boolean)experimentalCfg.getQueryApi().isEnabled()).isTrue();
    }

    @Test
    public void shouldOverrideSetEnableQueryApiViaEnvironment() {
        this.environment.put(ZEEBE_BROKER_EXPERIMENTAL_QUERYAPI_ENABLED, "true");
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", this.environment);
        ExperimentalCfg experimentalCfg = cfg.getExperimental();
        Assertions.assertThat((boolean)experimentalCfg.getQueryApi().isEnabled()).isTrue();
    }

    @Test
    public void shouldReadDefaultEmbedGateway() {
        this.assertDefaultEmbeddedGatewayEnabled(true);
    }

    @Test
    public void shouldReadEmbedGateway() {
        this.assertEmbeddedGatewayEnabled("disabled-gateway", false);
    }

    @Test
    public void shouldSetEmbedGatewayViaEnvironment() {
        this.environment.put("zeebe.broker.gateway.enable", "true");
        this.assertEmbeddedGatewayEnabled("disabled-gateway", true);
    }

    @Test
    public void shouldSetBackpressureConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("backpressure-cfg", this.environment);
        BackpressureCfg backpressure = cfg.getBackpressure();
        Assertions.assertThat((boolean)backpressure.isEnabled()).isTrue();
        Assertions.assertThat((boolean)backpressure.useWindowed()).isFalse();
        Assertions.assertThat((Comparable)backpressure.getAlgorithm()).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.GRADIENT);
    }

    @Test
    public void shouldUseConfiguredBackpressureAlgorithms() {
        BackpressureCfg backpressure = new BackpressureCfg();
        backpressure.setAlgorithm("gradient");
        Assertions.assertThat((Comparable)backpressure.getAlgorithm()).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.GRADIENT);
        backpressure.setAlgorithm("gradient");
        Assertions.assertThat((Comparable)backpressure.getAlgorithm()).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.GRADIENT);
        backpressure.setAlgorithm("gradient2");
        Assertions.assertThat((Comparable)backpressure.getAlgorithm()).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.GRADIENT2);
        backpressure.setAlgorithm("vegas");
        Assertions.assertThat((Comparable)backpressure.getAlgorithm()).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.VEGAS);
        backpressure.setAlgorithm("fixed");
        Assertions.assertThat((Comparable)backpressure.getAlgorithm()).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.FIXED);
        backpressure.setAlgorithm("aimd");
        Assertions.assertThat((Comparable)backpressure.getAlgorithm()).isEqualTo((Object)BackpressureCfg.LimitAlgorithm.AIMD);
    }

    @Test
    public void shouldUseDefaultAdvertisedHost() {
        this.assertAdvertisedAddress("default-advertised-host-cfg", "zeebe.io", 26501);
        this.assertHost("default-advertised-host-cfg", "0.0.0.0");
    }

    @Test
    public void shouldUseAdvertisedHost() {
        this.assertAdvertisedAddress("advertised-host-cfg", "zeebe.io", 26501);
        this.assertHost("advertised-host-cfg", "0.0.0.0");
    }

    @Test
    public void shouldUseAdvertisedAddress() {
        this.assertAdvertisedAddress("advertised-address-cfg", "zeebe.io", 8080);
    }

    @Test
    public void shouldUseDefaultAdvertisedHostFromEnv() {
        this.environment.put(ZEEBE_BROKER_NETWORK_ADVERTISED_HOST, "zeebe.io");
        this.assertAdvertisedAddress("default", "zeebe.io", 26501);
        this.assertAdvertisedAddress("empty", "zeebe.io", 26501);
    }

    @Test
    public void shouldReadExporterConfigWithMinimalInfo() {
        ExporterCfg expected = new ExporterCfg();
        expected.setClassName("io.camunda.zeebe.exporter.ElasticsearchExporter");
        BrokerCfg actual = TestConfigReader.readConfig("exporters", this.environment);
        ((MapAssert)((MapAssert)Assertions.assertThat((Map)actual.getExporters()).hasSize(1)).containsKey((Object)"elasticsearch")).containsEntry((Object)"elasticsearch", (Object)expected);
    }

    @Test
    public void shouldSetCustomMembershipConfig() {
        BrokerCfg brokerCfg = TestConfigReader.readConfig("membership-cfg", this.environment);
        MembershipCfg membershipCfg = brokerCfg.getCluster().getMembership();
        Assertions.assertThat((boolean)membershipCfg.isBroadcastDisputes()).isFalse();
        Assertions.assertThat((boolean)membershipCfg.isBroadcastUpdates()).isTrue();
        Assertions.assertThat((boolean)membershipCfg.isNotifySuspect()).isTrue();
        Assertions.assertThat((Duration)membershipCfg.getGossipInterval()).isEqualTo((Object)Duration.ofSeconds(2L));
        Assertions.assertThat((int)membershipCfg.getGossipFanout()).isEqualTo(3);
        Assertions.assertThat((Duration)membershipCfg.getProbeInterval()).isEqualTo((Object)Duration.ofSeconds(3L));
        Assertions.assertThat((Duration)membershipCfg.getProbeTimeout()).isEqualTo((Object)Duration.ofSeconds(5L));
        Assertions.assertThat((int)membershipCfg.getSuspectProbes()).isEqualTo(5);
        Assertions.assertThat((Duration)membershipCfg.getFailureTimeout()).isEqualTo((Object)Duration.ofSeconds(20L));
        Assertions.assertThat((Duration)membershipCfg.getSyncInterval()).isEqualTo((Object)Duration.ofSeconds(25L));
    }

    private void assertDefaultPorts(int command, int internal) {
        this.assertPorts("default", command, internal);
        this.assertPorts("empty", command, internal);
    }

    private void assertPorts(String configFileName, int command, int internal) {
        BrokerCfg brokerCfg = TestConfigReader.readConfig(configFileName, this.environment);
        NetworkCfg network = brokerCfg.getNetwork();
        Assertions.assertThat((int)network.getCommandApi().getAddress().getPort()).isEqualTo(command);
        Assertions.assertThat((int)network.getCommandApi().getAdvertisedAddress().getPort()).isEqualTo(command);
        Assertions.assertThat((int)network.getInternalApi().getPort()).isEqualTo(internal);
    }

    private void assertDefaultHost(String host) {
        this.assertHost("default", host);
        this.assertHost("empty", host);
    }

    private void assertHost(String configFileName, String host) {
        this.assertHost(configFileName, host, host, host, host, host);
    }

    private void assertHost(String configFileName, String host, String gateway, String command, String internal, String monitoring) {
        BrokerCfg brokerCfg = TestConfigReader.readConfig(configFileName, this.environment);
        NetworkCfg networkCfg = brokerCfg.getNetwork();
        Assertions.assertThat((String)networkCfg.getHost()).isEqualTo(host);
        Assertions.assertThat((String)brokerCfg.getGateway().getNetwork().getHost()).isEqualTo(gateway);
        Assertions.assertThat((String)networkCfg.getCommandApi().getAddress().getHostString()).isEqualTo(command);
        Assertions.assertThat((String)networkCfg.getInternalApi().getHost()).isEqualTo(internal);
    }

    private void assertAdvertisedHost(String configFileName, String host) {
        BrokerCfg brokerCfg = TestConfigReader.readConfig(configFileName, this.environment);
        NetworkCfg networkCfg = brokerCfg.getNetwork();
        Assertions.assertThat((String)networkCfg.getCommandApi().getAdvertisedAddress().getHostName()).isEqualTo(host);
    }

    private void assertAdvertisedAddress(String configFileName, String host, int port) {
        BrokerCfg brokerCfg = TestConfigReader.readConfig(configFileName, this.environment);
        NetworkCfg networkCfg = brokerCfg.getNetwork();
        Assertions.assertThat((String)networkCfg.getCommandApi().getAdvertisedAddress().getHostName()).isEqualTo(host);
        Assertions.assertThat((int)networkCfg.getCommandApi().getAdvertisedAddress().getPort()).isEqualTo(port);
    }

    private void assertDefaultEmbeddedGatewayEnabled(boolean enabled) {
        this.assertEmbeddedGatewayEnabled("default", enabled);
        this.assertEmbeddedGatewayEnabled("empty", enabled);
    }

    private void assertEmbeddedGatewayEnabled(String configFileName, boolean enabled) {
        EmbeddedGatewayCfg gatewayCfg = TestConfigReader.readConfig(configFileName, this.environment).getGateway();
        Assertions.assertThat((boolean)gatewayCfg.isEnable()).isEqualTo(enabled);
    }

    private void assertMetricsExporter() {
        this.assertMetricsExporter("default");
        this.assertMetricsExporter("empty");
    }

    private void assertMetricsExporter(String configFileName) {
        ExporterCfg exporterCfg = MetricsExporter.defaultConfig();
        BrokerCfg brokerCfg = TestConfigReader.readConfig(configFileName, this.environment);
        ((AbstractCollectionAssert)Assertions.assertThat(brokerCfg.getExporters().values()).usingRecursiveFieldByFieldElementComparator()).contains((Object[])new ExporterCfg[]{exporterCfg});
    }

    private void assertWithDefaultConfigurations(Consumer<BrokerCfg> assertions) {
        Stream.of("default", "empty").forEach(configFileName -> this.assertWithConfiguration(assertions, (String)configFileName));
    }

    private void assertWithConfiguration(Consumer<BrokerCfg> assertions, String configFileName) {
        BrokerCfg cfg = TestConfigReader.readConfig(configFileName, this.environment);
        assertions.accept(cfg);
    }
}

