/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ClusterCfg;
import io.camunda.zeebe.broker.system.configuration.TestConfigReader;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public final class ClusterCfgTest {
    private static final String ZEEBE_BROKER_CLUSTER_NODE_ID = "zeebe.broker.cluster.nodeId";
    private static final String ZEEBE_BROKER_CLUSTER_INITIAL_CONTACT_POINTS = "zeebe.broker.cluster.initialContactPoints";
    private static final String ZEEBE_BROKER_CLUSTER_PARTITIONS_COUNT = "zeebe.broker.cluster.partitionsCount";
    private static final String ZEEBE_BROKER_CLUSTER_REPLICATION_FACTOR = "zeebe.broker.cluster.replicationFactor";
    private static final String ZEEBE_BROKER_CLUSTER_CLUSTER_SIZE = "zeebe.broker.cluster.clusterSize";
    private static final String ZEEBE_BROKER_CLUSTER_CLUSTER_NAME = "zeebe.broker.cluster.clusterName";

    @Test
    public void shouldUseDefaults() {
        ClusterCfg emptyCfg = TestConfigReader.readConfig("empty", Map.of()).getCluster();
        ClusterCfg defaultCfg = TestConfigReader.readConfig("default", Map.of()).getCluster();
        Assertions.assertThat((int)emptyCfg.getNodeId()).isEqualTo(0);
        Assertions.assertThat((int)emptyCfg.getPartitionsCount()).isEqualTo(1);
        Assertions.assertThat((int)emptyCfg.getReplicationFactor()).isEqualTo(1);
        Assertions.assertThat((int)emptyCfg.getClusterSize()).isEqualTo(1);
        Assertions.assertThat((List)emptyCfg.getInitialContactPoints()).isEqualTo(List.of());
        Assertions.assertThat((int)defaultCfg.getNodeId()).isEqualTo(0);
        Assertions.assertThat((int)defaultCfg.getPartitionsCount()).isEqualTo(1);
        Assertions.assertThat((int)defaultCfg.getReplicationFactor()).isEqualTo(1);
        Assertions.assertThat((int)defaultCfg.getClusterSize()).isEqualTo(1);
        Assertions.assertThat((List)defaultCfg.getInitialContactPoints()).isEqualTo(List.of());
    }

    @Test
    public void shouldOverrideAllClusterPropertiesViaEnvironment() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put(ZEEBE_BROKER_CLUSTER_CLUSTER_SIZE, "3");
        environment.put(ZEEBE_BROKER_CLUSTER_PARTITIONS_COUNT, "2");
        environment.put(ZEEBE_BROKER_CLUSTER_REPLICATION_FACTOR, "3");
        environment.put(ZEEBE_BROKER_CLUSTER_NODE_ID, "2");
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", environment);
        ClusterCfg cfgCluster = cfg.getCluster();
        Assertions.assertThat((int)cfgCluster.getClusterSize()).isEqualTo(3);
        Assertions.assertThat((int)cfgCluster.getPartitionsCount()).isEqualTo(2);
        Assertions.assertThat((int)cfgCluster.getReplicationFactor()).isEqualTo(3);
        Assertions.assertThat((int)cfgCluster.getNodeId()).isEqualTo(2);
    }

    @Test
    public void shouldUseClusterNameFromEnvironment() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put(ZEEBE_BROKER_CLUSTER_CLUSTER_NAME, "test-cluster");
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", environment);
        ClusterCfg cfgCluster = cfg.getCluster();
        Assertions.assertThat((String)cfgCluster.getClusterName()).isEqualTo("test-cluster");
    }

    @Test
    public void shouldUseSpecifiedClusterName() {
        BrokerCfg cfg = TestConfigReader.readConfig("specific-cluster-name", Collections.emptyMap());
        ClusterCfg cfgCluster = cfg.getCluster();
        Assertions.assertThat((String)cfgCluster.getClusterName()).isEqualTo("cluster-name");
    }

    @Test
    public void shouldUseNodeIdFromEnvironment() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put(ZEEBE_BROKER_CLUSTER_NODE_ID, "2");
        environment.put(ZEEBE_BROKER_CLUSTER_CLUSTER_SIZE, "6");
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", environment);
        ClusterCfg cfgCluster = cfg.getCluster();
        Assertions.assertThat((int)cfgCluster.getNodeId()).isEqualTo(2);
    }

    @Test
    public void shouldUseSpecifiedNodeId() {
        BrokerCfg cfg = TestConfigReader.readConfig("specific-node-id", Collections.emptyMap());
        ClusterCfg cfgCluster = cfg.getCluster();
        Assertions.assertThat((int)cfgCluster.getNodeId()).isEqualTo(2);
    }

    @Test
    public void shouldUseNodeIdFromEnvironmentWithSpecifiedNodeIdInConfig() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put(ZEEBE_BROKER_CLUSTER_NODE_ID, "2");
        environment.put(ZEEBE_BROKER_CLUSTER_CLUSTER_SIZE, "6");
        BrokerCfg cfg = TestConfigReader.readConfig("specific-node-id", environment);
        ClusterCfg cfgCluster = cfg.getCluster();
        Assertions.assertThat((int)cfgCluster.getNodeId()).isEqualTo(2);
    }

    @Test
    public void shouldSanitizeContactPoints() {
        ClusterCfg sutClusterConfig = new ClusterCfg();
        List<String> input = Arrays.asList("", "foo ", null, "   ", "bar");
        List<String> expected = Arrays.asList("foo", "bar");
        sutClusterConfig.setInitialContactPoints(input);
        List actual = sutClusterConfig.getInitialContactPoints();
        Assertions.assertThat((List)actual).isEqualTo(expected);
    }

    @Test
    public void shouldGeneratePartitionIds() {
        ClusterCfg clusterCfg = new ClusterCfg();
        clusterCfg.setPartitionsCount(8);
        clusterCfg.init(new BrokerCfg(), "");
        Assertions.assertThat((List)clusterCfg.getPartitionIds()).containsExactly((Object[])new Integer[]{1, 2, 3, 4, 5, 6, 7, 8});
    }

    @Test
    void shouldThrowExceptionIfNodeIdIsNegative() {
        Map<String, String> environment = Collections.singletonMap(ZEEBE_BROKER_CLUSTER_NODE_ID, "-1");
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> TestConfigReader.readConfig("default", environment)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Node id must be positive");
    }

    @Test
    public void shouldThrowExceptionIfNodeIdIsInvalid() {
        Map<String, String> environment = Collections.singletonMap(ZEEBE_BROKER_CLUSTER_NODE_ID, "a");
        Assertions.assertThatCode(() -> TestConfigReader.readConfig("default", environment)).hasRootCauseInstanceOf(IllegalArgumentException.class).hasMessageContaining("to int");
    }

    @Test
    void shouldThrowExceptionIfReplicationFactorIsNegative() {
        Map<String, String> environment = Collections.singletonMap(ZEEBE_BROKER_CLUSTER_REPLICATION_FACTOR, "-1");
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> TestConfigReader.readConfig("default", environment)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Replication factor -1 needs to be larger then zero and not larger then cluster size 1.");
    }

    @Test
    void shouldThrowExceptionIfReplicationFactorIsLargerThenClusterSize() {
        Map<String, String> environment = Collections.singletonMap(ZEEBE_BROKER_CLUSTER_REPLICATION_FACTOR, "2");
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> TestConfigReader.readConfig("default", environment)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Replication factor 2 needs to be larger then zero and not larger then cluster size 1.");
    }

    @Test
    void shouldThrowExceptionIfPartitionsCountIsNegative() {
        Map<String, String> environment = Collections.singletonMap(ZEEBE_BROKER_CLUSTER_PARTITIONS_COUNT, "-1");
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> TestConfigReader.readConfig("default", environment)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Partition count must not be smaller than 1.");
    }

    @Test
    void shouldThrowExceptionIfElectionTimeoutIsSmallerThanOneMs() {
        Map<String, String> environment = Collections.singletonMap("zeebe.broker.cluster.electionTimeout", "0ms");
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> TestConfigReader.readConfig("default", environment)).isInstanceOf(IllegalArgumentException.class)).hasMessage("electionTimeout PT0S must be at least 1ms");
    }

    @Test
    void shouldThrowExceptionIfElectionTimeoutIsSmallerThanHeartbeatInterval() {
        Map<String, String> environment = Collections.singletonMap("zeebe.broker.cluster.electionTimeout", "1ms");
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> TestConfigReader.readConfig("default", environment)).isInstanceOf(IllegalArgumentException.class)).hasMessage("electionTimeout PT0.001S must be greater than heartbeatInterval PT0.25S");
    }

    @Test
    void shouldThrowExceptionIfHeartbeatIntervalIsSmallerThanOneMs() {
        Map<String, String> environment = Collections.singletonMap("zeebe.broker.cluster.heartbeatInterval", "0ms");
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> TestConfigReader.readConfig("default", environment)).isInstanceOf(IllegalArgumentException.class)).hasMessage("heartbeatInterval PT0S must be at least 1ms");
    }

    @Test
    public void shouldOverrideReplicationFactorViaEnvironment() {
        Map<String, String> environment = Collections.singletonMap(ZEEBE_BROKER_CLUSTER_REPLICATION_FACTOR, "2");
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", environment);
        ClusterCfg cfgCluster = cfg.getCluster();
        Assertions.assertThat((int)cfgCluster.getReplicationFactor()).isEqualTo(2);
    }

    @Test
    public void shouldOverridePartitionsCountViaEnvironment() {
        Map<String, String> environment = Collections.singletonMap(ZEEBE_BROKER_CLUSTER_PARTITIONS_COUNT, "2");
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", environment);
        ClusterCfg cfgCluster = cfg.getCluster();
        Assertions.assertThat((int)cfgCluster.getPartitionsCount()).isEqualTo(2);
    }

    @Test
    public void shouldOverrideClusterSizeViaEnvironment() {
        Map<String, String> environment = Collections.singletonMap(ZEEBE_BROKER_CLUSTER_CLUSTER_SIZE, "8");
        BrokerCfg cfg = TestConfigReader.readConfig("cluster-cfg", environment);
        ClusterCfg cfgCluster = cfg.getCluster();
        Assertions.assertThat((int)cfgCluster.getClusterSize()).isEqualTo(8);
    }

    @Test
    public void shouldUseDefaultContactPoints() {
        List defaultContactPoints = Collections.emptyList();
        ClusterCfg emptyCfg = TestConfigReader.readConfig("empty", Map.of()).getCluster();
        ClusterCfg defaultCfg = TestConfigReader.readConfig("default", Map.of()).getCluster();
        Assertions.assertThat((List)emptyCfg.getInitialContactPoints()).containsExactlyElementsOf(defaultContactPoints);
        Assertions.assertThat((List)defaultCfg.getInitialContactPoints()).containsExactlyElementsOf(defaultContactPoints);
    }

    @Test
    public void shouldUseSpecifiedContactPoints() {
        List<String> expectedContactPoints = List.of("broker1", "broker2", "broker3");
        ClusterCfg contactPointsCfg = TestConfigReader.readConfig("contact-points", Map.of()).getCluster();
        Assertions.assertThat((List)contactPointsCfg.getInitialContactPoints()).containsExactlyElementsOf(expectedContactPoints);
    }

    @Test
    public void shouldUseContactPointsFromEnvironment() {
        Map<String, String> environment = Collections.singletonMap(ZEEBE_BROKER_CLUSTER_INITIAL_CONTACT_POINTS, "foo,bar");
        ClusterCfg emptyCfg = TestConfigReader.readConfig("empty", environment).getCluster();
        ClusterCfg defaultCfg = TestConfigReader.readConfig("default", environment).getCluster();
        Assertions.assertThat((List)emptyCfg.getInitialContactPoints()).containsExactlyElementsOf(List.of("foo", "bar"));
        Assertions.assertThat((List)defaultCfg.getInitialContactPoints()).containsExactlyElementsOf(List.of("foo", "bar"));
    }

    @Test
    public void shouldUseContactPointsFromEnvironmentWithSpecifiedContactPoints() {
        Map<String, String> environment = Collections.singletonMap(ZEEBE_BROKER_CLUSTER_INITIAL_CONTACT_POINTS, "1.1.1.1,2.2.2.2");
        ClusterCfg contactPointsCfg = TestConfigReader.readConfig("contact-points", environment).getCluster();
        Assertions.assertThat((List)contactPointsCfg.getInitialContactPoints()).containsExactlyElementsOf(List.of("1.1.1.1", "2.2.2.2"));
    }

    @Test
    public void shouldUseSingleContactPointFromEnvironment() {
        Map<String, String> environment = Collections.singletonMap(ZEEBE_BROKER_CLUSTER_INITIAL_CONTACT_POINTS, "hello");
        ClusterCfg contactPointsCfg = TestConfigReader.readConfig("contact-points", environment).getCluster();
        Assertions.assertThat((List)contactPointsCfg.getInitialContactPoints()).containsExactlyElementsOf(List.of("hello"));
    }

    @Test
    public void shouldClearContactPointFromEnvironment() {
        Map<String, String> environment = Collections.singletonMap(ZEEBE_BROKER_CLUSTER_INITIAL_CONTACT_POINTS, "");
        ClusterCfg contactPointsCfg = TestConfigReader.readConfig("contact-points", environment).getCluster();
        Assertions.assertThat((List)contactPointsCfg.getInitialContactPoints()).containsExactlyElementsOf(List.of());
    }
}

