/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.DataCfg;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.springframework.util.unit.DataSize;

public class DataCfgTest {
    @Test
    public void shouldUseDefaultFreeSpaceConfig() {
        DataCfg dataCfg = new DataCfg();
        dataCfg.init(new BrokerCfg(), "/base");
        Assertions.assertThat((Comparable)dataCfg.getDisk().getFreeSpace().getProcessing()).isEqualTo((Object)DataSize.ofGigabytes((long)2L));
        Assertions.assertThat((Comparable)dataCfg.getDisk().getFreeSpace().getReplication()).isEqualTo((Object)DataSize.ofGigabytes((long)1L));
    }

    @Test
    public void shouldOverrideWhenOldWatermarksConfigProvided() {
        DataCfg dataCfg = new DataCfg();
        dataCfg.setDiskUsageMonitoringInterval(Duration.ofMinutes(5L));
        dataCfg.setDiskUsageMonitoringEnabled(false);
        dataCfg.init(new BrokerCfg(), "/base");
        Assertions.assertThat((Duration)dataCfg.getDisk().getMonitoringInterval()).isEqualTo((Object)Duration.ofMinutes(5L));
        Assertions.assertThat((boolean)dataCfg.getDisk().isEnableMonitoring()).isFalse();
    }
}

