/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.TestConfigReader;
import io.camunda.zeebe.engine.EngineConfiguration;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class EngineCfgTest {
    public final Map<String, String> environment = new HashMap<String, String>();

    EngineCfgTest() {
    }

    @Test
    void shouldCreateEngineConfigurationFromDefaults() {
        BrokerCfg cfg = TestConfigReader.readConfig("empty", this.environment);
        EngineConfiguration configuration = cfg.getExperimental().getEngine().createEngineConfiguration();
        Assertions.assertThat((int)configuration.getMessagesTtlCheckerBatchLimit()).isEqualTo(Integer.MAX_VALUE);
        Assertions.assertThat((Duration)configuration.getMessagesTtlCheckerInterval()).isEqualTo((Object)Duration.ofMinutes(1L));
        Assertions.assertThat((int)configuration.getDrgCacheCapacity()).isEqualTo(1000L);
        Assertions.assertThat((Duration)configuration.getJobsTimeoutCheckerPollingInterval()).isEqualTo((Object)Duration.ofSeconds(1L));
        Assertions.assertThat((int)configuration.getJobsTimeoutCheckerBatchLimit()).isEqualTo(Integer.MAX_VALUE);
        Assertions.assertThat((int)configuration.getValidatorsResultsOutputMaxSize()).isEqualTo(12288);
        Assertions.assertThat((int)configuration.getFormCacheCapacity()).isEqualTo(1000);
        Assertions.assertThat((int)configuration.getProcessCacheCapacity()).isEqualTo(1000);
    }

    @Test
    void shouldCreateEngineConfigurationFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("engine", this.environment);
        EngineConfiguration configuration = cfg.getExperimental().getEngine().createEngineConfiguration();
        Assertions.assertThat((int)configuration.getMessagesTtlCheckerBatchLimit()).isEqualTo(1000);
        Assertions.assertThat((Duration)configuration.getMessagesTtlCheckerInterval()).isEqualTo((Object)Duration.ofSeconds(15L));
        Assertions.assertThat((int)configuration.getDrgCacheCapacity()).isEqualTo(2000L);
        Assertions.assertThat((Duration)configuration.getJobsTimeoutCheckerPollingInterval()).isEqualTo((Object)Duration.ofSeconds(15L));
        Assertions.assertThat((int)configuration.getJobsTimeoutCheckerBatchLimit()).isEqualTo(1000);
        Assertions.assertThat((int)configuration.getValidatorsResultsOutputMaxSize()).isEqualTo(2000);
        Assertions.assertThat((int)configuration.getDrgCacheCapacity()).isEqualTo(2000L);
        Assertions.assertThat((int)configuration.getDrgCacheCapacity()).isEqualTo(2000L);
    }
}

