/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ConsistencyCheckCfg;
import io.camunda.zeebe.broker.system.configuration.ExperimentalRaftCfg;
import io.camunda.zeebe.broker.system.configuration.TestConfigReader;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.CONCURRENT)
final class ExperimentalCfgTest {
    final Map<String, String> environment = new HashMap<String, String>();

    ExperimentalCfgTest() {
    }

    @Test
    void shouldSetRaftRequestTimeoutFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ExperimentalRaftCfg raft = cfg.getExperimental().getRaft();
        Assertions.assertThat((Duration)raft.getRequestTimeout()).isEqualTo((Object)Duration.ofSeconds(10L));
    }

    @Test
    void shouldSetRaftRequestTimeoutFromEnv() {
        this.environment.put("zeebe.broker.experimental.raft.requestTimeout", "15s");
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ExperimentalRaftCfg raft = cfg.getExperimental().getRaft();
        Assertions.assertThat((Duration)raft.getRequestTimeout()).isEqualTo((Object)Duration.ofSeconds(15L));
    }

    @Test
    void shouldSetRaftMaxQuorumResponseTimeoutFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ExperimentalRaftCfg raft = cfg.getExperimental().getRaft();
        Assertions.assertThat((Duration)raft.getMaxQuorumResponseTimeout()).isEqualTo((Object)Duration.ofSeconds(8L));
    }

    @Test
    void shouldSetRaftMaxQuorumResponseTimeoutFromEnv() {
        this.environment.put("zeebe.broker.experimental.raft.maxQuorumResponseTimeout", "15s");
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ExperimentalRaftCfg raft = cfg.getExperimental().getRaft();
        Assertions.assertThat((Duration)raft.getMaxQuorumResponseTimeout()).isEqualTo((Object)Duration.ofSeconds(15L));
    }

    @Test
    void shouldSetRaftMinStepDownFailureCountFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ExperimentalRaftCfg raft = cfg.getExperimental().getRaft();
        Assertions.assertThat((int)raft.getMinStepDownFailureCount()).isEqualTo(5);
    }

    @Test
    void shouldSetRaftMinStepDownFailureCountFromEnv() {
        this.environment.put("zeebe.broker.experimental.raft.minStepDownFailureCount", "10");
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ExperimentalRaftCfg raft = cfg.getExperimental().getRaft();
        Assertions.assertThat((int)raft.getMinStepDownFailureCount()).isEqualTo(10);
    }

    @Test
    void shouldSetPreferSnapshotReplicationThresholdFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ExperimentalRaftCfg raft = cfg.getExperimental().getRaft();
        Assertions.assertThat((int)raft.getPreferSnapshotReplicationThreshold()).isEqualTo(500);
    }

    @Test
    void shouldSetPreferSnapshotReplicationThresholdFromEnv() {
        this.environment.put("zeebe.broker.experimental.raft.preferSnapshotReplicationThreshold", "10");
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ExperimentalRaftCfg raft = cfg.getExperimental().getRaft();
        Assertions.assertThat((int)raft.getPreferSnapshotReplicationThreshold()).isEqualTo(10);
    }

    @Test
    void shouldSetEnablePreconditionsFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ConsistencyCheckCfg consistencyChecks = cfg.getExperimental().getConsistencyChecks();
        Assertions.assertThat((boolean)consistencyChecks.isEnablePreconditions()).isTrue();
    }

    @Test
    void shouldSetEnablePreconditionsFromEnv() {
        this.environment.put("zeebe.broker.experimental.consistencyChecks.enablePreconditions", "false");
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ConsistencyCheckCfg consistencyChecks = cfg.getExperimental().getConsistencyChecks();
        Assertions.assertThat((boolean)consistencyChecks.isEnablePreconditions()).isFalse();
    }

    @Test
    void shouldSetEnableForeignKeyChecksFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ConsistencyCheckCfg consistencyChecks = cfg.getExperimental().getConsistencyChecks();
        Assertions.assertThat((boolean)consistencyChecks.isEnableForeignKeyChecks()).isTrue();
    }

    @Test
    void shouldSetEnableForeignKeyChecksFromEnv() {
        this.environment.put("zeebe.broker.experimental.consistencyChecks.enableForeignKeyChecks", "false");
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ConsistencyCheckCfg consistencyChecks = cfg.getExperimental().getConsistencyChecks();
        Assertions.assertThat((boolean)consistencyChecks.isEnableForeignKeyChecks()).isFalse();
    }

    @Test
    void shouldSetPreallocateSegmentFilesFromEnv() {
        this.environment.put("zeebe.broker.experimental.raft.preallocateSegmentFiles", "false");
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ExperimentalRaftCfg raftCfg = cfg.getExperimental().getRaft();
        Assertions.assertThat((boolean)raftCfg.isPreallocateSegmentFiles()).isFalse();
    }

    @Test
    void shouldSetPreallocateSegmentFilesFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("experimental-cfg", this.environment);
        ExperimentalRaftCfg raftCfg = cfg.getExperimental().getRaft();
        Assertions.assertThat((boolean)raftCfg.isPreallocateSegmentFiles()).isTrue();
    }
}

