/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.ExportingCfg;
import io.camunda.zeebe.broker.system.configuration.TestConfigReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.Set;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class ExporterConfigurationTest {
    ExporterConfigurationTest() {
    }

    @Test
    void shouldSetSkipPositionsFromEnvironment() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("zeebe.broker.exporting.skipRecords", "1, 2, 3 , 3, 2, 1, 0");
        BrokerCfg cfg = TestConfigReader.readConfig("exporters", environment);
        ExportingCfg exportingCfg = cfg.getExporting();
        Assertions.assertThat((Collection)exportingCfg.getSkipRecords()).isEqualTo(Set.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L), Long.valueOf(0L)));
    }

    @Test
    void shouldSetSkipPositionsFromConfigurationFile() {
        HashMap<String, String> environment = new HashMap<String, String>();
        BrokerCfg cfg = TestConfigReader.readConfig("exporters", environment);
        ExportingCfg exportingCfg = cfg.getExporting();
        Assertions.assertThat((Collection)exportingCfg.getSkipRecords()).isEqualTo(Set.of(Long.valueOf(112233L), Long.valueOf(445566L)));
    }

    @Test
    void shouldSetSkipPositions() {
        ExportingCfg exportingCfg = new ExportingCfg();
        exportingCfg.setSkipRecords(Set.of(Long.valueOf(1L), Long.valueOf(2L)));
        Assertions.assertThat((Collection)exportingCfg.getSkipRecords()).isEqualTo(Set.of(Long.valueOf(1L), Long.valueOf(2L)));
    }

    @Test
    void shouldSetSkipPositionsForOtherExporters() {
        HashMap<String, String> environment = new HashMap<String, String>();
        environment.put("zeebe.broker.exporting.skipRecords", "1, 2, 3");
        BrokerCfg cfg = TestConfigReader.readConfig("exporters", environment);
        ExportingCfg exportingCfg = cfg.getExporting();
        Assertions.assertThat((Collection)exportingCfg.getSkipRecords()).isEqualTo(Set.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L)));
    }
}

