/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.FeatureFlagsCfg;
import io.camunda.zeebe.broker.system.configuration.TestConfigReader;
import java.util.HashMap;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class FeatureFlagsCfgTest {
    public final Map<String, String> environment = new HashMap<String, String>();

    FeatureFlagsCfgTest() {
    }

    @Test
    void shouldDisableYieldingDueDateCheckerFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("feature-flags-cfg", this.environment);
        FeatureFlagsCfg featureFlagsCfg = cfg.getExperimental().getFeatures();
        Assertions.assertThat((boolean)featureFlagsCfg.isEnableYieldingDueDateChecker()).isFalse();
    }

    @Test
    void shouldEnableYieldingDueDateCheckerFromEnv() {
        this.environment.put("zeebe.broker.experimental.features.enableYieldingDueDateChecker", "true");
        BrokerCfg cfg = TestConfigReader.readConfig("feature-flags-cfg", this.environment);
        FeatureFlagsCfg featureFlagsCfg = cfg.getExperimental().getFeatures();
        Assertions.assertThat((boolean)featureFlagsCfg.isEnableYieldingDueDateChecker()).isTrue();
    }

    @Test
    void shouldDisableActorMetricsByDefault() {
        BrokerCfg cfg = TestConfigReader.readConfig("empty", this.environment);
        FeatureFlagsCfg featureFlagsCfg = cfg.getExperimental().getFeatures();
        Assertions.assertThat((boolean)featureFlagsCfg.isEnableActorMetrics()).isFalse();
    }

    @Test
    void shouldSetEnableActorMetricsFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("feature-flags-cfg", this.environment);
        FeatureFlagsCfg featureFlagsCfg = cfg.getExperimental().getFeatures();
        Assertions.assertThat((boolean)featureFlagsCfg.isEnableActorMetrics()).isTrue();
    }

    @Test
    void shouldSetEnableActorMetricsFromEnv() {
        this.environment.put("zeebe.broker.experimental.features.enableActorMetrics", "false");
        BrokerCfg cfg = TestConfigReader.readConfig("feature-flags-cfg", this.environment);
        FeatureFlagsCfg featureFlagsCfg = cfg.getExperimental().getFeatures();
        Assertions.assertThat((boolean)featureFlagsCfg.isEnableActorMetrics()).isFalse();
    }

    @Test
    void shouldDisableMessageTTLCheckerAsyncByDefault() {
        BrokerCfg cfg = TestConfigReader.readConfig("empty", this.environment);
        FeatureFlagsCfg featureFlagsCfg = cfg.getExperimental().getFeatures();
        Assertions.assertThat((boolean)featureFlagsCfg.isEnableMessageTtlCheckerAsync()).isFalse();
    }

    @Test
    void shouldSetEnableMessageTtlCheckerAsyncFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("feature-flags-cfg", this.environment);
        FeatureFlagsCfg featureFlagsCfg = cfg.getExperimental().getFeatures();
        Assertions.assertThat((boolean)featureFlagsCfg.isEnableMessageTtlCheckerAsync()).isTrue();
    }

    @Test
    void shouldSetEnableMessageTtlCheckerAsyncFromEnv() {
        this.environment.put("zeebe.broker.experimental.features.enableMessageTTLCheckerAsync", "false");
        BrokerCfg cfg = TestConfigReader.readConfig("feature-flags-cfg", this.environment);
        FeatureFlagsCfg featureFlagsCfg = cfg.getExperimental().getFeatures();
        Assertions.assertThat((boolean)featureFlagsCfg.isEnableMessageTtlCheckerAsync()).isFalse();
    }

    @Test
    void shouldDisableDueDateCheckerAsyncByDefault() {
        BrokerCfg cfg = TestConfigReader.readConfig("empty", this.environment);
        FeatureFlagsCfg featureFlagsCfg = cfg.getExperimental().getFeatures();
        Assertions.assertThat((boolean)featureFlagsCfg.isEnableTimerDueDateCheckerAsync()).isFalse();
    }

    @Test
    void shouldSetEnableTimerDueDateCheckerAsyncFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("feature-flags-cfg", this.environment);
        FeatureFlagsCfg featureFlagsCfg = cfg.getExperimental().getFeatures();
        Assertions.assertThat((boolean)featureFlagsCfg.isEnableTimerDueDateCheckerAsync()).isTrue();
    }

    @Test
    void shouldSetEnableTimerDueDateCheckerAsyncFromEnv() {
        this.environment.put("zeebe.broker.experimental.features.enableTimerDueDateCheckerAsync", "false");
        BrokerCfg cfg = TestConfigReader.readConfig("feature-flags-cfg", this.environment);
        FeatureFlagsCfg featureFlagsCfg = cfg.getExperimental().getFeatures();
        Assertions.assertThat((boolean)featureFlagsCfg.isEnableTimerDueDateCheckerAsync()).isFalse();
    }

    @Test
    void shouldSetEnableStraightThroughProcessingLoopDetectorFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("feature-flags-cfg", this.environment);
        FeatureFlagsCfg featureFlagsCfg = cfg.getExperimental().getFeatures();
        Assertions.assertThat((boolean)featureFlagsCfg.isEnableStraightThroughProcessingLoopDetector()).isFalse();
    }

    @Test
    void shouldSetEnableStraightThroughProcessingLoopDetectorFromEnv() {
        this.environment.put("zeebe.broker.experimental.features.enableStraightThroughProcessingLoopDetector", "true");
        BrokerCfg cfg = TestConfigReader.readConfig("feature-flags-cfg", this.environment);
        FeatureFlagsCfg featureFlagsCfg = cfg.getExperimental().getFeatures();
        Assertions.assertThat((boolean)featureFlagsCfg.isEnableStraightThroughProcessingLoopDetector()).isTrue();
    }
}

