/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.ProcessingCfg;
import io.camunda.zeebe.broker.system.configuration.TestConfigReader;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

final class ProcessingCfgTest {
    ProcessingCfgTest() {
    }

    @Test
    void shouldUseDefaultMaxCommandsInBatch() {
        ProcessingCfg cfg = new ProcessingCfg();
        int limit = cfg.getMaxCommandsInBatch();
        Assertions.assertThat((int)limit).isEqualTo(100);
    }

    @Test
    void shouldSetMaxCommandsInBatch() {
        ProcessingCfg cfg = new ProcessingCfg();
        cfg.setMaxCommandsInBatch(50);
        int limit = cfg.getMaxCommandsInBatch();
        Assertions.assertThat((int)limit).isEqualTo(50);
    }

    @Test
    void shouldSetMaxCommandsInBatchFromConfig() {
        ProcessingCfg cfg = TestConfigReader.readConfig("processing-cfg", Collections.emptyMap()).getProcessing();
        int limit = cfg.getMaxCommandsInBatch();
        Assertions.assertThat((int)limit).isEqualTo(125);
    }

    @Test
    void shouldSetMaxCommandsInBatchFromEnvironment() {
        Map<String, String> environment = Collections.singletonMap("zeebe.broker.processing.maxCommandsInBatch", "75");
        ProcessingCfg cfg = TestConfigReader.readConfig("processing-cfg", environment).getProcessing();
        int limit = cfg.getMaxCommandsInBatch();
        Assertions.assertThat((int)limit).isEqualTo(75);
    }

    @Test
    void shouldRejectInvalidMaxCommandsInBatch() {
        Map<String, String> environment = Collections.singletonMap("zeebe.broker.processing.maxCommandsInBatch", "-1");
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestConfigReader.readConfig("processing-cfg", environment)).isInstanceOf(IllegalArgumentException.class)).hasMessageContaining("maxCommandsInBatch must be >= 1");
    }

    @Test
    void shouldEnableAsyncScheduledTasksByDefault() {
        ProcessingCfg cfg = new ProcessingCfg();
        boolean enabled = cfg.isEnableAsyncScheduledTasks();
        Assertions.assertThat((boolean)enabled).isTrue();
    }

    @Test
    void shouldSetAsyncScheduledTasks() {
        ProcessingCfg cfg = new ProcessingCfg();
        cfg.setEnableAsyncScheduledTasks(false);
        boolean enabled = cfg.isEnableAsyncScheduledTasks();
        Assertions.assertThat((boolean)enabled).isFalse();
    }

    @Test
    void shouldSetAsyncScheduledTasksFromConfig() {
        ProcessingCfg cfg = TestConfigReader.readConfig("processing-cfg", Collections.emptyMap()).getProcessing();
        boolean enabled = cfg.isEnableAsyncScheduledTasks();
        Assertions.assertThat((boolean)enabled).isFalse();
    }

    @Test
    void shouldDisableAsyncScheduledTasksFromEnvironment() {
        Map<String, String> environment = Collections.singletonMap("zeebe.broker.processing.enableAsyncScheduledTasks", "true");
        ProcessingCfg cfg = TestConfigReader.readConfig("processing-cfg", environment).getProcessing();
        boolean enabled = cfg.isEnableAsyncScheduledTasks();
        Assertions.assertThat((boolean)enabled).isTrue();
    }

    @Test
    void shouldSetSkipPositions() {
        ProcessingCfg cfg = new ProcessingCfg();
        cfg.setSkipPositions(Set.of(Long.valueOf(1L), Long.valueOf(2L), Long.valueOf(3L)));
        Set skipPositions = cfg.skipPositions();
        Assertions.assertThat((Collection)skipPositions).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L, 3L});
    }

    @Test
    void shouldSetSkipPositionsFromConfig() {
        ProcessingCfg cfg = TestConfigReader.readConfig("processing-cfg", Collections.emptyMap()).getProcessing();
        Set skipPositions = cfg.skipPositions();
        Assertions.assertThat((Collection)skipPositions).containsExactlyInAnyOrder((Object[])new Long[]{1L, 2L, 3L});
    }

    @Test
    void shouldSetSkipPositionsFromEnvironment() {
        Map<String, String> environment = Collections.singletonMap("zeebe.broker.processing.skipPositions", "4,5,6");
        ProcessingCfg cfg = TestConfigReader.readConfig("processing-cfg", environment).getProcessing();
        Set skipPositions = cfg.skipPositions();
        Assertions.assertThat((Collection)skipPositions).containsExactly((Object[])new Long[]{4L, 5L, 6L});
    }
}

