/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.BrokerCfg;
import io.camunda.zeebe.broker.system.configuration.RocksdbCfg;
import io.camunda.zeebe.broker.system.configuration.TestConfigReader;
import io.camunda.zeebe.db.impl.rocksdb.RocksDbConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.junit.Test;
import org.springframework.util.unit.DataSize;

public final class RocksdbCfgTest {
    public final Map<String, String> environment = new HashMap<String, String>();

    @Test
    public void shouldDisableStatisticsPerDefault() {
        BrokerCfg cfg = TestConfigReader.readConfig("empty", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((boolean)rocksdb.isEnableStatistics()).isFalse();
    }

    @Test
    public void shouldHaveEmptyPropertiesPerDefault() {
        BrokerCfg cfg = TestConfigReader.readConfig("empty", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((Map)rocksdb.getColumnFamilyOptions()).isEmpty();
    }

    @Test
    public void shouldUseDefaultMemoryLimit() {
        BrokerCfg cfg = TestConfigReader.readConfig("empty", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((Comparable)rocksdb.getMemoryLimit()).isEqualTo((Object)DataSize.ofMegabytes((long)512L));
    }

    @Test
    public void shouldUseDefaultMaxOpenFiles() {
        BrokerCfg cfg = TestConfigReader.readConfig("empty", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((int)rocksdb.getMaxOpenFiles()).isEqualTo(-1);
    }

    @Test
    public void shouldCreateRocksDbConfigurationFromDefault() {
        BrokerCfg cfg = TestConfigReader.readConfig("empty", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        RocksDbConfiguration rocksDbConfiguration = rocksdb.createRocksDbConfiguration();
        Assertions.assertThat((Map)rocksDbConfiguration.getColumnFamilyOptions()).isEmpty();
        Assertions.assertThat((boolean)rocksDbConfiguration.isStatisticsEnabled()).isFalse();
        Assertions.assertThat((long)rocksDbConfiguration.getMemoryLimit()).isEqualTo(DataSize.ofMegabytes((long)512L).toBytes());
        Assertions.assertThat((int)rocksDbConfiguration.getMaxOpenFiles()).isEqualTo(-1);
        Assertions.assertThat((int)rocksDbConfiguration.getMaxWriteBufferNumber()).isEqualTo(6);
        Assertions.assertThat((int)rocksDbConfiguration.getMinWriteBufferNumberToMerge()).isEqualTo(3);
        Assertions.assertThat((int)rocksDbConfiguration.getIoRateBytesPerSecond()).isZero();
        Assertions.assertThat((boolean)rocksDbConfiguration.isWalDisabled()).isTrue();
    }

    @Test
    public void shouldCreateRocksDbConfigurationFromConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        RocksDbConfiguration rocksDbConfiguration = rocksdb.createRocksDbConfiguration();
        ((MapAssert)Assertions.assertThat((Map)rocksDbConfiguration.getColumnFamilyOptions()).containsEntry((Object)"compaction_pri", (Object)"kOldestSmallestSeqFirst")).containsEntry((Object)"write_buffer_size", (Object)"67108864");
        Assertions.assertThat((boolean)rocksDbConfiguration.isStatisticsEnabled()).isTrue();
        Assertions.assertThat((long)rocksDbConfiguration.getMemoryLimit()).isEqualTo(DataSize.ofMegabytes((long)32L).toBytes());
        Assertions.assertThat((int)rocksDbConfiguration.getMaxOpenFiles()).isEqualTo(3);
    }

    @Test
    public void shouldSetColumnFamilyOptionsConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Properties columnFamilyOptions = rocksdb.getColumnFamilyOptions();
        ((MapAssert)Assertions.assertThat((Map)columnFamilyOptions).containsEntry((Object)"compaction_pri", (Object)"kOldestSmallestSeqFirst")).containsEntry((Object)"write_buffer_size", (Object)"67108864");
    }

    @Test
    public void shouldEnableStatisticsViaConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((boolean)rocksdb.isEnableStatistics()).isTrue();
    }

    @Test
    public void shouldSetMemoryLimitViaConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((Comparable)rocksdb.getMemoryLimit()).isEqualTo((Object)DataSize.ofMegabytes((long)32L));
    }

    @Test
    public void shouldSetMaxOpenFilesViaConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((int)rocksdb.getMaxOpenFiles()).isEqualTo(3);
    }

    @Test
    public void shouldSetColumnFamilyOptionsConfigFromEnvironmentVariables() {
        this.environment.put("zeebe.broker.experimental.rocksdb.columnFamilyOptions.arena.block.size", "16777216");
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Properties columnFamilyOptions = rocksdb.getColumnFamilyOptions();
        Assertions.assertThat((Map)columnFamilyOptions).containsEntry((Object)"arena_block_size", (Object)"16777216");
    }

    @Test
    public void shouldEnableStatisticsViaEnvironmentVariables() {
        this.environment.put("zeebe.broker.experimental.rocksdb.enableStatistics", "true");
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((boolean)rocksdb.isEnableStatistics()).isTrue();
    }

    @Test
    public void shouldSetMemoryLimitViaEnvironmentVariables() {
        this.environment.put("zeebe.broker.experimental.rocksdb.memoryLimit", "16KB");
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((Comparable)rocksdb.getMemoryLimit()).isEqualTo((Object)DataSize.ofKilobytes((long)16L));
    }

    @Test
    public void shouldSetMaxOpenFilesViaEnvironmentVariables() {
        this.environment.put("zeebe.broker.experimental.rocksdb.maxOpenFiles", "5");
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((int)rocksdb.getMaxOpenFiles()).isEqualTo(5);
    }

    @Test
    public void shouldSetMaxWriteBufferNumberViaConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((int)rocksdb.getMaxWriteBufferNumber()).isEqualTo(3);
    }

    @Test
    public void shouldSetMaxWriteBufferNumberViaEnvironmentVariables() {
        this.environment.put("zeebe.broker.experimental.rocksdb.maxWriteBufferNumber", "5");
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((int)rocksdb.getMaxWriteBufferNumber()).isEqualTo(5);
    }

    @Test
    public void shouldSetMinWriteBufferNumberToMergeViaConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((int)rocksdb.getMinWriteBufferNumberToMerge()).isEqualTo(3);
    }

    @Test
    public void shouldSetMinWriteBufferNumberToMergeViaEnvironmentVariables() {
        this.environment.put("zeebe.broker.experimental.rocksdb.minWriteBufferNumberToMerge", "5");
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((int)rocksdb.getMinWriteBufferNumberToMerge()).isEqualTo(5);
    }

    @Test
    public void shouldSetIoRateBytesPerSecondViaConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((int)rocksdb.getIoRateBytesPerSecond()).isEqualTo(4096);
    }

    @Test
    public void shouldSetIoRateBytesPerSecondViaEnvironmentVariables() {
        this.environment.put("zeebe.broker.experimental.rocksdb.ioRateBytesPerSecond", "4096");
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((int)rocksdb.getIoRateBytesPerSecond()).isEqualTo(4096);
    }

    @Test
    public void shouldSetIsDisableWalPerSecondViaConfig() {
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((boolean)rocksdb.isDisableWal()).isTrue();
    }

    @Test
    public void shouldSetIsDisableWalViaEnvironmentVariables() {
        this.environment.put("zeebe.broker.experimental.rocksdb.disableWal", "true");
        BrokerCfg cfg = TestConfigReader.readConfig("rocksdb-cfg", this.environment);
        RocksdbCfg rocksdb = cfg.getExperimental().getRocksdb();
        Assertions.assertThat((boolean)rocksdb.isDisableWal()).isTrue();
    }
}

