/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.configuration;

import io.camunda.zeebe.broker.system.configuration.TestConfigReader;
import io.camunda.zeebe.broker.system.configuration.ThreadsCfg;
import java.util.Collections;
import java.util.Map;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.parallel.Execution;
import org.junit.jupiter.api.parallel.ExecutionMode;

@Execution(value=ExecutionMode.CONCURRENT)
final class ThreadsCfgTest {
    ThreadsCfgTest() {
    }

    @Test
    void shouldChooseDefaultCpuThreadCount() {
        ThreadsCfg cfg = new ThreadsCfg();
        int cpuThreadCount = cfg.getCpuThreadCount();
        Assertions.assertThat((int)cpuThreadCount).isEqualTo(2);
    }

    @Test
    void shouldChooseDefaultIoThreadCount() {
        ThreadsCfg cfg = new ThreadsCfg();
        int ioThreadCount = cfg.getIoThreadCount();
        Assertions.assertThat((int)ioThreadCount).isEqualTo(2);
    }

    @Test
    void shouldSetCpuThreadCount() {
        ThreadsCfg cfg = new ThreadsCfg();
        cfg.setCpuThreadCount(3);
        int cpuThreadCount = cfg.getCpuThreadCount();
        Assertions.assertThat((int)cpuThreadCount).isEqualTo(3);
    }

    @Test
    void shouldSetCpuThreadCountFromConfig() {
        ThreadsCfg cfg = TestConfigReader.readConfig("threads-cfg", Collections.emptyMap()).getThreads();
        int cpuThreadCount = cfg.getCpuThreadCount();
        Assertions.assertThat((int)cpuThreadCount).isEqualTo(5);
    }

    @Test
    void shouldSetCpuThreadCountFromEnvironment() {
        Map<String, String> environment = Collections.singletonMap("zeebe.broker.threads.cpuThreadCount", "6");
        ThreadsCfg cfg = TestConfigReader.readConfig("threads-cfg", environment).getThreads();
        int cpuThreadCount = cfg.getCpuThreadCount();
        Assertions.assertThat((int)cpuThreadCount).isEqualTo(6);
    }

    @Test
    void shouldSetIoThreadCount() {
        ThreadsCfg cfg = new ThreadsCfg();
        cfg.setIoThreadCount(3);
        int ioThreadCount = cfg.getIoThreadCount();
        Assertions.assertThat((int)ioThreadCount).isEqualTo(3);
    }

    @Test
    void shouldSetIoThreadCountFromConfig() {
        ThreadsCfg cfg = TestConfigReader.readConfig("threads-cfg", Collections.emptyMap()).getThreads();
        int ioThreadCount = cfg.getIoThreadCount();
        Assertions.assertThat((int)ioThreadCount).isEqualTo(7);
    }

    @Test
    void shouldSetIoThreadCountFromEnv() {
        Map<String, String> environment = Collections.singletonMap("zeebe.broker.threads.ioThreadCount", "6");
        ThreadsCfg cfg = TestConfigReader.readConfig("threads-cfg", environment).getThreads();
        int cpuThreadCount = cfg.getIoThreadCount();
        Assertions.assertThat((int)cpuThreadCount).isEqualTo(6);
    }
}

