/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.monitoring;

import io.camunda.zeebe.broker.system.monitoring.BrokerHealthCheckService;
import io.camunda.zeebe.protocol.impl.encoding.BrokerInfo;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.mockito.Mockito;

public class BrokerHealthCheckServiceTest {
    @Test
    public void shouldNotBeReadyHealthyOrStartedBeforePartitionManagerIsRegistered() {
        BrokerInfo brokerInfo = (BrokerInfo)Mockito.mock(BrokerInfo.class);
        BrokerHealthCheckService healthCheckService = new BrokerHealthCheckService(brokerInfo);
        boolean healthyActual = healthCheckService.isBrokerHealthy();
        boolean startedActual = healthCheckService.isBrokerStarted();
        boolean readyActual = healthCheckService.isBrokerReady();
        Assertions.assertThat((boolean)healthyActual).isFalse();
        Assertions.assertThat((boolean)startedActual).isFalse();
        Assertions.assertThat((boolean)readyActual).isFalse();
    }

    @Test
    public void shouldThrowIllegalStateExceptionIfStatusIsUpdatedBeforePartitionsAreKnown() {
        BrokerInfo brokerInfo = (BrokerInfo)Mockito.mock(BrokerInfo.class);
        BrokerHealthCheckService healthCheckService = new BrokerHealthCheckService(brokerInfo);
        Assertions.assertThatThrownBy(() -> healthCheckService.onBecameRaftFollower(0, 0L)).isInstanceOf(IllegalStateException.class);
        Assertions.assertThatThrownBy(() -> healthCheckService.onBecameRaftLeader(0, 0L)).isInstanceOf(IllegalStateException.class);
    }
}

