/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.test.EmbeddedBrokerRule;
import java.nio.file.Path;
import org.assertj.core.api.AbstractPathAssert;
import org.assertj.core.api.Assertions;
import org.junit.Rule;
import org.junit.Test;

public class BrokerDifferentRuntimeDirectoryTest {
    private static final String STATE = "state";
    @Rule
    public final EmbeddedBrokerRule brokerRule = new EmbeddedBrokerRule(cfg -> {
        cfg.getCluster().setPartitionsCount(2);
        cfg.getData().setRuntimeDirectory(STATE);
    });

    @Test
    public void shouldUseConfiguredRuntimeDirectory() {
        Path runtimeDirectory = this.brokerRule.getBrokerBase().resolve(STATE);
        Assertions.assertThat((Path)runtimeDirectory).isNotEmptyDirectory();
        for (int i = 1; i <= 2; ++i) {
            ((AbstractPathAssert)Assertions.assertThat((Path)runtimeDirectory.resolve(String.valueOf(i))).describedAs("Runtime directory for the partition must be created and db must be initialized.", new Object[0])).isNotEmptyDirectory();
            RaftPartition partition = this.brokerRule.getBroker().getBrokerContext().getPartitionManager().getRaftPartition(i);
            ((AbstractPathAssert)Assertions.assertThat((Path)partition.dataDirectory().toPath().resolve("runtime")).describedAs("No runtime directory is created in the data directory", new Object[0])).doesNotExist();
        }
    }
}

