/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.storage.log.RaftLogReader;
import io.camunda.zeebe.broker.system.management.BrokerAdminService;
import io.camunda.zeebe.broker.system.management.PartitionStatus;
import io.camunda.zeebe.broker.test.EmbeddedBrokerRule;
import io.camunda.zeebe.client.ZeebeClient;
import io.camunda.zeebe.client.ZeebeClientBuilder;
import io.camunda.zeebe.client.api.response.PublishMessageResponse;
import io.camunda.zeebe.protocol.record.intent.MessageIntent;
import io.camunda.zeebe.snapshots.SnapshotId;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotId;
import io.camunda.zeebe.test.util.record.MessageRecordStream;
import io.camunda.zeebe.test.util.record.RecordingExporter;
import io.netty.util.NetUtil;
import java.net.InetSocketAddress;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.IntStream;
import org.agrona.CloseHelper;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.After;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public class BrokerSnapshotTest {
    private static final int PARTITION_ID = 1;
    @Rule
    public final EmbeddedBrokerRule brokerRule = new EmbeddedBrokerRule(new Consumer[0]);
    private RaftLogReader journalReader;
    private BrokerAdminService brokerAdminService;
    private ZeebeClient client;

    @Before
    public void setup() {
        RaftPartition raftPartition = this.brokerRule.getBroker().getBrokerContext().getPartitionManager().getRaftPartition(1);
        this.journalReader = raftPartition.getServer().openReader();
        this.brokerAdminService = this.brokerRule.getBroker().getBrokerContext().getBrokerAdminService();
        String contactPoint = NetUtil.toSocketAddressString((InetSocketAddress)this.brokerRule.getGatewayAddress());
        ZeebeClientBuilder zeebeClientBuilder = ZeebeClient.newClientBuilder().usePlaintext().gatewayAddress(contactPoint);
        this.client = zeebeClientBuilder.build();
    }

    @After
    public void after() {
        CloseHelper.closeAll((AutoCloseable[])new AutoCloseable[]{this.client, this.journalReader});
    }

    @Test
    public void shouldTakeSnapshotAtCorrectIndex() {
        this.createSomeEvents();
        this.brokerAdminService.takeSnapshot();
        SnapshotId snapshotId = this.waitForSnapshotAtBroker(this.brokerAdminService, 1);
        long processedIndex = this.journalReader.seekToAsqn(snapshotId.getProcessedPosition());
        long expectedSnapshotIndex = processedIndex - 1L;
        Assertions.assertThat((long)snapshotId.getIndex()).isEqualTo(expectedSnapshotIndex);
    }

    private void createSomeEvents() {
        long lastMessageKey = IntStream.range(0, 10).mapToLong(this::publishMaxMessageSizeMessage).max().getAsLong();
        Awaitility.await().untilAsserted(() -> ((AbstractBooleanAssert)Assertions.assertThat((boolean)((MessageRecordStream)RecordingExporter.messageRecords((MessageIntent)MessageIntent.PUBLISHED).withRecordKey(lastMessageKey)).exists()).describedAs("All records are exported", new Object[0])).isTrue());
    }

    private long publishMaxMessageSizeMessage(int key) {
        return ((PublishMessageResponse)this.client.newPublishMessageCommand().messageName("msg").correlationKey("msg-" + key).send().join()).getMessageKey();
    }

    private SnapshotId waitForSnapshotAtBroker(BrokerAdminService adminService, int partitionId) {
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).untilAsserted(() -> Assertions.assertThat((Long)((PartitionStatus)adminService.getPartitionStatus().get(partitionId)).processedPositionInSnapshot()).isNotNull());
        PartitionStatus partitionStatus = (PartitionStatus)this.brokerAdminService.getPartitionStatus().get(1);
        return (SnapshotId)FileBasedSnapshotId.ofFileName((String)partitionStatus.snapshotId()).get();
    }
}

