/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions;

import io.atomix.primitive.partition.PartitionId;
import io.atomix.raft.RaftRoleChangeListener;
import io.atomix.raft.RaftServer;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.impl.RaftPartitionServer;
import io.camunda.zeebe.broker.system.partitions.PartitionAdminControl;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupAndTransitionContextImpl;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupContext;
import io.camunda.zeebe.broker.system.partitions.PartitionStartupStep;
import io.camunda.zeebe.broker.system.partitions.PartitionTransition;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.ZeebePartition;
import io.camunda.zeebe.broker.system.partitions.ZeebePartitionHealth;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionTransitionImpl;
import io.camunda.zeebe.broker.system.partitions.impl.RecoverablePartitionTransitionException;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.scheduler.health.CriticalComponentsHealthMonitor;
import io.camunda.zeebe.scheduler.testing.ControlledActorSchedulerRule;
import io.camunda.zeebe.util.exception.UnrecoverableException;
import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthIssue;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthReport;
import io.camunda.zeebe.util.health.HealthStatus;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class ZeebePartitionTest {
    @Rule
    public ControlledActorSchedulerRule schedulerRule = new ControlledActorSchedulerRule();
    private PartitionStartupAndTransitionContextImpl ctx;
    private PartitionTransition transition;
    private CriticalComponentsHealthMonitor healthMonitor;
    private RaftPartition raft;
    private ZeebePartition partition;

    @Before
    public void setup() {
        this.ctx = (PartitionStartupAndTransitionContextImpl)Mockito.mock(PartitionStartupAndTransitionContextImpl.class);
        this.transition = (PartitionTransition)Mockito.spy((Object)new PartitionTransitionImpl(List.of(new NoopTransitionStep())));
        this.transition.updateTransitionContext((PartitionTransitionContext)this.ctx);
        this.raft = (RaftPartition)Mockito.mock(RaftPartition.class);
        Mockito.when((Object)this.raft.id()).thenReturn((Object)new PartitionId("", 0));
        Mockito.when((Object)this.raft.getRole()).thenReturn((Object)RaftServer.Role.INACTIVE);
        Mockito.when((Object)this.raft.getServer()).thenReturn((Object)((RaftPartitionServer)Mockito.mock(RaftPartitionServer.class)));
        this.healthMonitor = (CriticalComponentsHealthMonitor)Mockito.mock(CriticalComponentsHealthMonitor.class);
        Mockito.when((Object)this.ctx.getPartitionAdminControl()).thenReturn((Object)((PartitionAdminControl)Mockito.mock(PartitionAdminControl.class)));
        Mockito.when((Object)this.ctx.getRaftPartition()).thenReturn((Object)this.raft);
        Mockito.when((Object)this.ctx.getPartitionContext()).thenReturn((Object)this.ctx);
        Mockito.when((Object)this.ctx.getComponentHealthMonitor()).thenReturn((Object)this.healthMonitor);
        Mockito.when((Object)this.ctx.createTransitionContext()).thenReturn((Object)this.ctx);
        Mockito.when((Object)this.ctx.getPartitionStartupMeterRegistry()).thenReturn((Object)new SimpleMeterRegistry());
        this.partition = new ZeebePartition(this.ctx, this.transition, List.of(new NoopStartupStep()));
    }

    @Test
    public void shouldInstallLeaderPartition() {
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.onNewRole(RaftServer.Role.LEADER, 1L);
        this.schedulerRule.workUntilDone();
        ((PartitionTransition)Mockito.verify((Object)this.transition)).toLeader(1L);
    }

    @Test
    public void shouldNotifyPartitionRaftListenersOnBecomingLeader() {
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.onNewRole(RaftServer.Role.LEADER, 1L);
        this.schedulerRule.workUntilDone();
        ((PartitionStartupAndTransitionContextImpl)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.timeout((long)1000L))).notifyListenersOfBecameRaftLeader(1L);
    }

    @Test
    public void shouldNotifyPartitionRaftListenersOnBecomingFollower() {
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.onNewRole(RaftServer.Role.FOLLOWER, 1L);
        this.schedulerRule.workUntilDone();
        ((PartitionStartupAndTransitionContextImpl)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.timeout((long)1000L))).notifyListenersOfBecameRaftFollower(1L);
    }

    @Test
    public void shouldInstallFollowerPartition() {
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.onNewRole(RaftServer.Role.FOLLOWER, 1L);
        this.schedulerRule.workUntilDone();
        ((PartitionTransition)Mockito.verify((Object)this.transition)).toFollower(1L);
    }

    @Test
    public void shouldUpdateCurrentTermAndRoleAfterTransition() {
        this.schedulerRule.submitActor((Actor)this.partition);
        this.schedulerRule.workUntilDone();
        this.partition.onNewRole(RaftServer.Role.FOLLOWER, 2L);
        this.schedulerRule.workUntilDone();
        ((PartitionStartupAndTransitionContextImpl)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.atLeast((int)1))).setCurrentRole(RaftServer.Role.FOLLOWER);
        ((PartitionStartupAndTransitionContextImpl)Mockito.verify((Object)this.ctx, (VerificationMode)Mockito.atLeast((int)1))).setCurrentTerm(2L);
    }

    @Test
    public void shouldUseCurrentTermForInactiveTransition() {
        this.schedulerRule.submitActor((Actor)this.partition);
        Mockito.when((Object)this.ctx.getCurrentTerm()).thenReturn((Object)3L);
        this.partition.onNewRole(RaftServer.Role.INACTIVE, -1L);
        this.schedulerRule.workUntilDone();
        ((PartitionTransition)Mockito.verify((Object)this.transition, (VerificationMode)Mockito.atLeast((int)1))).toInactive(3L);
    }

    @Test
    public void shouldCallOnFailureOnAddFailureListenerAndUnhealthy() {
        HealthReport report = (HealthReport)Mockito.mock(HealthReport.class);
        Mockito.when((Object)report.getStatus()).thenReturn((Object)HealthStatus.UNHEALTHY);
        Mockito.when((Object)this.healthMonitor.getHealthReport()).thenReturn((Object)report);
        FailureListener failureListener = (FailureListener)Mockito.mock(FailureListener.class);
        ((FailureListener)Mockito.doNothing().when((Object)failureListener)).onFailure((HealthReport)ArgumentMatchers.any());
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.addFailureListener(failureListener);
        this.schedulerRule.workUntilDone();
        ((FailureListener)Mockito.verify((Object)failureListener, (VerificationMode)Mockito.only())).onFailure((HealthReport)ArgumentMatchers.any());
    }

    @Test
    public void shouldCallOnRecoveredOnAddFailureListenerAndHealthy() {
        HealthReport report = (HealthReport)Mockito.mock(HealthReport.class);
        Mockito.when((Object)report.getStatus()).thenReturn((Object)HealthStatus.HEALTHY);
        FailureListener failureListener = (FailureListener)Mockito.mock(FailureListener.class);
        ((FailureListener)Mockito.doNothing().when((Object)failureListener)).onRecovered();
        Mockito.when((Object)this.healthMonitor.getHealthReport()).thenReturn((Object)report);
        this.schedulerRule.submitActor((Actor)this.partition);
        this.schedulerRule.workUntilDone();
        this.partition.addFailureListener(failureListener);
        this.schedulerRule.workUntilDone();
        ((FailureListener)Mockito.verify((Object)failureListener, (VerificationMode)Mockito.only())).onRecovered();
    }

    @Test
    public void shouldStepDownAfterFailedLeaderTransition() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)this.transition.toLeader(ArgumentMatchers.anyLong())).thenReturn((Object)CompletableActorFuture.completedExceptionally((Throwable)new Exception("expected")));
        Mockito.when((Object)this.transition.toFollower(ArgumentMatchers.anyLong())).then(invocation -> {
            latch.countDown();
            return CompletableActorFuture.completed(null);
        });
        Mockito.when((Object)this.raft.getRole()).thenReturn((Object)RaftServer.Role.LEADER);
        Mockito.when((Object)this.raft.term()).thenReturn((Object)1L);
        Mockito.when((Object)this.ctx.getCurrentRole()).thenReturn((Object)RaftServer.Role.LEADER);
        Mockito.when((Object)this.ctx.getCurrentTerm()).thenReturn((Object)1L);
        Mockito.when((Object)this.raft.stepDown()).then(invocation -> {
            this.partition.onNewRole(RaftServer.Role.FOLLOWER, 1L);
            return CompletableFuture.completedFuture(null);
        });
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.onNewRole(RaftServer.Role.LEADER, 1L);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((boolean)latch.await(30L, TimeUnit.SECONDS)).isTrue();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.transition, this.raft});
        ((PartitionTransition)order.verify((Object)this.transition)).toLeader(1L);
        ((RaftPartition)order.verify((Object)this.raft)).stepDown();
        ((PartitionTransition)order.verify((Object)this.transition)).toFollower(1L);
    }

    @Test
    public void shouldNotTriggerTransitionOnPartitionTransitionException() throws InterruptedException {
        Mockito.when((Object)this.transition.toLeader(ArgumentMatchers.anyLong())).thenReturn((Object)CompletableActorFuture.completedExceptionally((Throwable)new RecoverablePartitionTransitionException("something went wrong")));
        Mockito.when((Object)this.raft.getRole()).thenReturn((Object)RaftServer.Role.LEADER);
        Mockito.when((Object)this.raft.term()).thenReturn((Object)2L);
        Mockito.when((Object)this.ctx.getCurrentRole()).thenReturn((Object)RaftServer.Role.FOLLOWER);
        Mockito.when((Object)this.ctx.getCurrentTerm()).thenReturn((Object)1L);
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.onNewRole(RaftServer.Role.LEADER, 2L);
        this.schedulerRule.workUntilDone();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.transition, this.raft});
        ((PartitionTransition)order.verify((Object)this.transition)).toLeader(2L);
        ((RaftPartition)order.verify((Object)this.raft, Mockito.times((int)0))).stop();
        ((PartitionTransition)order.verify((Object)this.transition, Mockito.times((int)0))).toFollower(ArgumentMatchers.anyLong());
    }

    @Test
    public void shouldGoInactiveAfterFailedFollowerTransition() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        Mockito.when((Object)this.transition.toFollower(ArgumentMatchers.anyLong())).thenReturn((Object)CompletableActorFuture.completedExceptionally((Throwable)new Exception("expected")));
        Mockito.when((Object)this.transition.toInactive(ArgumentMatchers.anyLong())).then(invocation -> {
            latch.countDown();
            return CompletableActorFuture.completed(null);
        });
        Mockito.when((Object)this.raft.getRole()).thenReturn((Object)RaftServer.Role.FOLLOWER);
        Mockito.when((Object)this.ctx.getCurrentRole()).thenReturn((Object)RaftServer.Role.FOLLOWER);
        Mockito.when((Object)this.raft.stop()).then(invocation -> CompletableFuture.completedFuture(null));
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.onNewRole(RaftServer.Role.FOLLOWER, 1L);
        this.schedulerRule.workUntilDone();
        Assertions.assertThat((boolean)latch.await(30L, TimeUnit.SECONDS)).isTrue();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.transition, this.raft});
        ((PartitionTransition)order.verify((Object)this.transition)).toFollower(0L);
        ((PartitionTransition)order.verify((Object)this.transition)).toInactive(ArgumentMatchers.anyLong());
        ((RaftPartition)order.verify((Object)this.raft)).stop();
    }

    @Test
    public void shouldStopRaftOnlyAfterTransitioningToInactive() throws InterruptedException {
        CompletableActorFuture inactiveTransitionCompleted = new CompletableActorFuture();
        Mockito.when((Object)this.transition.toFollower(ArgumentMatchers.anyLong())).thenReturn((Object)CompletableActorFuture.completedExceptionally((Throwable)new Exception("expected")));
        Mockito.when((Object)this.transition.toInactive(ArgumentMatchers.anyLong())).then(invocation -> inactiveTransitionCompleted);
        Mockito.when((Object)this.raft.getRole()).thenReturn((Object)RaftServer.Role.FOLLOWER);
        Mockito.when((Object)this.ctx.getCurrentRole()).thenReturn((Object)RaftServer.Role.FOLLOWER);
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.onNewRole(RaftServer.Role.FOLLOWER, 1L);
        this.schedulerRule.workUntilDone();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.transition, this.raft});
        ((PartitionTransition)order.verify((Object)this.transition)).toFollower(0L);
        ((RaftPartition)order.verify((Object)this.raft)).removeRoleChangeListener((RaftRoleChangeListener)this.partition);
        ((PartitionTransition)order.verify((Object)this.transition)).toInactive(ArgumentMatchers.anyLong());
        ((RaftPartition)Mockito.verify((Object)this.raft, (VerificationMode)Mockito.never())).stop();
        inactiveTransitionCompleted.complete(null);
        this.schedulerRule.workUntilDone();
        ((RaftPartition)Mockito.verify((Object)this.raft)).stop();
    }

    @Test
    public void shouldGoInactiveIfTransitionHasUnrecoverableFailure() throws InterruptedException {
        Mockito.when((Object)this.transition.toLeader(ArgumentMatchers.anyLong())).thenReturn((Object)CompletableActorFuture.completedExceptionally((Throwable)new UnrecoverableException("expected")));
        Mockito.when((Object)this.raft.getRole()).thenReturn((Object)RaftServer.Role.LEADER);
        Mockito.when((Object)this.raft.term()).thenReturn((Object)1L);
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.onNewRole(this.raft.getRole(), this.raft.term());
        this.schedulerRule.workUntilDone();
        InOrder order = Mockito.inOrder((Object[])new Object[]{this.transition, this.raft});
        ((PartitionTransition)order.verify((Object)this.transition)).toLeader(0L);
        ((RaftPartition)order.verify((Object)this.raft)).stop();
    }

    @Test
    public void shouldCloseZeebePartitionWhileOngoingTransition() {
        PartitionTransitionStep mockTransitionStep = (PartitionTransitionStep)Mockito.mock(PartitionTransitionStep.class);
        CompletableActorFuture firstTransitionFuture = new CompletableActorFuture();
        CompletableActorFuture secondTransitionFuture = new CompletableActorFuture();
        Mockito.when((Object)mockTransitionStep.transitionTo((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any(RaftServer.Role.class))).thenReturn((Object)firstTransitionFuture).thenReturn((Object)secondTransitionFuture).thenReturn((Object)CompletableActorFuture.completed(null));
        Mockito.when((Object)mockTransitionStep.prepareTransition((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any(RaftServer.Role.class))).thenReturn((Object)CompletableActorFuture.completed(null));
        this.transition = (PartitionTransition)Mockito.spy((Object)new PartitionTransitionImpl(List.of(mockTransitionStep, new NoopTransitionStep())));
        this.partition = new ZeebePartition(this.ctx, this.transition, List.of(new NoopStartupStep()));
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.onNewRole(RaftServer.Role.LEADER, 1L);
        this.schedulerRule.workUntilDone();
        ActorFuture closeFuture = this.partition.closeAsync();
        this.schedulerRule.workUntilDone();
        this.partition.onNewRole(RaftServer.Role.FOLLOWER, 2L);
        this.schedulerRule.workUntilDone();
        firstTransitionFuture.complete(null);
        secondTransitionFuture.complete(null);
        this.schedulerRule.workUntilDone();
        Awaitility.await().until(() -> closeFuture.isDone());
    }

    @Test
    public void shouldReportUnhealthyIfTransitionStepIsStuck() {
        PartitionTransitionStep transitionStep = (PartitionTransitionStep)Mockito.mock(PartitionTransitionStep.class);
        PartitionTransitionImpl transition = new PartitionTransitionImpl(List.of(transitionStep));
        ZeebePartition partition = new ZeebePartition(this.ctx, (PartitionTransition)transition, List.of(new NoopStartupStep()));
        this.schedulerRule.submitActor((Actor)partition);
        Mockito.when((Object)transitionStep.prepareTransition((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)CompletableActorFuture.completed(null));
        Mockito.when((Object)transitionStep.transitionTo((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)CompletableActorFuture.completed(null));
        Mockito.when((Object)this.ctx.getCurrentRole()).thenReturn((Object)RaftServer.Role.FOLLOWER);
        partition.onNewRole(RaftServer.Role.FOLLOWER, 0L);
        this.schedulerRule.workUntilDone();
        this.schedulerRule.getClock().addTime(Duration.ofMinutes(-2L));
        Mockito.when((Object)transitionStep.transitionTo((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)new CompletableActorFuture());
        partition.onNewRole(RaftServer.Role.LEADER, 1L);
        this.schedulerRule.workUntilDone();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ZeebePartitionHealth.class);
        ((CriticalComponentsHealthMonitor)Mockito.verify((Object)this.healthMonitor)).registerComponent((String)ArgumentMatchers.any(), (HealthMonitorable)captor.capture());
        HealthReport healthReport = ((ZeebePartitionHealth)captor.getValue()).getHealthReport();
        Assertions.assertThat((Comparable)healthReport.getStatus()).isEqualTo((Object)HealthStatus.UNHEALTHY);
        Assertions.assertThat((String)healthReport.getIssue().message()).contains(new CharSequence[]{"Transition from FOLLOWER on term 0 appears blocked"});
    }

    @Test
    public void shouldReportUnhealthyPerDefault() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(ZeebePartitionHealth.class);
        this.schedulerRule.submitActor((Actor)this.partition);
        this.schedulerRule.workUntilDone();
        ((CriticalComponentsHealthMonitor)Mockito.verify((Object)this.healthMonitor)).registerComponent((String)ArgumentMatchers.any(), (HealthMonitorable)captor.capture());
        ZeebePartitionHealth zeebePartitionHealth = (ZeebePartitionHealth)captor.getValue();
        HealthReport healthReport = zeebePartitionHealth.getHealthReport();
        Assertions.assertThat((Comparable)healthReport.getStatus()).isEqualTo((Object)HealthStatus.UNHEALTHY);
        Assertions.assertThat((String)healthReport.getIssue().message()).contains(new CharSequence[]{"Services not installed"});
    }

    @Test
    public void shouldCallOnFailureOnceForSameHealthIssue() {
        this.schedulerRule.submitActor((Actor)this.partition);
        this.schedulerRule.workUntilDone();
        FailureListener failureListener = (FailureListener)Mockito.mock(FailureListener.class);
        ((FailureListener)Mockito.doNothing().when((Object)failureListener)).onFailure((HealthReport)ArgumentMatchers.any());
        ArgumentCaptor captor = ArgumentCaptor.forClass(ZeebePartitionHealth.class);
        ((CriticalComponentsHealthMonitor)Mockito.verify((Object)this.healthMonitor)).registerComponent((String)ArgumentMatchers.any(), (HealthMonitorable)captor.capture());
        ZeebePartitionHealth zeebePartitionHealth = (ZeebePartitionHealth)captor.getValue();
        zeebePartitionHealth.addFailureListener(failureListener);
        Mockito.when((Object)this.transition.getHealthIssue()).thenReturn((Object)HealthIssue.of((String)"it's over"));
        HealthReport healthReport1 = zeebePartitionHealth.getHealthReport();
        Assertions.assertThat((Comparable)healthReport1.getStatus()).isEqualTo((Object)HealthStatus.UNHEALTHY);
        HealthReport healthReport2 = zeebePartitionHealth.getHealthReport();
        Assertions.assertThat((Object)healthReport1).isEqualTo((Object)healthReport2);
        ((FailureListener)Mockito.verify((Object)failureListener, (VerificationMode)Mockito.times((int)1))).onFailure((HealthReport)ArgumentMatchers.any());
    }

    @Test
    public void shouldCallOnFailureOnHealthIssueChange() {
        this.schedulerRule.submitActor((Actor)this.partition);
        this.schedulerRule.workUntilDone();
        FailureListener failureListener = (FailureListener)Mockito.mock(FailureListener.class);
        ((FailureListener)Mockito.doNothing().when((Object)failureListener)).onFailure((HealthReport)ArgumentMatchers.any());
        ArgumentCaptor captor = ArgumentCaptor.forClass(ZeebePartitionHealth.class);
        ((CriticalComponentsHealthMonitor)Mockito.verify((Object)this.healthMonitor)).registerComponent((String)ArgumentMatchers.any(), (HealthMonitorable)captor.capture());
        ZeebePartitionHealth zeebePartitionHealth = (ZeebePartitionHealth)captor.getValue();
        zeebePartitionHealth.addFailureListener(failureListener);
        Mockito.when((Object)this.transition.getHealthIssue()).thenReturn((Object)HealthIssue.of((String)"it's over"));
        HealthReport healthReport1 = zeebePartitionHealth.getHealthReport();
        Assertions.assertThat((Comparable)healthReport1.getStatus()).isEqualTo((Object)HealthStatus.UNHEALTHY);
        Mockito.when((Object)this.transition.getHealthIssue()).thenReturn((Object)HealthIssue.of((String)"it's something else"));
        HealthReport healthReport2 = zeebePartitionHealth.getHealthReport();
        Assertions.assertThat((Comparable)healthReport2.getStatus()).isEqualTo((Object)HealthStatus.UNHEALTHY);
        Assertions.assertThat((Object)healthReport1).isNotEqualTo((Object)healthReport2);
        ((FailureListener)Mockito.verify((Object)failureListener, (VerificationMode)Mockito.times((int)2))).onFailure((HealthReport)ArgumentMatchers.any());
    }

    @Test
    public void shouldCallOnRecoveredOnceWhenHealthy() {
        this.schedulerRule.submitActor((Actor)this.partition);
        this.schedulerRule.workUntilDone();
        FailureListener failureListener = (FailureListener)Mockito.mock(FailureListener.class);
        ((FailureListener)Mockito.doNothing().when((Object)failureListener)).onFailure((HealthReport)ArgumentMatchers.any());
        ((FailureListener)Mockito.doNothing().when((Object)failureListener)).onRecovered();
        ArgumentCaptor captor = ArgumentCaptor.forClass(ZeebePartitionHealth.class);
        ((CriticalComponentsHealthMonitor)Mockito.verify((Object)this.healthMonitor)).registerComponent((String)ArgumentMatchers.any(), (HealthMonitorable)captor.capture());
        ZeebePartitionHealth zeebePartitionHealth = (ZeebePartitionHealth)captor.getValue();
        zeebePartitionHealth.addFailureListener(failureListener);
        this.partition.onNewRole(RaftServer.Role.LEADER, 1L);
        this.schedulerRule.workUntilDone();
        HealthReport healthReport1 = zeebePartitionHealth.getHealthReport();
        Assertions.assertThat((Comparable)healthReport1.getStatus()).isEqualTo((Object)HealthStatus.HEALTHY);
        HealthReport healthReport2 = zeebePartitionHealth.getHealthReport();
        Assertions.assertThat((Comparable)healthReport2.getStatus()).isEqualTo((Object)HealthStatus.HEALTHY);
        Assertions.assertThat((Object)healthReport1).isEqualTo((Object)healthReport2);
        ((FailureListener)Mockito.verify((Object)failureListener, (VerificationMode)Mockito.times((int)1))).onRecovered();
    }

    @Test
    public void shouldReportHealthyAfterTransition() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(ZeebePartitionHealth.class);
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.onNewRole(RaftServer.Role.LEADER, 1L);
        this.schedulerRule.workUntilDone();
        ((CriticalComponentsHealthMonitor)Mockito.verify((Object)this.healthMonitor)).registerComponent((String)ArgumentMatchers.any(), (HealthMonitorable)captor.capture());
        ZeebePartitionHealth zeebePartitionHealth = (ZeebePartitionHealth)captor.getValue();
        HealthReport healthReport = zeebePartitionHealth.getHealthReport();
        Assertions.assertThat((Comparable)healthReport.getStatus()).isEqualTo((Object)HealthStatus.HEALTHY);
    }

    @Test
    public void shouldReportUnhealthyWhenNoDiskAvailable() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(ZeebePartitionHealth.class);
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.onNewRole(RaftServer.Role.LEADER, 1L);
        this.schedulerRule.workUntilDone();
        this.partition.onDiskSpaceNotAvailable();
        this.schedulerRule.workUntilDone();
        ((CriticalComponentsHealthMonitor)Mockito.verify((Object)this.healthMonitor)).registerComponent((String)ArgumentMatchers.any(), (HealthMonitorable)captor.capture());
        ZeebePartitionHealth zeebePartitionHealth = (ZeebePartitionHealth)captor.getValue();
        HealthReport healthReport = zeebePartitionHealth.getHealthReport();
        Assertions.assertThat((Comparable)healthReport.getStatus()).isEqualTo((Object)HealthStatus.UNHEALTHY);
        Assertions.assertThat((String)healthReport.getIssue().message()).contains(new CharSequence[]{"Not enough disk space available"});
    }

    @Test
    public void shouldReportHealthyWhenDiskIsAvailableAgain() {
        ArgumentCaptor captor = ArgumentCaptor.forClass(ZeebePartitionHealth.class);
        this.schedulerRule.submitActor((Actor)this.partition);
        this.partition.onNewRole(RaftServer.Role.LEADER, 1L);
        this.partition.onDiskSpaceNotAvailable();
        this.schedulerRule.workUntilDone();
        this.partition.onDiskSpaceAvailable();
        this.schedulerRule.workUntilDone();
        ((CriticalComponentsHealthMonitor)Mockito.verify((Object)this.healthMonitor)).registerComponent((String)ArgumentMatchers.any(), (HealthMonitorable)captor.capture());
        ZeebePartitionHealth zeebePartitionHealth = (ZeebePartitionHealth)captor.getValue();
        HealthReport healthReport = zeebePartitionHealth.getHealthReport();
        Assertions.assertThat((Comparable)healthReport.getStatus()).isEqualTo((Object)HealthStatus.HEALTHY);
        Assertions.assertThat((Object)healthReport.getIssue()).isNull();
    }

    @Test
    public void shouldBeAbleToGetHealthReportFromClosedPartition() {
        HealthReport healthReport = (HealthReport)Mockito.mock(HealthReport.class);
        Mockito.when((Object)this.healthMonitor.getHealthReport()).thenReturn((Object)healthReport);
        this.schedulerRule.submitActor((Actor)this.partition);
        ActorFuture closeFuture = this.partition.closeAsync();
        this.schedulerRule.workUntilDone();
        Awaitility.await().until(() -> closeFuture.isDone());
        Assertions.assertThat((Object)this.partition.getHealthReport()).isEqualTo((Object)healthReport);
    }

    private static final class NoopTransitionStep
    implements PartitionTransitionStep {
        private NoopTransitionStep() {
        }

        public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
            return CompletableActorFuture.completed(null);
        }

        public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
            return CompletableActorFuture.completed(null);
        }

        public String getName() {
            return "noop-transition-step";
        }
    }

    private static final class NoopStartupStep
    implements PartitionStartupStep {
        private NoopStartupStep() {
        }

        public String getName() {
            return "noop";
        }

        public ActorFuture<PartitionStartupContext> startup(PartitionStartupContext partitionStartupContext) {
            return CompletableActorFuture.completed((Object)partitionStartupContext);
        }

        public ActorFuture<PartitionStartupContext> shutdown(PartitionStartupContext partitionStartupContext) {
            return CompletableActorFuture.completed((Object)partitionStartupContext);
        }
    }
}

