/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.atomix.raft.partition.RaftPartition;
import io.camunda.zeebe.broker.exporter.stream.ExporterPhase;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionProcessingState;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.assertj.core.api.AbstractFileAssert;
import org.assertj.core.api.AssertionsForClassTypes;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class PartitionProcessingStateTest {
    private static final RaftPartition MOCK_RAFT_PARTITION = (RaftPartition)Mockito.mock(RaftPartition.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    private static final String PERSISTED_PROCESSOR_PAUSE_STATE_FILENAME = ".processorPaused";
    private static final String PERSISTED_EXPORTER_PAUSE_STATE_FILENAME = ".exporterPaused";
    @TempDir
    private Path testDir;

    PartitionProcessingStateTest() {
    }

    @BeforeEach
    void setUp() {
        Mockito.when((Object)MOCK_RAFT_PARTITION.dataDirectory().toPath()).thenReturn((Object)this.testDir);
    }

    @Test
    void shouldPauseAndResumeProcessing() throws IOException {
        PartitionProcessingState partitionProcessingState = new PartitionProcessingState(MOCK_RAFT_PARTITION);
        File persistedProcessorPauseState = this.testDir.resolve(PERSISTED_PROCESSOR_PAUSE_STATE_FILENAME).toFile();
        partitionProcessingState.pauseProcessing();
        ((AbstractFileAssert)AssertionsForClassTypes.assertThat((File)persistedProcessorPauseState).describedAs("Processor State file exists.", new Object[0])).exists();
        Assertions.assertTrue((boolean)partitionProcessingState.isProcessingPaused());
        partitionProcessingState.resumeProcessing();
        ((AbstractFileAssert)AssertionsForClassTypes.assertThat((File)persistedProcessorPauseState).describedAs("Processor State file does not exist.", new Object[0])).doesNotExist();
        Assertions.assertFalse((boolean)partitionProcessingState.isProcessingPaused());
    }

    @Test
    void shouldPauseAndResumeExporting() {
        PartitionProcessingState partitionProcessingState = new PartitionProcessingState(MOCK_RAFT_PARTITION);
        partitionProcessingState.pauseExporting();
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)partitionProcessingState.getExporterPhase()).describedAs("Exporting must be paused.", new Object[0])).isEqualTo((Object)ExporterPhase.PAUSED);
        partitionProcessingState.resumeExporting();
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)partitionProcessingState.getExporterPhase()).describedAs("Exporting must be resumed.", new Object[0])).isEqualTo((Object)ExporterPhase.EXPORTING);
    }

    @Test
    void shouldSoftPauseAndResumeExporter() {
        PartitionProcessingState partitionProcessingState = new PartitionProcessingState(MOCK_RAFT_PARTITION);
        partitionProcessingState.softPauseExporting();
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)partitionProcessingState.getExporterPhase()).describedAs("Exporting must be soft paused.", new Object[0])).isEqualTo((Object)ExporterPhase.SOFT_PAUSED);
        partitionProcessingState.resumeExporting();
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)partitionProcessingState.getExporterPhase()).describedAs("Exporting must be resumed.", new Object[0])).isEqualTo((Object)ExporterPhase.EXPORTING);
    }

    @Test
    void shouldOverwriteExporterStates() {
        PartitionProcessingState partitionProcessingState = new PartitionProcessingState(MOCK_RAFT_PARTITION);
        partitionProcessingState.pauseExporting();
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)partitionProcessingState.getExporterPhase()).describedAs("Exporting must be paused.", new Object[0])).isEqualTo((Object)ExporterPhase.PAUSED);
        partitionProcessingState.softPauseExporting();
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)partitionProcessingState.getExporterPhase()).describedAs("Exporting must be soft paused.", new Object[0])).isEqualTo((Object)ExporterPhase.SOFT_PAUSED);
        partitionProcessingState.resumeExporting();
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)partitionProcessingState.getExporterPhase()).describedAs("Exporting must be resumed.", new Object[0])).isEqualTo((Object)ExporterPhase.EXPORTING);
    }

    @Test
    void shouldAssureBackwardCompatibility() throws IOException {
        File persistedExporterPauseState = this.testDir.resolve(PERSISTED_EXPORTER_PAUSE_STATE_FILENAME).toFile();
        persistedExporterPauseState.createNewFile();
        PartitionProcessingState partitionProcessingState = new PartitionProcessingState(MOCK_RAFT_PARTITION);
        ((ObjectAssert)AssertionsForClassTypes.assertThat((Object)partitionProcessingState.getExporterPhase()).describedAs("Exporting must be paused.", new Object[0])).isEqualTo((Object)ExporterPhase.PAUSED);
    }
}

