/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransition;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionTransitionImpl;
import io.camunda.zeebe.broker.system.partitions.impl.steps.StreamProcessorTransitionStep;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.TestConcurrencyControl;
import io.camunda.zeebe.stream.impl.StreamProcessor;
import io.camunda.zeebe.util.health.HealthMonitor;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PartitionTransitionImplTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionTransitionImplTest.class);
    private static final TestConcurrencyControl TEST_CONCURRENCY_CONTROL = new TestConcurrencyControl();
    private static final long DEFAULT_TERM = 1L;
    private static final RaftServer.Role DEFAULT_ROLE = RaftServer.Role.LEADER;
    private PartitionTransitionStep mockStep1;
    private PartitionTransitionStep mockStep2;
    private PartitionTransitionContext mockContext;

    PartitionTransitionImplTest() {
    }

    @BeforeEach
    void setUp() {
        this.mockStep1 = (PartitionTransitionStep)Mockito.mock(PartitionTransitionStep.class);
        this.mockStep2 = (PartitionTransitionStep)Mockito.mock(PartitionTransitionStep.class);
        Mockito.when((Object)this.mockStep1.getName()).thenReturn((Object)"Step 1");
        Mockito.when((Object)this.mockStep2.getName()).thenReturn((Object)"Step 2");
        this.mockContext = (PartitionTransitionContext)Mockito.mock(PartitionTransitionContext.class);
    }

    @Test
    void shouldCallTransitionStepsInOrder() {
        Mockito.when((Object)this.mockStep1.transitionTo(this.mockContext, 1L, DEFAULT_ROLE)).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        Mockito.when((Object)this.mockStep2.transitionTo(this.mockContext, 1L, DEFAULT_ROLE)).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        PartitionTransitionImpl sut = new PartitionTransitionImpl(List.of(this.mockStep1, this.mockStep2));
        sut.setConcurrencyControl((ConcurrencyControl)TEST_CONCURRENCY_CONTROL);
        sut.updateTransitionContext(this.mockContext);
        sut.transitionTo(1L, DEFAULT_ROLE).join();
        InOrder invocationRecorder = Mockito.inOrder((Object[])new Object[]{this.mockStep1, this.mockStep2});
        ((PartitionTransitionStep)invocationRecorder.verify((Object)this.mockStep1)).onNewRaftRole(this.mockContext, DEFAULT_ROLE);
        ((PartitionTransitionStep)invocationRecorder.verify((Object)this.mockStep2)).onNewRaftRole(this.mockContext, DEFAULT_ROLE);
        ((PartitionTransitionStep)invocationRecorder.verify((Object)this.mockStep1)).transitionTo(this.mockContext, 1L, DEFAULT_ROLE);
        ((PartitionTransitionStep)invocationRecorder.verify((Object)this.mockStep2)).transitionTo(this.mockContext, 1L, DEFAULT_ROLE);
    }

    @Test
    void shouldAbortTransitionIfOneStepThrowsAnException() {
        Exception testException = new Exception("TEST_EXCEPTION");
        Mockito.when((Object)this.mockStep1.transitionTo(this.mockContext, 1L, DEFAULT_ROLE)).thenReturn((Object)TEST_CONCURRENCY_CONTROL.failedFuture((Throwable)testException));
        Mockito.when((Object)this.mockStep2.transitionTo(this.mockContext, 1L, DEFAULT_ROLE)).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        PartitionTransitionImpl sut = new PartitionTransitionImpl(List.of(this.mockStep1, this.mockStep2));
        sut.setConcurrencyControl((ConcurrencyControl)TEST_CONCURRENCY_CONTROL);
        sut.updateTransitionContext(this.mockContext);
        ActorFuture actualResult = sut.transitionTo(1L, DEFAULT_ROLE);
        ((PartitionTransitionStep)Mockito.verify((Object)this.mockStep2, (VerificationMode)Mockito.never())).transitionTo(this.mockContext, 1L, DEFAULT_ROLE);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ActorFuture)actualResult).join()).isInstanceOf(ExecutionException.class)).cause().isSameAs((Object)testException);
    }

    @Test
    void shouldAbortOngoingTransitionWhenNewTransitionIsRequested() {
        WaitingTransitionStep step1 = new WaitingTransitionStep(this, (ConcurrencyControl)TEST_CONCURRENCY_CONTROL);
        WaitingTransitionStep spyStep1 = (WaitingTransitionStep)Mockito.spy((Object)step1);
        Mockito.when((Object)this.mockStep2.transitionTo((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        Mockito.when((Object)this.mockStep2.prepareTransition((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        PartitionTransitionImpl sut = new PartitionTransitionImpl(List.of(spyStep1, this.mockStep2));
        sut.setConcurrencyControl((ConcurrencyControl)TEST_CONCURRENCY_CONTROL);
        sut.updateTransitionContext(this.mockContext);
        long secondTerm = 2L;
        RaftServer.Role secondRole = RaftServer.Role.FOLLOWER;
        ActorFuture firstTransitionFuture = sut.transitionTo(1L, DEFAULT_ROLE);
        ActorFuture secondTransitionFuture = sut.transitionTo(2L, secondRole);
        spyStep1.unblock();
        Awaitility.await().until(() -> firstTransitionFuture.isDone());
        Awaitility.await().until(() -> secondTransitionFuture.isDone());
        Assertions.assertThat((boolean)firstTransitionFuture.isCompletedExceptionally()).isTrue();
        Assertions.assertThat((Throwable)firstTransitionFuture.getException()).isInstanceOf(PartitionTransition.CancelledPartitionTransition.class);
        Assertions.assertThat((boolean)secondTransitionFuture.isCompletedExceptionally()).isFalse();
        ((PartitionTransitionStep)Mockito.verify((Object)this.mockStep2)).prepareTransition(this.mockContext, 2L, secondRole);
        ((PartitionTransitionStep)Mockito.verify((Object)this.mockStep2, (VerificationMode)Mockito.never())).transitionTo(this.mockContext, 1L, DEFAULT_ROLE);
        InOrder invocationRecorder = Mockito.inOrder((Object[])new Object[]{spyStep1, this.mockStep2});
        ((WaitingTransitionStep)invocationRecorder.verify((Object)spyStep1)).onNewRaftRole(this.mockContext, DEFAULT_ROLE);
        ((PartitionTransitionStep)invocationRecorder.verify((Object)this.mockStep2)).onNewRaftRole(this.mockContext, DEFAULT_ROLE);
        ((WaitingTransitionStep)invocationRecorder.verify((Object)spyStep1)).transitionTo(this.mockContext, 1L, DEFAULT_ROLE);
        ((WaitingTransitionStep)invocationRecorder.verify((Object)spyStep1)).onNewRaftRole(this.mockContext, secondRole);
        ((PartitionTransitionStep)invocationRecorder.verify((Object)this.mockStep2)).onNewRaftRole(this.mockContext, secondRole);
        ((WaitingTransitionStep)invocationRecorder.verify((Object)spyStep1)).prepareTransition(this.mockContext, 2L, secondRole);
        ((WaitingTransitionStep)invocationRecorder.verify((Object)spyStep1)).transitionTo(this.mockContext, 2L, secondRole);
        ((PartitionTransitionStep)invocationRecorder.verify((Object)this.mockStep2)).transitionTo(this.mockContext, 2L, secondRole);
    }

    @Test
    void shouldNotStartMultipleTransitions() {
        ActorFuture firstStepFirstTransitionFuture = TEST_CONCURRENCY_CONTROL.createFuture();
        ActorFuture firstStepSecondTransitionFuture = TEST_CONCURRENCY_CONTROL.createFuture();
        ActorFuture firstStepThirdTransitionFuture = TEST_CONCURRENCY_CONTROL.createFuture();
        Mockito.when((Object)this.mockStep1.transitionTo((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)firstStepFirstTransitionFuture).thenReturn((Object)firstStepSecondTransitionFuture).thenReturn((Object)firstStepThirdTransitionFuture);
        Mockito.when((Object)this.mockStep1.prepareTransition((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        PartitionTransitionImpl transition = new PartitionTransitionImpl(List.of(this.mockStep1));
        transition.setConcurrencyControl((ConcurrencyControl)TEST_CONCURRENCY_CONTROL);
        transition.updateTransitionContext(this.mockContext);
        ActorFuture firstTransitionFuture = transition.transitionTo(1L, RaftServer.Role.FOLLOWER);
        transition.transitionTo(2L, RaftServer.Role.LEADER);
        transition.transitionTo(2L, RaftServer.Role.FOLLOWER);
        firstStepFirstTransitionFuture.complete(null);
        Awaitility.await().until(() -> firstTransitionFuture.isDone());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockStep1});
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1)).onNewRaftRole(this.mockContext, RaftServer.Role.FOLLOWER);
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1)).transitionTo(this.mockContext, 1L, RaftServer.Role.FOLLOWER);
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1)).onNewRaftRole(this.mockContext, RaftServer.Role.LEADER);
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1)).onNewRaftRole(this.mockContext, RaftServer.Role.FOLLOWER);
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1)).prepareTransition(this.mockContext, 2L, RaftServer.Role.LEADER);
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1, Mockito.never())).transitionTo(this.mockContext, 2L, RaftServer.Role.LEADER);
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1)).transitionTo(this.mockContext, 2L, RaftServer.Role.FOLLOWER);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldExecuteTransitionsInOrder() {
        ActorFuture firstStepFirstTransitionFuture = TEST_CONCURRENCY_CONTROL.createFuture();
        ActorFuture firstStepSecondTransitionFuture = TEST_CONCURRENCY_CONTROL.createFuture();
        ActorFuture firstStepThirdTransitionFuture = TEST_CONCURRENCY_CONTROL.createFuture();
        Mockito.when((Object)this.mockStep1.transitionTo((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)firstStepFirstTransitionFuture).thenReturn((Object)firstStepSecondTransitionFuture).thenReturn((Object)firstStepThirdTransitionFuture);
        Mockito.when((Object)this.mockStep1.prepareTransition((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        PartitionTransitionImpl transition = new PartitionTransitionImpl(List.of(this.mockStep1));
        transition.setConcurrencyControl((ConcurrencyControl)TEST_CONCURRENCY_CONTROL);
        transition.updateTransitionContext(this.mockContext);
        transition.transitionTo(1L, RaftServer.Role.FOLLOWER);
        transition.transitionTo(2L, RaftServer.Role.LEADER);
        ActorFuture lastTransitionFuture = transition.transitionTo(2L, RaftServer.Role.FOLLOWER);
        firstStepFirstTransitionFuture.complete(null);
        firstStepSecondTransitionFuture.complete(null);
        firstStepThirdTransitionFuture.complete(null);
        Awaitility.await().until(() -> lastTransitionFuture.isDone());
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockStep1});
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1)).onNewRaftRole(this.mockContext, RaftServer.Role.FOLLOWER);
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1)).transitionTo(this.mockContext, 1L, RaftServer.Role.FOLLOWER);
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1)).onNewRaftRole(this.mockContext, RaftServer.Role.LEADER);
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1)).onNewRaftRole(this.mockContext, RaftServer.Role.FOLLOWER);
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1)).prepareTransition(this.mockContext, 2L, RaftServer.Role.LEADER);
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1, Mockito.never())).transitionTo(this.mockContext, 2L, RaftServer.Role.LEADER);
        ((PartitionTransitionStep)inOrder.verify((Object)this.mockStep1)).transitionTo(this.mockContext, 2L, RaftServer.Role.FOLLOWER);
        inOrder.verifyNoMoreInteractions();
    }

    @Test
    void shouldCallTransitionStepsInReverseOrderDuringPreparationForTransitionPhase() {
        Mockito.when((Object)this.mockStep1.transitionTo((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        Mockito.when((Object)this.mockStep1.prepareTransition((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        Mockito.when((Object)this.mockStep2.transitionTo((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        Mockito.when((Object)this.mockStep2.prepareTransition((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        PartitionTransitionImpl sut = new PartitionTransitionImpl(List.of(this.mockStep1, this.mockStep2));
        sut.setConcurrencyControl((ConcurrencyControl)TEST_CONCURRENCY_CONTROL);
        sut.updateTransitionContext(this.mockContext);
        long secondTerm = 2L;
        RaftServer.Role secondRole = RaftServer.Role.FOLLOWER;
        sut.transitionTo(1L, DEFAULT_ROLE).join();
        sut.transitionTo(2L, secondRole).join();
        InOrder invocationRecorder = Mockito.inOrder((Object[])new Object[]{this.mockStep1, this.mockStep2});
        ((PartitionTransitionStep)invocationRecorder.verify((Object)this.mockStep2)).transitionTo(this.mockContext, 1L, DEFAULT_ROLE);
        ((PartitionTransitionStep)invocationRecorder.verify((Object)this.mockStep2)).prepareTransition(this.mockContext, 2L, secondRole);
        ((PartitionTransitionStep)invocationRecorder.verify((Object)this.mockStep1)).prepareTransition(this.mockContext, 2L, secondRole);
        ((PartitionTransitionStep)invocationRecorder.verify((Object)this.mockStep1)).transitionTo(this.mockContext, 2L, secondRole);
    }

    @Test
    void shouldAbortTransitionIfOneStepThrowsAnExceptionDuringPreparationPhase() {
        long secondTerm = 2L;
        RaftServer.Role secondRole = RaftServer.Role.FOLLOWER;
        Exception testException = new Exception("TEST_EXCEPTION");
        Mockito.when((Object)this.mockStep1.transitionTo((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        Mockito.when((Object)this.mockStep1.prepareTransition(this.mockContext, 2L, secondRole)).thenReturn((Object)TEST_CONCURRENCY_CONTROL.failedFuture((Throwable)testException));
        Mockito.when((Object)this.mockStep2.transitionTo((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        Mockito.when((Object)this.mockStep2.prepareTransition((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.completedFuture(null));
        PartitionTransitionImpl sut = new PartitionTransitionImpl(List.of(this.mockStep1, this.mockStep2));
        sut.setConcurrencyControl((ConcurrencyControl)TEST_CONCURRENCY_CONTROL);
        sut.updateTransitionContext(this.mockContext);
        ActorFuture firstTransitionFuture = sut.transitionTo(1L, DEFAULT_ROLE);
        ActorFuture secondTransitionFuture = sut.transitionTo(2L, secondRole);
        Assertions.assertThat((boolean)firstTransitionFuture.isCompletedExceptionally()).isFalse();
        ((PartitionTransitionStep)Mockito.verify((Object)this.mockStep1, (VerificationMode)Mockito.never())).transitionTo(this.mockContext, 2L, secondRole);
        ((PartitionTransitionStep)Mockito.verify((Object)this.mockStep2, (VerificationMode)Mockito.never())).transitionTo(this.mockContext, 2L, secondRole);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> ((ActorFuture)secondTransitionFuture).join()).isInstanceOf(ExecutionException.class)).rootCause().isSameAs((Object)testException);
    }

    @Test
    void shouldCloseAllCreatedInstancesOfStreamProcessor() {
        Mockito.when((Object)this.mockContext.getComponentHealthMonitor()).thenReturn((Object)((HealthMonitor)Mockito.mock(HealthMonitor.class)));
        Mockito.when((Object)this.mockContext.getConcurrencyControl()).thenReturn((Object)TEST_CONCURRENCY_CONTROL);
        StreamProcessor mockStreamProcessor1 = (StreamProcessor)Mockito.mock(StreamProcessor.class);
        Mockito.when((Object)mockStreamProcessor1.openAsync(ArgumentMatchers.anyBoolean())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.createCompletedFuture());
        Mockito.when((Object)mockStreamProcessor1.closeAsync()).thenReturn((Object)TEST_CONCURRENCY_CONTROL.createCompletedFuture());
        StreamProcessor mockStreamProcessor2 = (StreamProcessor)Mockito.mock(StreamProcessor.class);
        Mockito.when((Object)mockStreamProcessor2.openAsync(ArgumentMatchers.anyBoolean())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.createCompletedFuture());
        Mockito.when((Object)mockStreamProcessor2.closeAsync()).thenReturn((Object)TEST_CONCURRENCY_CONTROL.createCompletedFuture());
        BiFunction creator = (BiFunction)Mockito.mock(BiFunction.class);
        Mockito.when((Object)((StreamProcessor)creator.apply((PartitionTransitionContext)ArgumentMatchers.any(), (RaftServer.Role)ArgumentMatchers.any()))).thenReturn((Object)mockStreamProcessor1, (Object[])new StreamProcessor[]{mockStreamProcessor2});
        ((PartitionTransitionContext)Mockito.doAnswer(answer -> Mockito.when((Object)this.mockContext.getStreamProcessor()).thenReturn((Object)((StreamProcessor)answer.getArguments()[0]))).when((Object)this.mockContext)).setStreamProcessor((StreamProcessor)ArgumentMatchers.any());
        PartitionTransitionStep mockStepBefore = this.mockStep1;
        Mockito.when((Object)mockStepBefore.prepareTransition((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.createCompletedFuture());
        StreamProcessorTransitionStep streamProcessorStep = new StreamProcessorTransitionStep(creator);
        PartitionTransitionStep mockStepAfter = this.mockStep2;
        Mockito.when((Object)mockStepAfter.prepareTransition((PartitionTransitionContext)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), (RaftServer.Role)ArgumentMatchers.any())).thenReturn((Object)TEST_CONCURRENCY_CONTROL.createCompletedFuture());
        PartitionTransitionImpl sut = new PartitionTransitionImpl(List.of(mockStepBefore, streamProcessorStep, mockStepAfter));
        sut.setConcurrencyControl((ConcurrencyControl)TEST_CONCURRENCY_CONTROL);
        sut.updateTransitionContext(this.mockContext);
        Mockito.when((Object)mockStepBefore.transitionTo(this.mockContext, 1L, RaftServer.Role.FOLLOWER)).thenReturn((Object)TEST_CONCURRENCY_CONTROL.createCompletedFuture());
        Mockito.when((Object)mockStepAfter.transitionTo(this.mockContext, 1L, RaftServer.Role.FOLLOWER)).thenReturn((Object)TEST_CONCURRENCY_CONTROL.createCompletedFuture());
        ActorFuture transition1Future = sut.transitionTo(1L, RaftServer.Role.FOLLOWER);
        transition1Future.join();
        ActorFuture testFutureOfFirstStepInSecondTransition = TEST_CONCURRENCY_CONTROL.createFuture();
        Mockito.when((Object)mockStepBefore.transitionTo(this.mockContext, 1L, RaftServer.Role.CANDIDATE)).thenReturn((Object)testFutureOfFirstStepInSecondTransition);
        ActorFuture transition2Future = sut.transitionTo(1L, RaftServer.Role.CANDIDATE);
        Mockito.when((Object)mockStepBefore.transitionTo(this.mockContext, 1L, RaftServer.Role.LEADER)).thenReturn((Object)TEST_CONCURRENCY_CONTROL.createCompletedFuture());
        Mockito.when((Object)mockStepAfter.transitionTo(this.mockContext, 1L, RaftServer.Role.LEADER)).thenReturn((Object)TEST_CONCURRENCY_CONTROL.createCompletedFuture());
        ActorFuture transition3Future = sut.transitionTo(1L, RaftServer.Role.LEADER);
        testFutureOfFirstStepInSecondTransition.complete(null);
        ((StreamProcessor)Mockito.verify((Object)mockStreamProcessor1)).closeAsync();
        ((StreamProcessor)Mockito.verify((Object)mockStreamProcessor2, (VerificationMode)Mockito.never())).closeAsync();
    }

    private final class WaitingTransitionStep
    implements PartitionTransitionStep {
        private final ConcurrencyControl concurrencyControl;
        private ActorFuture<Void> transitionFuture;
        private int invocationCount = 0;

        private WaitingTransitionStep(PartitionTransitionImplTest partitionTransitionImplTest, ConcurrencyControl concurrencyControl) {
            this.concurrencyControl = concurrencyControl;
        }

        public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
            ActorFuture cleanupFuture = this.concurrencyControl.createFuture();
            cleanupFuture.complete(null);
            return cleanupFuture;
        }

        public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
            ++this.invocationCount;
            if (this.invocationCount == 1) {
                this.transitionFuture = this.concurrencyControl.createFuture();
                return this.transitionFuture;
            }
            return this.concurrencyControl.createCompletedFuture();
        }

        public String getName() {
            return "WaitingTransitionStep";
        }

        public void unblock() {
            this.transitionFuture.complete(null);
        }
    }
}

