/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.camunda.zeebe.broker.system.partitions.impl.RandomDuration;
import java.time.Duration;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class RandomDurationTest {
    @Test
    public void shouldGetRandomDuration() {
        Duration minDuration = Duration.ofMinutes(1L);
        Duration maxDuration = Duration.ofMinutes(10L);
        Duration randomDuration = RandomDuration.getRandomDurationMinuteBased((Duration)minDuration, (Duration)maxDuration);
        Assertions.assertThat((Duration)randomDuration).isBetween((Comparable)minDuration, (Comparable)maxDuration);
    }

    @Test
    public void shouldGetRandomDurationOnNegativeMin() {
        Duration minDuration = Duration.ofMinutes(-1L);
        Duration maxDuration = Duration.ofMinutes(10L);
        Duration randomDuration = RandomDuration.getRandomDurationMinuteBased((Duration)minDuration, (Duration)maxDuration);
        Assertions.assertThat((Duration)randomDuration).isBetween((Comparable)minDuration, (Comparable)maxDuration);
    }

    @Test
    public void shouldGetRandomDurationOnNegativeDurations() {
        Duration minDuration = Duration.ofMinutes(-10L);
        Duration maxDuration = Duration.ofMinutes(-1L);
        Duration randomDuration = RandomDuration.getRandomDurationMinuteBased((Duration)minDuration, (Duration)maxDuration);
        Assertions.assertThat((Duration)randomDuration).isBetween((Comparable)minDuration, (Comparable)maxDuration);
    }

    @Test
    public void shouldGetMinDurationWhenMaxDurationIsSmaller() {
        Duration minDuration = Duration.ofMinutes(10L);
        Duration maxDuration = Duration.ofMinutes(1L);
        Duration randomDuration = RandomDuration.getRandomDurationMinuteBased((Duration)minDuration, (Duration)maxDuration);
        Assertions.assertThat((Duration)randomDuration).isEqualTo((Object)minDuration);
    }

    @Test
    public void shouldGetMinDurationWhenDiffIsOnlySeconds() {
        Duration minDuration = Duration.ofMinutes(1L);
        Duration maxDuration = Duration.ofSeconds(90L);
        Duration randomDuration = RandomDuration.getRandomDurationMinuteBased((Duration)minDuration, (Duration)maxDuration);
        Assertions.assertThat((Duration)randomDuration).isEqualTo((Object)minDuration);
    }

    @Test
    public void shouldGetMinDurationWhenMaxDurationIsEquals() {
        Duration minDuration = Duration.ofMinutes(1L);
        Duration randomDuration = RandomDuration.getRandomDurationMinuteBased((Duration)minDuration, (Duration)minDuration);
        Assertions.assertThat((Duration)randomDuration).isEqualTo((Object)minDuration);
    }
}

