/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.atomix.raft.RaftServer;
import io.camunda.zeebe.broker.system.partitions.PartitionTransition;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.PartitionTransitionStep;
import io.camunda.zeebe.broker.system.partitions.StateController;
import io.camunda.zeebe.broker.system.partitions.TestPartitionTransitionContext;
import io.camunda.zeebe.broker.system.partitions.impl.PartitionTransitionImpl;
import io.camunda.zeebe.broker.system.partitions.impl.steps.StreamProcessorTransitionStep;
import io.camunda.zeebe.broker.system.partitions.impl.steps.ZeebeDbPartitionTransitionStep;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.future.CompletableActorFuture;
import io.camunda.zeebe.snapshots.TransientSnapshot;
import io.camunda.zeebe.stream.impl.StreamProcessor;
import io.camunda.zeebe.util.health.HealthMonitor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.ForAll;
import net.jqwik.api.GenerationMode;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import net.jqwik.api.lifecycle.AfterTry;
import net.jqwik.api.lifecycle.BeforeTry;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomizedPartitionTransitionTest {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomizedPartitionTransitionTest.class);
    private ActorScheduler actorScheduler;
    private TestActor actor;

    @BeforeTry
    public void beforeTry() {
        this.actorScheduler = ActorScheduler.newActorScheduler().build();
        this.actorScheduler.start();
        this.actor = new TestActor();
        this.actorScheduler.submitActor((Actor)this.actor);
    }

    @Property(generation=GenerationMode.RANDOMIZED)
    void atMostOneStreamProcessorIsRunningAtAnyTime(@ForAll(value="testOperations") List<TestOperation> operations) {
        LOGGER.debug(String.format("Testing property 'atMostOneStreamProcessorIsRunningAtAnyTime' on sequence %s", operations));
        PropertyAssertingInstanceTracker<StreamProcessor> instanceTracker = new PropertyAssertingInstanceTracker<StreamProcessor>(this){

            @Override
            void assertProperties() {
                if (this.opened.size() > 1) {
                    throw new IllegalStateException("More than one stream processors opened at the same time");
                }
            }
        };
        PausableStep firstStep = new PausableStep(operations);
        StreamProcessorTransitionStep streamProcessorStep = new StreamProcessorTransitionStep((arg_0, arg_1) -> this.lambda$atMostOneStreamProcessorIsRunningAtAnyTime$0(instanceTracker, arg_0, arg_1));
        TestPartitionTransitionContext context = new TestPartitionTransitionContext();
        context.setComponentHealthMonitor((HealthMonitor)Mockito.mock(HealthMonitor.class));
        PartitionTransitionImpl sut = new PartitionTransitionImpl(List.of(firstStep, streamProcessorStep));
        sut.setConcurrencyControl((ConcurrencyControl)this.actor);
        sut.updateTransitionContext((PartitionTransitionContext)context);
        this.runOperations(operations, sut);
        ((ListAssert)Assertions.assertThat(instanceTracker.getOpenedInstances()).describedAs("Active stream processors at end of transition sequence", new Object[0])).hasSizeLessThan(2);
    }

    @Property(generation=GenerationMode.RANDOMIZED)
    void atMostOneZeebeDbIsOpenAtAnyTime(@ForAll(value="testOperations") List<TestOperation> operations) {
        LOGGER.debug(String.format("Testing property 'atMostOneZeebeDbIsOpenAtAnyTime' on sequence %s", operations));
        PropertyAssertingInstanceTracker<ZeebeDb> instanceTracker = new PropertyAssertingInstanceTracker<ZeebeDb>(this){

            @Override
            void assertProperties() {
                if (this.opened.size() > 1) {
                    throw new IllegalStateException("More than one zeebe db opened at the same time");
                }
            }
        };
        PausableStep firstStep = new PausableStep(operations);
        ZeebeDbPartitionTransitionStep zeebeDbStep = new ZeebeDbPartitionTransitionStep();
        TestPartitionTransitionContext context = new TestPartitionTransitionContext();
        context.setStateController(new TestStateController(instanceTracker));
        PartitionTransitionImpl sut = new PartitionTransitionImpl(List.of(firstStep, zeebeDbStep));
        sut.setConcurrencyControl((ConcurrencyControl)this.actor);
        sut.updateTransitionContext((PartitionTransitionContext)context);
        this.runOperations(operations, sut);
        ((ListAssert)Assertions.assertThat(instanceTracker.getOpenedInstances()).describedAs("Zeebe DB processes at end of transition sequence", new Object[0])).hasSizeLessThan(2);
    }

    @AfterTry
    public void afterTry() {
        this.actorScheduler.stop();
        Mockito.framework().clearInlineMocks();
    }

    private void runOperations(List<TestOperation> operations, PartitionTransitionImpl sut) {
        ArrayList<CountDownLatch> pausedSteps = new ArrayList<CountDownLatch>();
        ArrayList<ActorFuture> transitionFutures = new ArrayList<ActorFuture>();
        ActorFuture latestTransitionFuture = null;
        for (int index = 0; index < operations.size(); ++index) {
            TestOperation operation = operations.get(index);
            if (operation instanceof RequestTransition) {
                RequestTransition requestTransition = (RequestTransition)operation;
                latestTransitionFuture = sut.transitionTo((long)index, requestTransition.getRole());
                transitionFutures.add(latestTransitionFuture);
                if (requestTransition.isPause()) {
                    pausedSteps.add(requestTransition.getCountDownLatch());
                    continue;
                }
                requestTransition.getCountDownLatch().countDown();
                continue;
            }
            this.catchUp(latestTransitionFuture, pausedSteps);
        }
        transitionFutures.forEach(caf -> {
            Throwable exception;
            if (caf.isCompletedExceptionally() && !((exception = caf.getException()) instanceof PartitionTransition.CancelledPartitionTransition)) {
                throw new RuntimeException("Transition future completed exceptionally", exception);
            }
        });
    }

    private void catchUp(ActorFuture<Void> latestTransitionFuture, ArrayList<CountDownLatch> pausedSteps) {
        if (latestTransitionFuture == null) {
            return;
        }
        while (!latestTransitionFuture.isDone()) {
            ArrayList<CountDownLatch> stepsToResume = new ArrayList<CountDownLatch>(pausedSteps);
            pausedSteps.clear();
            stepsToResume.forEach(CountDownLatch::countDown);
        }
    }

    @Provide
    Arbitrary<List<TestOperation>> testOperations() {
        Arbitrary kind = Arbitraries.of(TestOperationKind.class);
        Arbitrary role = Arbitraries.of(RaftServer.Role.class);
        Arbitrary operation = Combinators.combine((Arbitrary)kind, (Arbitrary)role).as(this::createTestOperation);
        return operation.list().ofMaxSize(4).filter(list -> list.stream().anyMatch(RequestTransition.class::isInstance)).map(list -> {
            list.add(new CatchUpOperation());
            return list;
        });
    }

    private TestOperation createTestOperation(TestOperationKind kind, RaftServer.Role role) {
        switch (kind.ordinal()) {
            case 0: {
                return new RequestTransition(role, false);
            }
            case 1: {
                return new RequestTransition(role, true);
            }
        }
        return new CatchUpOperation();
    }

    private StreamProcessor produceMockStreamProcessor(PropertyAssertingInstanceTracker<StreamProcessor> instanceTracker) {
        StreamProcessor mockStreamProcessor = (StreamProcessor)Mockito.mock(StreamProcessor.class);
        instanceTracker.registerCreation(mockStreamProcessor);
        Mockito.when((Object)mockStreamProcessor.openAsync(ArgumentMatchers.anyBoolean())).thenAnswer(invocation -> {
            instanceTracker.registerOpen(mockStreamProcessor);
            return CompletableActorFuture.completed(null);
        });
        Mockito.when((Object)mockStreamProcessor.closeAsync()).thenAnswer(invocation -> {
            instanceTracker.registerClose(mockStreamProcessor);
            return CompletableActorFuture.completed(null);
        });
        return mockStreamProcessor;
    }

    private /* synthetic */ StreamProcessor lambda$atMostOneStreamProcessorIsRunningAtAnyTime$0(1 instanceTracker, PartitionTransitionContext context, RaftServer.Role role) {
        return this.produceMockStreamProcessor(instanceTracker);
    }

    private static final class TestActor
    extends Actor {
        private TestActor() {
        }

        public String getName() {
            return "RandomizedPartitionTransitionTest.testActor";
        }
    }

    private static final class PausableStep
    implements PartitionTransitionStep {
        final List<TestOperation> operations;

        public PausableStep(List<TestOperation> operations) {
            this.operations = operations;
        }

        public ActorFuture<Void> prepareTransition(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
            return CompletableActorFuture.completed(null);
        }

        public ActorFuture<Void> transitionTo(PartitionTransitionContext context, long term, RaftServer.Role targetRole) {
            TestOperation testOperation = this.operations.get(Long.valueOf(term).intValue());
            RequestTransition requestedTransition = (RequestTransition)testOperation;
            CountDownLatch countdownLatch = requestedTransition.getCountDownLatch();
            CompletableActorFuture transitionFuture = new CompletableActorFuture();
            CompletableFuture.runAsync(() -> {
                try {
                    countdownLatch.await();
                }
                catch (InterruptedException e) {
                    LOGGER.error(e.getMessage(), (Throwable)e);
                }
            }).whenComplete((ok, error) -> {
                if (error != null) {
                    transitionFuture.completeExceptionally(error);
                } else {
                    transitionFuture.complete(null);
                }
            });
            return transitionFuture;
        }

        public String getName() {
            return this.getClass().getSimpleName();
        }
    }

    private static final class TestStateController
    implements StateController {
        private final PropertyAssertingInstanceTracker<ZeebeDb> instanceTracker;
        private ZeebeDb zeebeDb;

        private TestStateController(PropertyAssertingInstanceTracker<ZeebeDb> instanceTracker) {
            this.instanceTracker = instanceTracker;
        }

        public ActorFuture<TransientSnapshot> takeTransientSnapshot(long lowerBoundSnapshotPosition) {
            throw new IllegalStateException("Not implemented");
        }

        public ActorFuture<ZeebeDb> recover() {
            this.zeebeDb = (ZeebeDb)Mockito.mock(ZeebeDb.class);
            this.instanceTracker.registerCreation(this.zeebeDb);
            this.instanceTracker.registerOpen(this.zeebeDb);
            return CompletableActorFuture.completed((Object)this.zeebeDb);
        }

        public ActorFuture<Void> closeDb() {
            if (this.zeebeDb != null) {
                this.instanceTracker.registerClose(this.zeebeDb);
            }
            return CompletableActorFuture.completed(null);
        }

        public void close() throws Exception {
            throw new IllegalStateException("Not implemented");
        }
    }

    private static abstract class PropertyAssertingInstanceTracker<T> {
        final List<T> created = new ArrayList<T>();
        final List<T> opened = new ArrayList<T>();
        final List<T> closed = new ArrayList<T>();

        private PropertyAssertingInstanceTracker() {
        }

        abstract void assertProperties();

        void registerCreation(T instance) {
            this.created.add(instance);
            this.assertProperties();
        }

        void registerOpen(T instance) {
            this.created.remove(instance);
            this.opened.add(instance);
            this.assertProperties();
        }

        void registerClose(T instance) {
            this.opened.remove(instance);
            this.closed.add(instance);
            this.assertProperties();
        }

        List<T> getOpenedInstances() {
            return this.opened;
        }
    }

    private static interface TestOperation {
    }

    private static final class RequestTransition
    implements TestOperation {
        final RaftServer.Role role;
        final boolean pause;
        final CountDownLatch countDownLatch = new CountDownLatch(1);

        private RequestTransition(RaftServer.Role role, boolean pause) {
            this.role = role;
            this.pause = pause;
        }

        RaftServer.Role getRole() {
            return this.role;
        }

        boolean isPause() {
            return this.pause;
        }

        CountDownLatch getCountDownLatch() {
            return this.countDownLatch;
        }

        public int hashCode() {
            int result = this.role.hashCode();
            result = 31 * result + (this.pause ? 1 : 0);
            return result;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RequestTransition that = (RequestTransition)o;
            if (this.pause != that.pause) {
                return false;
            }
            return this.role == that.role;
        }

        public String toString() {
            return "RequestTransition{role=" + String.valueOf(this.role) + ", pause=" + this.pause + "}";
        }
    }

    private static enum TestOperationKind {
        TRANSITION_TO_ROLE_NO_PAUSE,
        TRANSITION_TO_RULE_PAUSED,
        CATCH_UP;

    }

    private static final class CatchUpOperation
    implements TestOperation {
        private CatchUpOperation() {
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o != null && this.getClass() == o.getClass();
        }

        public String toString() {
            return "Catch Up";
        }
    }
}

