/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DbLong;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.DefaultColumnFamily;

public final class RocksDBWrapper {
    private DbString key;
    private DbLong value;
    private ColumnFamily<DbString, DbLong> defaultColumnFamily;

    public void wrap(ZeebeDb<DefaultColumnFamily> db) {
        this.key = new DbString();
        this.value = new DbLong();
        this.defaultColumnFamily = db.createColumnFamily((Enum)DefaultColumnFamily.DEFAULT, db.createContext(), (DbKey)this.key, (DbValue)this.value);
    }

    public int getInt(String key) {
        this.key.wrapString(key);
        DbLong zbLong = (DbLong)this.defaultColumnFamily.get((DbKey)this.key);
        return zbLong != null ? (int)zbLong.getValue() : -1;
    }

    public void putInt(String key, int value) {
        this.key.wrapString(key);
        this.value.wrapLong((long)value);
        this.defaultColumnFamily.upsert((DbKey)this.key, (DbValue)this.value);
    }
}

