/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl;

import io.atomix.raft.storage.log.entry.RaftEntry;
import io.atomix.raft.storage.log.entry.SerializedApplicationEntry;
import io.camunda.zeebe.broker.system.partitions.AtomixRecordEntrySupplier;
import io.camunda.zeebe.broker.system.partitions.NoEntryAtSnapshotPosition;
import io.camunda.zeebe.broker.system.partitions.TestIndexedRaftLogEntry;
import io.camunda.zeebe.broker.system.partitions.impl.RocksDBWrapper;
import io.camunda.zeebe.broker.system.partitions.impl.StateControllerImpl;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.db.impl.DefaultColumnFamily;
import io.camunda.zeebe.engine.state.DefaultZeebeDbFactory;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.scheduler.future.ActorFuture;
import io.camunda.zeebe.scheduler.testing.ActorSchedulerRule;
import io.camunda.zeebe.snapshots.ConstructableSnapshotStore;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.SnapshotException;
import io.camunda.zeebe.snapshots.SnapshotId;
import io.camunda.zeebe.snapshots.TransientSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotId;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStore;
import io.camunda.zeebe.test.util.AutoCloseableRule;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Stream;
import org.agrona.DirectBuffer;
import org.agrona.collections.MutableLong;
import org.agrona.concurrent.UnsafeBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public final class StateControllerImplTest {
    @Rule
    public final TemporaryFolder tempFolderRule = new TemporaryFolder();
    @Rule
    public final AutoCloseableRule autoCloseableRule = new AutoCloseableRule();
    @Rule
    public final ActorSchedulerRule actorSchedulerRule = new ActorSchedulerRule();
    private final MutableLong exporterPosition = new MutableLong(Long.MAX_VALUE);
    private StateControllerImpl snapshotController;
    private FileBasedSnapshotStore store;
    private Path runtimeDirectory;
    private final AtomixRecordEntrySupplier indexedRaftLogEntry = l -> Optional.of(new TestIndexedRaftLogEntry(l, 1L, (RaftEntry)new SerializedApplicationEntry(1L, 10L, (DirectBuffer)new UnsafeBuffer())));
    private final AtomixRecordEntrySupplier emptyEntrySupplier = l -> Optional.empty();
    private final AtomicReference<AtomixRecordEntrySupplier> atomixRecordEntrySupplier = new AtomicReference<AtomixRecordEntrySupplier>(this.indexedRaftLogEntry);

    @Before
    public void setup() throws IOException {
        this.store = new FileBasedSnapshotStore(1, this.tempFolderRule.newFolder("data").toPath(), snapshotPath -> Map.of(), (MeterRegistry)new SimpleMeterRegistry());
        this.actorSchedulerRule.submitActor((Actor)this.store).join();
        this.runtimeDirectory = this.tempFolderRule.getRoot().toPath().resolve("runtime");
        this.snapshotController = new StateControllerImpl(DefaultZeebeDbFactory.defaultFactory(), (ConstructableSnapshotStore)this.store, this.runtimeDirectory, l -> this.atomixRecordEntrySupplier.get().getPreviousIndexedEntry(l), db -> this.exporterPosition.get(), (ConcurrencyControl)this.store);
        this.autoCloseableRule.manage((AutoCloseable)this.snapshotController);
    }

    @Test
    public void shouldNotTakeSnapshotIfDbIsClosed() {
        Assertions.assertThat((boolean)this.snapshotController.isDbOpened()).isFalse();
        Assertions.assertThatThrownBy(() -> this.snapshotController.takeTransientSnapshot(1L).join()).hasCauseInstanceOf(SnapshotException.StateClosedException.class);
    }

    @Test
    public void shouldNotTakeSnapshotIfNoIndexedEntry() {
        this.atomixRecordEntrySupplier.set(this.emptyEntrySupplier);
        this.snapshotController.recover().join();
        Assertions.assertThatThrownBy(() -> this.snapshotController.takeTransientSnapshot(1L).join()).hasCauseInstanceOf(NoEntryAtSnapshotPosition.class);
    }

    @Test
    public void shouldTakeTempSnapshotWithExporterPosition() {
        boolean snapshotPosition = true;
        this.exporterPosition.set(0L);
        this.snapshotController.recover().join();
        TransientSnapshot tmpSnapshot = (TransientSnapshot)this.snapshotController.takeTransientSnapshot(1L).join();
        PersistedSnapshot snapshot = (PersistedSnapshot)tmpSnapshot.persist().join();
        Assertions.assertThat((Object)snapshot).extracting(PersistedSnapshot::getCompactionBound).isEqualTo((Object)this.exporterPosition.get());
    }

    @Test
    public void shouldTakeTempSnapshot() throws Exception {
        String key = "test";
        int value = 3;
        RocksDBWrapper wrapper = new RocksDBWrapper();
        long snapshotPosition = 2L;
        this.exporterPosition.set(3L);
        wrapper.wrap((ZeebeDb<DefaultColumnFamily>)((ZeebeDb)this.snapshotController.recover().join()));
        wrapper.putInt("test", 3);
        TransientSnapshot tmpSnapshot = (TransientSnapshot)this.snapshotController.takeTransientSnapshot(2L).join();
        tmpSnapshot.persist().join();
        this.snapshotController.close();
        wrapper.wrap((ZeebeDb<DefaultColumnFamily>)((ZeebeDb)this.snapshotController.recover().join()));
        Assertions.assertThat((int)wrapper.getInt("test")).isEqualTo(3);
    }

    @Test
    public void shouldTakeSnapshotWithExporterPosition() {
        boolean snapshotPosition = true;
        this.exporterPosition.set(0L);
        this.snapshotController.recover();
        File snapshot = this.takeSnapshot(1L);
        Assertions.assertThat((String)snapshot.getName()).contains(new CharSequence[]{this.exporterPosition.toString()});
    }

    @Test
    public void shouldTakeSnapshot() throws Exception {
        String key = "test";
        int value = 3;
        RocksDBWrapper wrapper = new RocksDBWrapper();
        int snapshotPosition = 2;
        this.exporterPosition.set(3L);
        wrapper.wrap((ZeebeDb<DefaultColumnFamily>)((ZeebeDb)this.snapshotController.recover().join()));
        wrapper.putInt("test", 3);
        this.takeSnapshot(2L);
        this.snapshotController.close();
        wrapper.wrap((ZeebeDb<DefaultColumnFamily>)((ZeebeDb)this.snapshotController.recover().join()));
        Assertions.assertThat((int)wrapper.getInt("test")).isEqualTo(3);
    }

    @Test
    public void shouldTakeSnapshotWhenExporterPositionNotChanged() {
        int snapshotPosition = 2;
        this.exporterPosition.set(1L);
        this.snapshotController.recover().join();
        PersistedSnapshot firstSnapshot = (PersistedSnapshot)((TransientSnapshot)this.snapshotController.takeTransientSnapshot(2L).join()).persist().join();
        TransientSnapshot tmpSnapshot = (TransientSnapshot)this.snapshotController.takeTransientSnapshot(3L).join();
        PersistedSnapshot snapshot = (PersistedSnapshot)tmpSnapshot.persist().join();
        Assertions.assertThat((Object)snapshot).extracting(PersistedSnapshot::getCompactionBound).isEqualTo((Object)firstSnapshot.getCompactionBound());
        Assertions.assertThat((String)snapshot.getId()).isNotEqualTo((Object)firstSnapshot.getId());
        FileBasedSnapshotId newSnapshotId = (FileBasedSnapshotId)FileBasedSnapshotId.ofFileName((String)snapshot.getId()).orElseThrow();
        FileBasedSnapshotId firstSnapshotId = (FileBasedSnapshotId)FileBasedSnapshotId.ofFileName((String)firstSnapshot.getId()).orElseThrow();
        Assertions.assertThat((Comparable)firstSnapshotId).isLessThan((Comparable)newSnapshotId);
    }

    @Test
    public void shouldTakeSnapshotWithoutIndexedEntryWhenProcessedPositionChanged() {
        int snapshotPosition = 2;
        this.exporterPosition.set(1L);
        this.snapshotController.recover().join();
        PersistedSnapshot firstSnapshot = (PersistedSnapshot)((TransientSnapshot)this.snapshotController.takeTransientSnapshot(2L).join()).persist().join();
        this.atomixRecordEntrySupplier.set(this.emptyEntrySupplier);
        PersistedSnapshot snapshot = (PersistedSnapshot)((TransientSnapshot)this.snapshotController.takeTransientSnapshot(3L).join()).persist().join();
        Assertions.assertThat((Object)snapshot).extracting(PersistedSnapshot::getCompactionBound).isEqualTo((Object)firstSnapshot.getCompactionBound());
        Assertions.assertThat((String)snapshot.getId()).isNotEqualTo((Object)firstSnapshot.getId());
        FileBasedSnapshotId newSnapshotId = (FileBasedSnapshotId)FileBasedSnapshotId.ofFileName((String)snapshot.getId()).orElseThrow();
        FileBasedSnapshotId firstSnapshotId = (FileBasedSnapshotId)FileBasedSnapshotId.ofFileName((String)firstSnapshot.getId()).orElseThrow();
        Assertions.assertThat((long)newSnapshotId.getExportedPosition()).isEqualTo(firstSnapshotId.getExportedPosition());
        Assertions.assertThat((long)newSnapshotId.getProcessedPosition()).isGreaterThan(firstSnapshotId.getProcessedPosition());
    }

    @Test
    public void shouldTakeSnapshotWhenProcessorPositionNotChanged() {
        int snapshotPosition = 2;
        this.exporterPosition.set(2L);
        this.snapshotController.recover().join();
        PersistedSnapshot firstSnapshot = (PersistedSnapshot)((TransientSnapshot)this.snapshotController.takeTransientSnapshot(2L).join()).persist().join();
        this.exporterPosition.set(3L);
        TransientSnapshot tmpSnapshot = (TransientSnapshot)this.snapshotController.takeTransientSnapshot(2L).join();
        PersistedSnapshot snapshot = (PersistedSnapshot)tmpSnapshot.persist().join();
        Assertions.assertThat((Object)snapshot).extracting(PersistedSnapshot::getCompactionBound).isEqualTo((Object)firstSnapshot.getCompactionBound());
        Assertions.assertThat((String)snapshot.getId()).isNotEqualTo((Object)firstSnapshot.getId());
        FileBasedSnapshotId newSnapshotId = (FileBasedSnapshotId)FileBasedSnapshotId.ofFileName((String)snapshot.getId()).orElseThrow();
        FileBasedSnapshotId firstSnapshotId = (FileBasedSnapshotId)FileBasedSnapshotId.ofFileName((String)firstSnapshot.getId()).orElseThrow();
        Assertions.assertThat((Comparable)firstSnapshotId).isLessThan((Comparable)newSnapshotId);
    }

    @Test
    public void shouldOpenEmptyDatabaseWhenNoSnapshotsToRecoverFrom() {
        this.snapshotController.recover().join();
        Assertions.assertThat((boolean)this.snapshotController.isDbOpened()).isTrue();
    }

    @Test
    public void shouldRecoverFromLatestSnapshot() throws Exception {
        RocksDBWrapper wrapper = new RocksDBWrapper();
        wrapper.wrap((ZeebeDb<DefaultColumnFamily>)((ZeebeDb)this.snapshotController.recover().join()));
        wrapper.putInt("x", 1);
        this.takeSnapshot(1L);
        wrapper.putInt("x", 2);
        this.takeSnapshot(2L);
        wrapper.putInt("x", 3);
        this.takeSnapshot(3L);
        this.snapshotController.close();
        wrapper.wrap((ZeebeDb<DefaultColumnFamily>)((ZeebeDb)this.snapshotController.recover().join()));
        Assertions.assertThat((int)wrapper.getInt("x")).isEqualTo(3);
    }

    @Test
    public void shouldFailToRecoverIfSnapshotIsCorrupted() throws Exception {
        RocksDBWrapper wrapper = new RocksDBWrapper();
        wrapper.wrap((ZeebeDb<DefaultColumnFamily>)((ZeebeDb)this.snapshotController.recover().join()));
        wrapper.putInt("x", 1);
        this.takeSnapshot(1L);
        this.snapshotController.close();
        this.corruptLatestSnapshot();
        Assertions.assertThatThrownBy(() -> this.snapshotController.recover().join()).hasCauseInstanceOf(RuntimeException.class);
    }

    @Test
    public void shouldDeleteRuntimeFolderOnClose() {
        this.snapshotController.recover().join();
        this.snapshotController.closeDb().join();
        Assertions.assertThat((Path)this.runtimeDirectory).doesNotExist();
    }

    @Test
    public void shouldNotTakeSnapshotWhenDbIsClosed() {
        this.snapshotController.recover().join();
        ActorFuture closed = this.snapshotController.closeDb();
        ActorFuture snapshotTaken = this.snapshotController.takeTransientSnapshot(1L);
        closed.join();
        Assertions.assertThatThrownBy(() -> ((ActorFuture)snapshotTaken).join()).hasCauseInstanceOf(SnapshotException.StateClosedException.class);
    }

    @Test
    public void shouldCloseDbOnlyAfterTakingSnapshot() {
        this.snapshotController.recover().join();
        ActorFuture snapshotTaken = this.snapshotController.takeTransientSnapshot(1L);
        ActorFuture closed = this.snapshotController.closeDb();
        closed.join();
        Assertions.assertThatNoException().isThrownBy(() -> ((ActorFuture)snapshotTaken).join());
    }

    @Test
    public void shouldSetExporterPositionToZero() {
        this.snapshotController.recover().join();
        this.exporterPosition.set(-1L);
        long snapshotPosition = 5L;
        TransientSnapshot transientSnapshot = (TransientSnapshot)this.snapshotController.takeTransientSnapshot(5L).join();
        SnapshotId snapshot = transientSnapshot.snapshotId();
        Assertions.assertThat((long)snapshot.getIndex()).isEqualTo(0L);
        Assertions.assertThat((long)snapshot.getTerm()).isEqualTo(0L);
        Assertions.assertThat((long)snapshot.getProcessedPosition()).isEqualTo(5L);
        Assertions.assertThat((long)snapshot.getExportedPosition()).isEqualTo(0L);
    }

    @Test
    public void shouldKeepIndexAndTerm() {
        this.snapshotController.recover().join();
        long snapshotPosition = 5L;
        this.exporterPosition.set(4L);
        this.takeSnapshot(5L);
        PersistedSnapshot latestSnapshot = (PersistedSnapshot)this.store.getLatestSnapshot().get();
        this.exporterPosition.set(-1L);
        TransientSnapshot transientSnapshot = (TransientSnapshot)this.snapshotController.takeTransientSnapshot(5L).join();
        SnapshotId snapshot = transientSnapshot.snapshotId();
        Assertions.assertThat((long)snapshot.getIndex()).isEqualTo(latestSnapshot.getIndex());
        Assertions.assertThat((long)snapshot.getTerm()).isEqualTo(latestSnapshot.getTerm());
        Assertions.assertThat((long)snapshot.getProcessedPosition()).isEqualTo(5L);
        Assertions.assertThat((long)snapshot.getExportedPosition()).isEqualTo(0L);
    }

    private File takeSnapshot(long position) {
        TransientSnapshot snapshot = (TransientSnapshot)this.snapshotController.takeTransientSnapshot(position).join();
        return ((PersistedSnapshot)snapshot.persist().join()).getPath().toFile();
    }

    private void corruptLatestSnapshot() throws IOException {
        Optional snapshot = this.store.getLatestSnapshot();
        Path path = ((PersistedSnapshot)snapshot.orElseThrow()).getPath();
        try (Stream<Path> files = Files.list(path);){
            Path file = files.filter(p -> p.toString().endsWith(".sst")).max(Comparator.naturalOrder()).orElseThrow();
            Files.write(file, "<--corrupted-->".getBytes(), StandardOpenOption.TRUNCATE_EXISTING);
        }
    }
}

