/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.perf;

import io.camunda.zeebe.broker.system.partitions.impl.StateControllerImpl;
import io.camunda.zeebe.broker.system.partitions.impl.perf.TestState;
import io.camunda.zeebe.db.ZeebeDb;
import io.camunda.zeebe.scheduler.ConcurrencyControl;
import io.camunda.zeebe.snapshots.ConstructableSnapshotStore;
import io.camunda.zeebe.test.util.jmh.JMHAssert;
import io.camunda.zeebe.test.util.jmh.JMHTestCase;
import io.camunda.zeebe.test.util.junit.JMHTest;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Warmup(iterations=50, time=1)
@Measurement(iterations=25, time=1)
@Fork(value=1, jvmArgs={"-Xmx4g", "-Xms4g"})
@BenchmarkMode(value={Mode.Throughput})
@OutputTimeUnit(value=TimeUnit.SECONDS)
@State(value=Scope.Benchmark)
public class LargeStateControllerPerformanceTest {
    private static final Logger LOG = LoggerFactory.getLogger(LargeStateControllerPerformanceTest.class);
    private static final double ONE_GB = Math.pow(2.0, 30.0);
    private static final double SIZE_GB = Double.parseDouble(System.getenv().getOrDefault("LARGE_STATE_CONTROLLER_PERFORMANCE_TEST_SIZE_GB", "0.5"));
    private static final Map<Double, Double> KNOWN_REFERENCE_SCORES = Map.of(0.5, 10.0, 4.0, 10.0);
    private TestState.TestContext context;

    @Setup
    public void setup() throws Throwable {
        long sizeInBytes = Math.round(SIZE_GB * ONE_GB);
        LOG.info("Creating a test state of approximately {}GB; please hold the line...", (Object)SIZE_GB);
        this.context = new TestState().generateContext(sizeInBytes);
        LOG.info("Created a test size with a total size of {}GB", (Object)String.format("%.3f", (double)this.context.snapshotSize() / ONE_GB));
    }

    @TearDown
    public void tearDown() throws Exception {
        this.context.close();
    }

    @JMHTest(value="measureStateRecovery")
    void shouldRecoverStateWithinDeviation(JMHTestCase testCase) {
        Double referenceScore = KNOWN_REFERENCE_SCORES.getOrDefault(SIZE_GB, 0.0);
        ((MapAssert)Assertions.assertThat(KNOWN_REFERENCE_SCORES).as("map of reference scores contains an entry for the desired size", new Object[0])).containsKey((Object)SIZE_GB);
        JMHAssert assertResult = testCase.run();
        assertResult.isAtLeast(referenceScore.doubleValue(), 0.2);
    }

    @Benchmark
    public Optional<String> measureStateRecovery() throws Exception {
        StateControllerImpl controller = new StateControllerImpl(this.context.dbFactory(), (ConstructableSnapshotStore)this.context.snapshotStore(), this.context.temporaryFolder().resolve("runtime"), ignored -> Optional.empty(), ignored -> 0L, (ConcurrencyControl)this.context.snapshotStore());
        try (ZeebeDb db = (ZeebeDb)controller.recover().join();){
            Optional optional = db.getProperty("rocksdb.estimate-live-data-size");
            return optional;
        }
    }
}

