/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.broker.system.partitions.impl.perf;

import io.camunda.zeebe.db.AccessMetricsConfiguration;
import io.camunda.zeebe.db.ColumnFamily;
import io.camunda.zeebe.db.ConsistencyChecksSettings;
import io.camunda.zeebe.db.DbKey;
import io.camunda.zeebe.db.DbValue;
import io.camunda.zeebe.db.TransactionContext;
import io.camunda.zeebe.db.ZeebeDbFactory;
import io.camunda.zeebe.db.impl.DbString;
import io.camunda.zeebe.db.impl.rocksdb.RocksDbConfiguration;
import io.camunda.zeebe.db.impl.rocksdb.ZeebeRocksDbFactory;
import io.camunda.zeebe.db.impl.rocksdb.transaction.ZeebeTransactionDb;
import io.camunda.zeebe.protocol.ZbColumnFamilies;
import io.camunda.zeebe.scheduler.Actor;
import io.camunda.zeebe.scheduler.ActorScheduler;
import io.camunda.zeebe.snapshots.ConstructableSnapshotStore;
import io.camunda.zeebe.snapshots.TransientSnapshot;
import io.camunda.zeebe.snapshots.impl.FileBasedSnapshotStore;
import io.camunda.zeebe.util.FileUtil;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Stream;
import org.agrona.CloseHelper;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

final class TestState {
    private static final int BATCH_INSERT_SIZE = 10000;
    private static final int KEY_VALUE_SIZE = 8096;

    TestState() {
    }

    TestContext generateContext(long sizeInBytes) throws Exception {
        Path tempDirectory = Files.createTempDirectory("statePerf", new FileAttribute[0]);
        ActorScheduler actorScheduler = ActorScheduler.newActorScheduler().setIoBoundActorThreadCount(1).setCpuBoundActorThreadCount(1).build();
        actorScheduler.start();
        FileBasedSnapshotStore snapshotStore = new FileBasedSnapshotStore(1, tempDirectory, snapshotPath -> Map.of(), (MeterRegistry)new SimpleMeterRegistry());
        actorScheduler.submitActor((Actor)snapshotStore).join();
        this.generateSnapshot((ConstructableSnapshotStore)snapshotStore, sizeInBytes);
        return new TestContext(actorScheduler, tempDirectory, snapshotStore, (ZeebeDbFactory<ZbColumnFamilies>)this.createDbFactory());
    }

    private void generateSnapshot(ConstructableSnapshotStore snapshotStore, long sizeInBytes) {
        TransientSnapshot snapshot = (TransientSnapshot)snapshotStore.newTransientSnapshot(1L, 1L, 1L, 1L).get();
        snapshot.take(path -> this.generateSnapshot((Path)path, sizeInBytes)).join();
        snapshot.persist().join();
    }

    private void generateSnapshot(Path path, long sizeInBytes) {
        ZeebeRocksDbFactory<ZbColumnFamilies> dbFactory = this.createDbFactory();
        path.toFile().mkdirs();
        do {
            try (ZeebeTransactionDb db = dbFactory.createDb(path.toFile());){
                TransactionContext txn = db.createContext();
                List<ColumnFamily> columns = Arrays.stream(ZbColumnFamilies.values()).map(col -> db.createColumnFamily((Enum)col, txn, (DbKey)new DbString(), (DbValue)new DbString())).toList();
                txn.runInTransaction(() -> this.insertData(columns));
            }
        } while (TestState.computeSnapshotSize(path) < sizeInBytes);
    }

    private ZeebeRocksDbFactory<ZbColumnFamilies> createDbFactory() {
        return new ZeebeRocksDbFactory(new RocksDbConfiguration(), new ConsistencyChecksSettings(false, false), new AccessMetricsConfiguration(AccessMetricsConfiguration.Kind.NONE, 1), ZeebeRocksDbFactory.StatefulMeterRegistryProvider.defaultProvider());
    }

    private void insertData(List<ColumnFamily<DbString, DbString>> columns) {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        for (int i = 0; i < 10000; ++i) {
            ColumnFamily<DbString, DbString> column = columns.get(random.nextInt(columns.size()));
            column.insert((DbKey)this.generateData(), (DbValue)this.generateData());
        }
    }

    private DbString generateData() {
        byte[] buffer = new byte[8096];
        DbString data = new DbString();
        ThreadLocalRandom.current().nextBytes(buffer);
        data.wrapBuffer((DirectBuffer)new UnsafeBuffer(buffer));
        return data;
    }

    private static long computeSnapshotSize(Path root) {
        long l;
        block8: {
            Stream<Path> files = Files.walk(root, new FileVisitOption[0]);
            try {
                l = files.mapToLong(TestState::uncheckedFileSize).sum();
                if (files == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (files != null) {
                        try {
                            files.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            files.close();
        }
        return l;
    }

    private static long uncheckedFileSize(Path file) {
        try {
            return Files.size(file);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public record TestContext(ActorScheduler actorScheduler, Path temporaryFolder, FileBasedSnapshotStore snapshotStore, ZeebeDbFactory<ZbColumnFamilies> dbFactory) implements AutoCloseable
    {
        @Override
        public void close() throws Exception {
            CloseHelper.quietCloseAll((AutoCloseable[])new AutoCloseable[]{this.snapshotStore, this.actorScheduler});
            FileUtil.deleteFolder((Path)this.temporaryFolder);
        }

        public long snapshotSize() {
            return TestState.computeSnapshotSize(this.temporaryFolder);
        }
    }
}

